/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.hunspell.AffixCondition;
import org.apache.lucene.analysis.hunspell.AffixKind;
import org.apache.lucene.analysis.hunspell.CheckCompoundPattern;
import org.apache.lucene.analysis.hunspell.CompoundRule;
import org.apache.lucene.analysis.hunspell.ConvTable;
import org.apache.lucene.analysis.hunspell.DictEntries;
import org.apache.lucene.analysis.hunspell.FlagEnumerator;
import org.apache.lucene.analysis.hunspell.ISO8859_14Decoder;
import org.apache.lucene.analysis.hunspell.RepEntry;
import org.apache.lucene.analysis.hunspell.WordCase;
import org.apache.lucene.analysis.hunspell.WordStorage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.OfflineSorter;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.IntSequenceOutputs;
import org.apache.lucene.util.fst.Util;

public class Dictionary {
    static final int MAX_PROLOGUE_SCAN_WINDOW = 30720;
    static final char[] NOFLAGS = new char[0];
    static final char FLAG_UNSET = '\u0000';
    private static final int DEFAULT_FLAGS = 65510;
    static final char HIDDEN_FLAG = '\uffe7';
    static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    CharsetDecoder decoder = Dictionary.replacingDecoder(DEFAULT_CHARSET);
    FST<IntsRef> prefixes;
    FST<IntsRef> suffixes;
    Breaks breaks = Breaks.DEFAULT;
    ArrayList<AffixCondition> patterns = new ArrayList();
    WordStorage words;
    final FlagEnumerator.Lookup flagLookup;
    char[] stripData;
    int[] stripOffsets;
    String wordChars = "";
    char[] affixData = new char[32];
    private int currentAffix = 0;
    static final int AFFIX_FLAG = 0;
    static final int AFFIX_STRIP_ORD = 1;
    private static final int AFFIX_CONDITION = 2;
    static final int AFFIX_APPEND = 3;
    FlagParsingStrategy flagParsingStrategy = new SimpleFlagParsingStrategy();
    private String[] aliases;
    private int aliasCount = 0;
    private String[] morphAliases;
    private int morphAliasCount = 0;
    final List<String> morphData = new ArrayList<String>(Collections.singletonList(""));
    boolean hasCustomMorphData;
    boolean ignoreCase;
    boolean checkSharpS;
    boolean complexPrefixes;
    private char[] secondStagePrefixFlags;
    private char[] secondStageSuffixFlags;
    char circumfix;
    char keepcase;
    char forceUCase;
    char needaffix;
    char forbiddenword;
    char onlyincompound;
    char compoundBegin;
    char compoundMiddle;
    char compoundEnd;
    char compoundFlag;
    char compoundPermit;
    char compoundForbid;
    boolean checkCompoundCase;
    boolean checkCompoundDup;
    boolean checkCompoundRep;
    boolean checkCompoundTriple;
    boolean simplifiedTriple;
    int compoundMin = 3;
    int compoundMax = Integer.MAX_VALUE;
    List<CompoundRule> compoundRules;
    List<CheckCompoundPattern> checkCompoundPatterns = new ArrayList<CheckCompoundPattern>();
    private char[] ignore;
    String tryChars = "";
    String[] neighborKeyGroups = new String[]{"qwertyuiop", "asdfghjkl", "zxcvbnm"};
    boolean enableSplitSuggestions = true;
    List<RepEntry> repTable = new ArrayList<RepEntry>();
    List<List<String>> mapTable = new ArrayList<List<String>>();
    int maxDiff = 5;
    int maxNGramSuggestions = 4;
    boolean onlyMaxDiff;
    char noSuggest;
    char subStandard;
    ConvTable iconv;
    ConvTable oconv;
    boolean fullStrip;
    String language;
    private boolean alternateCasing;
    private static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    static final Map<String, String> CHARSET_ALIASES = new HashMap<String, String>();
    private static final char FLAG_SEPARATOR = '\u001f';
    private static final char MORPH_SEPARATOR = '\u001e';

    public Dictionary(Directory tempDir, String tempFileNamePrefix, InputStream affix, InputStream dictionary) throws IOException, ParseException {
        this(tempDir, tempFileNamePrefix, affix, Collections.singletonList(dictionary), false);
    }

    public Dictionary(Directory tempDir, String tempFileNamePrefix, InputStream affix, List<InputStream> dictionaries, boolean ignoreCase) throws IOException, ParseException {
        this.ignoreCase = ignoreCase;
        try (BufferedInputStream affixStream = new BufferedInputStream(affix, 30720){

            @Override
            public void close() {
            }
        };){
            Charset streamCharset = Dictionary.maybeConsume(affixStream, BOM_UTF8) ? StandardCharsets.UTF_8 : DEFAULT_CHARSET;
            affixStream.mark(30720);
            byte[] prologue = new byte[30719];
            int count = affixStream.read(prologue);
            affixStream.reset();
            this.readConfig(new ByteArrayInputStream(prologue, 0, count), streamCharset);
            FlagEnumerator flagEnumerator = new FlagEnumerator();
            this.readAffixFile(affixStream, this.decoder, flagEnumerator);
            IndexOutput unsorted = tempDir.createTempOutput(tempFileNamePrefix, "dat", IOContext.DEFAULT);
            int wordCount = this.mergeDictionaries(dictionaries, this.decoder, unsorted);
            String sortedFile = this.sortWordsOffline(tempDir, tempFileNamePrefix, unsorted);
            this.words = this.readSortedDictionaries(tempDir, sortedFile, flagEnumerator, wordCount);
            this.flagLookup = flagEnumerator.finish();
            this.aliases = null;
            this.morphAliases = null;
        }
    }

    int formStep() {
        return this.hasCustomMorphData ? 2 : 1;
    }

    IntsRef lookupWord(char[] word, int offset, int length) {
        return this.words.lookupWord(word, offset, length);
    }

    IntsRef lookupPrefix(char[] word) {
        return this.lookup(this.prefixes, word);
    }

    IntsRef lookupSuffix(char[] word) {
        return this.lookup(this.suffixes, word);
    }

    private IntsRef lookup(FST<IntsRef> fst, char[] word) {
        int cp;
        FST.BytesReader bytesReader = fst.getBytesReader();
        FST.Arc<IntsRef> arc = fst.getFirstArc(new FST.Arc());
        IntsRef output = (IntsRef)fst.outputs.getNoOutput();
        for (int i = 0; i < word.length; i += Character.charCount(cp)) {
            cp = Character.codePointAt(word, i, word.length);
            if ((output = Dictionary.nextArc(fst, arc, bytesReader, output, cp)) != null) continue;
            return null;
        }
        return Dictionary.nextArc(fst, arc, bytesReader, output, -1);
    }

    static IntsRef nextArc(FST<IntsRef> fst, FST.Arc<IntsRef> arc, FST.BytesReader reader, IntsRef output, int ch) {
        try {
            if (fst.findTargetArc(ch, arc, arc, reader) == null) {
                return null;
            }
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        return fst.outputs.add(output, arc.output());
    }

    private void readAffixFile(InputStream affixStream, CharsetDecoder decoder, FlagEnumerator flags) throws IOException, ParseException {
        String line;
        TreeMap<String, List<Integer>> prefixes = new TreeMap<String, List<Integer>>();
        TreeMap<String, List<Integer>> suffixes = new TreeMap<String, List<Integer>>();
        HashSet<Character> prefixContFlags = new HashSet<Character>();
        HashSet<Character> suffixContFlags = new HashSet<Character>();
        HashMap<String, Integer> seenPatterns = new HashMap<String, Integer>();
        seenPatterns.put(".*", 0);
        this.patterns.add(null);
        LinkedHashMap<String, Integer> seenStrips = new LinkedHashMap<String, Integer>();
        seenStrips.put("", 0);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(affixStream, decoder));
        while ((line = reader.readLine()) != null) {
            if (reader.getLineNumber() == 1 && line.startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if ((line = line.trim()).isEmpty()) continue;
            String firstWord = line.split("\\s")[0];
            if ("AF".equals(firstWord)) {
                this.parseAlias(line);
                continue;
            }
            if ("AM".equals(firstWord)) {
                this.parseMorphAlias(line);
                continue;
            }
            if ("PFX".equals(firstWord)) {
                this.parseAffix(prefixes, prefixContFlags, line, reader, AffixKind.PREFIX, seenPatterns, seenStrips, flags);
                continue;
            }
            if ("SFX".equals(firstWord)) {
                this.parseAffix(suffixes, suffixContFlags, line, reader, AffixKind.SUFFIX, seenPatterns, seenStrips, flags);
                continue;
            }
            if (line.equals("COMPLEXPREFIXES")) {
                this.complexPrefixes = true;
                continue;
            }
            if ("CIRCUMFIX".equals(firstWord)) {
                this.circumfix = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("KEEPCASE".equals(firstWord)) {
                this.keepcase = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("FORCEUCASE".equals(firstWord)) {
                this.forceUCase = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("NEEDAFFIX".equals(firstWord) || "PSEUDOROOT".equals(firstWord)) {
                this.needaffix = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("ONLYINCOMPOUND".equals(firstWord)) {
                this.onlyincompound = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("CHECKSHARPS".equals(firstWord)) {
                this.checkSharpS = true;
                continue;
            }
            if ("IGNORE".equals(firstWord)) {
                this.ignore = this.singleArgument(reader, line).toCharArray();
                Arrays.sort(this.ignore);
                continue;
            }
            if ("ICONV".equals(firstWord) || "OCONV".equals(firstWord)) {
                int num = this.parseNum(reader, line);
                ConvTable res = this.parseConversions(reader, num);
                if (line.startsWith("I")) {
                    this.iconv = res;
                    continue;
                }
                this.oconv = res;
                continue;
            }
            if ("FULLSTRIP".equals(firstWord)) {
                this.fullStrip = true;
                continue;
            }
            if ("LANG".equals(firstWord)) {
                this.language = this.singleArgument(reader, line);
                this.alternateCasing = this.hasLanguage("tr", "az");
                continue;
            }
            if ("BREAK".equals(firstWord)) {
                this.breaks = this.parseBreaks(reader, line);
                continue;
            }
            if ("WORDCHARS".equals(firstWord)) {
                this.wordChars = this.firstArgument(reader, line);
                continue;
            }
            if ("TRY".equals(firstWord)) {
                this.tryChars = this.firstArgument(reader, line);
                continue;
            }
            if ("REP".equals(firstWord)) {
                int count = this.parseNum(reader, line);
                for (int i = 0; i < count; ++i) {
                    String[] parts = this.splitBySpace(reader, reader.readLine(), 3, Integer.MAX_VALUE);
                    this.repTable.add(new RepEntry(parts[1], parts[2]));
                }
                continue;
            }
            if ("MAP".equals(firstWord)) {
                int count = this.parseNum(reader, line);
                for (int i = 0; i < count; ++i) {
                    this.mapTable.add(this.parseMapEntry(reader, reader.readLine()));
                }
                continue;
            }
            if ("KEY".equals(firstWord)) {
                this.neighborKeyGroups = this.singleArgument(reader, line).split("\\|");
                continue;
            }
            if ("NOSPLITSUGS".equals(firstWord)) {
                this.enableSplitSuggestions = false;
                continue;
            }
            if ("MAXNGRAMSUGS".equals(firstWord)) {
                this.maxNGramSuggestions = Integer.parseInt(this.singleArgument(reader, line));
                continue;
            }
            if ("MAXDIFF".equals(firstWord)) {
                int i = Integer.parseInt(this.singleArgument(reader, line));
                if (i < 0 || i > 10) {
                    throw new ParseException("MAXDIFF should be between 0 and 10", reader.getLineNumber());
                }
                this.maxDiff = i;
                continue;
            }
            if ("ONLYMAXDIFF".equals(firstWord)) {
                this.onlyMaxDiff = true;
                continue;
            }
            if ("FORBIDDENWORD".equals(firstWord)) {
                this.forbiddenword = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("NOSUGGEST".equals(firstWord)) {
                this.noSuggest = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("SUBSTANDARD".equals(firstWord)) {
                this.subStandard = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("COMPOUNDMIN".equals(firstWord)) {
                this.compoundMin = Math.max(1, this.parseNum(reader, line));
                continue;
            }
            if ("COMPOUNDWORDMAX".equals(firstWord)) {
                this.compoundMax = Math.max(1, this.parseNum(reader, line));
                continue;
            }
            if ("COMPOUNDRULE".equals(firstWord)) {
                this.compoundRules = this.parseCompoundRules(reader, this.parseNum(reader, line));
                continue;
            }
            if ("COMPOUNDFLAG".equals(firstWord)) {
                this.compoundFlag = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("COMPOUNDBEGIN".equals(firstWord)) {
                this.compoundBegin = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("COMPOUNDMIDDLE".equals(firstWord)) {
                this.compoundMiddle = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("COMPOUNDEND".equals(firstWord)) {
                this.compoundEnd = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("COMPOUNDPERMITFLAG".equals(firstWord)) {
                this.compoundPermit = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("COMPOUNDFORBIDFLAG".equals(firstWord)) {
                this.compoundForbid = this.flagParsingStrategy.parseFlag(this.singleArgument(reader, line));
                continue;
            }
            if ("CHECKCOMPOUNDCASE".equals(firstWord)) {
                this.checkCompoundCase = true;
                continue;
            }
            if ("CHECKCOMPOUNDDUP".equals(firstWord)) {
                this.checkCompoundDup = true;
                continue;
            }
            if ("CHECKCOMPOUNDREP".equals(firstWord)) {
                this.checkCompoundRep = true;
                continue;
            }
            if ("CHECKCOMPOUNDTRIPLE".equals(firstWord)) {
                this.checkCompoundTriple = true;
                continue;
            }
            if ("SIMPLIFIEDTRIPLE".equals(firstWord)) {
                this.simplifiedTriple = true;
                continue;
            }
            if ("CHECKCOMPOUNDPATTERN".equals(firstWord)) {
                int count = this.parseNum(reader, line);
                for (int i = 0; i < count; ++i) {
                    this.checkCompoundPatterns.add(new CheckCompoundPattern(reader.readLine(), this.flagParsingStrategy, this));
                }
                continue;
            }
            if ("SET".equals(firstWord)) {
                this.checkCriticalDirectiveSame("SET", reader, decoder.charset(), this.getDecoder(this.singleArgument(reader, line)).charset());
                continue;
            }
            if (!"FLAG".equals(firstWord)) continue;
            FlagParsingStrategy strategy = Dictionary.getFlagParsingStrategy(line, decoder.charset());
            this.checkCriticalDirectiveSame("FLAG", reader, this.flagParsingStrategy.getClass(), strategy.getClass());
        }
        this.prefixes = this.affixFST(prefixes);
        this.suffixes = this.affixFST(suffixes);
        this.secondStagePrefixFlags = Dictionary.toSortedCharArray(prefixContFlags);
        this.secondStageSuffixFlags = Dictionary.toSortedCharArray(suffixContFlags);
        int totalChars = 0;
        for (String strip : seenStrips.keySet()) {
            totalChars += strip.length();
        }
        this.stripData = new char[totalChars];
        this.stripOffsets = new int[seenStrips.size() + 1];
        int currentOffset = 0;
        int currentIndex = 0;
        for (String strip : seenStrips.keySet()) {
            this.stripOffsets[currentIndex++] = currentOffset;
            strip.getChars(0, strip.length(), this.stripData, currentOffset);
            currentOffset += strip.length();
        }
        assert (currentIndex == seenStrips.size());
        this.stripOffsets[currentIndex] = currentOffset;
    }

    private void checkCriticalDirectiveSame(String directive, LineNumberReader reader, Object expected, Object actual) throws ParseException {
        if (!expected.equals(actual)) {
            throw new ParseException(directive + " directive should occur at most once, and in the first " + 30720 + " bytes of the *.aff file", reader.getLineNumber());
        }
    }

    private List<String> parseMapEntry(LineNumberReader reader, String line) throws ParseException {
        String unparsed = this.firstArgument(reader, line);
        ArrayList<String> mapEntry = new ArrayList<String>();
        for (int j = 0; j < unparsed.length(); ++j) {
            if (unparsed.charAt(j) == '(') {
                int closing = unparsed.indexOf(41, j);
                if (closing < 0) {
                    throw new ParseException("Unclosed parenthesis: " + line, reader.getLineNumber());
                }
                mapEntry.add(unparsed.substring(j + 1, closing));
                j = closing;
                continue;
            }
            mapEntry.add(String.valueOf(unparsed.charAt(j)));
        }
        return mapEntry;
    }

    boolean hasLanguage(String ... langCodes) {
        if (this.language == null) {
            return false;
        }
        String langCode = Dictionary.extractLanguageCode(this.language);
        for (String code : langCodes) {
            if (!langCode.equals(code)) continue;
            return true;
        }
        return false;
    }

    public DictEntries lookupEntries(String root) {
        final IntsRef forms = this.lookupWord(root.toCharArray(), 0, root.length());
        if (forms == null) {
            return null;
        }
        return new DictEntries(){

            @Override
            public int size() {
                return forms.length / (Dictionary.this.hasCustomMorphData ? 2 : 1);
            }

            @Override
            public String getMorphologicalData(int entryIndex) {
                if (!Dictionary.this.hasCustomMorphData) {
                    return "";
                }
                return Dictionary.this.morphData.get(forms.ints[forms.offset + entryIndex * 2 + 1]);
            }

            @Override
            public List<String> getMorphologicalValues(int entryIndex, String key) {
                assert (key.length() == 3 && key.charAt(2) == ':') : "A morphological data key should consist of two letters followed by a semicolon, found: " + key;
                String fields = this.getMorphologicalData(entryIndex);
                if (fields.isEmpty() || !fields.contains(key)) {
                    return Collections.emptyList();
                }
                return Arrays.stream(fields.split(" ")).filter(s2 -> s2.startsWith(key)).map(s2 -> s2.substring(3)).collect(Collectors.toList());
            }
        };
    }

    static String extractLanguageCode(String isoCode) {
        int underscore = isoCode.indexOf("_");
        return underscore < 0 ? isoCode : isoCode.substring(0, underscore);
    }

    private int parseNum(LineNumberReader reader, String line) throws ParseException {
        return Integer.parseInt(this.splitBySpace(reader, line, 2, Integer.MAX_VALUE)[1]);
    }

    private String singleArgument(LineNumberReader reader, String line) throws ParseException {
        return this.splitBySpace(reader, line, 2)[1];
    }

    private String firstArgument(LineNumberReader reader, String line) throws ParseException {
        return this.splitBySpace(reader, line, 2, Integer.MAX_VALUE)[1];
    }

    private String[] splitBySpace(LineNumberReader reader, String line, int expectedParts) throws ParseException {
        return this.splitBySpace(reader, line, expectedParts, expectedParts);
    }

    private String[] splitBySpace(LineNumberReader reader, String line, int minParts, int maxParts) throws ParseException {
        String[] parts = line.split("\\s+");
        if (parts.length < minParts || parts.length > maxParts && !parts[maxParts].startsWith("#")) {
            throw new ParseException("Invalid syntax: " + line, reader.getLineNumber());
        }
        return parts;
    }

    private List<CompoundRule> parseCompoundRules(LineNumberReader reader, int num) throws IOException, ParseException {
        ArrayList<CompoundRule> compoundRules = new ArrayList<CompoundRule>();
        for (int i = 0; i < num; ++i) {
            compoundRules.add(new CompoundRule(this.singleArgument(reader, reader.readLine()), this));
        }
        return compoundRules;
    }

    private Breaks parseBreaks(LineNumberReader reader, String line) throws IOException, ParseException {
        LinkedHashSet<String> starting = new LinkedHashSet<String>();
        LinkedHashSet<String> ending = new LinkedHashSet<String>();
        LinkedHashSet<String> middle = new LinkedHashSet<String>();
        int num = this.parseNum(reader, line);
        for (int i = 0; i < num; ++i) {
            String breakStr = this.singleArgument(reader, reader.readLine());
            if (breakStr.startsWith("^")) {
                starting.add(breakStr.substring(1));
                continue;
            }
            if (breakStr.endsWith("$")) {
                ending.add(breakStr.substring(0, breakStr.length() - 1));
                continue;
            }
            middle.add(breakStr);
        }
        return new Breaks(starting, ending, middle);
    }

    private FST<IntsRef> affixFST(TreeMap<String, List<Integer>> affixes) throws IOException {
        IntSequenceOutputs outputs = IntSequenceOutputs.getSingleton();
        Builder<IntsRef> builder = new Builder<IntsRef>(FST.INPUT_TYPE.BYTE4, outputs);
        IntsRefBuilder scratch = new IntsRefBuilder();
        for (Map.Entry<String, List<Integer>> entry : affixes.entrySet()) {
            Util.toUTF32(entry.getKey(), scratch);
            List<Integer> entries = entry.getValue();
            IntsRef output = new IntsRef(entries.size());
            for (Integer c : entries) {
                output.ints[output.length++] = c;
            }
            builder.add(scratch.get(), output);
        }
        return builder.finish();
    }

    private void parseAffix(TreeMap<String, List<Integer>> affixes, Set<Character> secondStageFlags, String header, LineNumberReader reader, AffixKind kind, Map<String, Integer> seenPatterns, Map<String, Integer> seenStrips, FlagEnumerator flags) throws IOException, ParseException {
        int numLines;
        StringBuilder sb = new StringBuilder();
        String[] args = header.split("\\s+");
        boolean crossProduct = args[2].equals("Y");
        try {
            numLines = Integer.parseInt(args[3]);
        }
        catch (NumberFormatException e) {
            return;
        }
        this.affixData = ArrayUtil.grow(this.affixData, this.currentAffix * 4 + numLines * 4);
        for (int i = 0; i < numLines; ++i) {
            int appendFlagsOrd;
            Integer stripOrd;
            String condition;
            String key;
            Integer patternIndex;
            String line = reader.readLine();
            String[] ruleArgs = this.splitBySpace(reader, line, 4, Integer.MAX_VALUE);
            char flag = this.flagParsingStrategy.parseFlag(ruleArgs[1]);
            String strip = ruleArgs[2].equals("0") ? "" : ruleArgs[2];
            String affixArg = ruleArgs[3];
            char[] appendFlags = null;
            int flagSep = affixArg.lastIndexOf(47);
            if (flagSep != -1) {
                String flagPart = affixArg.substring(flagSep + 1);
                affixArg = affixArg.substring(0, flagSep);
                if (this.aliasCount > 0) {
                    flagPart = this.getAliasValue(Integer.parseInt(flagPart));
                }
                for (char appendFlag : appendFlags = this.flagParsingStrategy.parseFlags(flagPart)) {
                    secondStageFlags.add(Character.valueOf(appendFlag));
                }
            }
            if ("0".equals(affixArg)) {
                affixArg = "";
            }
            if ((patternIndex = seenPatterns.get(key = AffixCondition.uniqueKey(kind, strip, condition = ruleArgs.length > 4 ? ruleArgs[4] : "."))) == null) {
                patternIndex = this.patterns.size();
                if (patternIndex > Short.MAX_VALUE) {
                    throw new UnsupportedOperationException("Too many patterns, please report this to dev@lucene.apache.org");
                }
                seenPatterns.put(key, patternIndex);
                this.patterns.add(AffixCondition.compile(kind, strip, condition, line));
            }
            if ((stripOrd = seenStrips.get(strip)) == null) {
                stripOrd = seenStrips.size();
                seenStrips.put(strip, stripOrd);
                if (stripOrd > 65535) {
                    throw new UnsupportedOperationException("Too many unique strips, please report this to dev@lucene.apache.org");
                }
            }
            if (appendFlags == null) {
                appendFlags = NOFLAGS;
            }
            if ((appendFlagsOrd = flags.add(appendFlags)) < 0) {
                appendFlagsOrd = -appendFlagsOrd - 1;
            } else if (appendFlagsOrd > Short.MAX_VALUE) {
                throw new UnsupportedOperationException("Too many unique append flags, please report this to dev@lucene.apache.org");
            }
            int dataStart = this.currentAffix * 4;
            this.affixData[dataStart + 0] = flag;
            this.affixData[dataStart + 1] = (char)stripOrd.intValue();
            int patternOrd = patternIndex << 1 | (crossProduct ? 1 : 0);
            this.affixData[dataStart + 2] = (char)patternOrd;
            this.affixData[dataStart + 3] = (char)appendFlagsOrd;
            if (this.needsInputCleaning(affixArg)) {
                affixArg = this.cleanInput(affixArg, sb).toString();
            }
            if (kind == AffixKind.SUFFIX) {
                affixArg = new StringBuilder(affixArg).reverse().toString();
            }
            affixes.computeIfAbsent(affixArg, __ -> new ArrayList()).add(this.currentAffix);
            ++this.currentAffix;
        }
    }

    char affixData(int affixIndex, int offset) {
        return this.affixData[affixIndex * 4 + offset];
    }

    boolean isCrossProduct(int affix) {
        return (this.affixData(affix, 2) & '\u0001') == 1;
    }

    int getAffixCondition(int affix) {
        return this.affixData(affix, 2) >>> 1;
    }

    private ConvTable parseConversions(LineNumberReader reader, int num) throws IOException, ParseException {
        TreeMap<String, String> mappings = new TreeMap<String, String>();
        for (int i = 0; i < num; ++i) {
            String[] parts = this.splitBySpace(reader, reader.readLine(), 3);
            if (mappings.put(parts[1], parts[2]) == null) continue;
            throw new IllegalStateException("duplicate mapping specified for: " + parts[1]);
        }
        return new ConvTable(mappings);
    }

    private void readConfig(InputStream stream, Charset streamCharset) throws IOException, ParseException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream, streamCharset));
        String flagLine = null;
        boolean charsetFound = false;
        boolean flagFound = false;
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            String firstWord = line.split("\\s")[0];
            if ("SET".equals(firstWord)) {
                this.decoder = this.getDecoder(this.singleArgument(reader, line));
                charsetFound = true;
            } else {
                if (!"FLAG".equals(firstWord)) continue;
                flagLine = line;
                flagFound = true;
            }
            if (!charsetFound || !flagFound) continue;
            break;
        }
        if (flagFound) {
            this.flagParsingStrategy = Dictionary.getFlagParsingStrategy(flagLine, this.decoder.charset());
        }
    }

    private static boolean maybeConsume(BufferedInputStream stream, byte[] bytes) throws IOException {
        stream.mark(bytes.length);
        for (byte b : bytes) {
            int nextByte = stream.read();
            if (nextByte == (b & 0xFF)) continue;
            stream.reset();
            return false;
        }
        return true;
    }

    private CharsetDecoder getDecoder(String encoding) {
        if ("ISO8859-14".equals(encoding)) {
            return new ISO8859_14Decoder();
        }
        String canon = CHARSET_ALIASES.get(encoding);
        if (canon != null) {
            encoding = canon;
        }
        return Dictionary.replacingDecoder(Charset.forName(encoding));
    }

    private static CharsetDecoder replacingDecoder(Charset charset) {
        return charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE);
    }

    static FlagParsingStrategy getFlagParsingStrategy(String flagLine, Charset charset) {
        String[] parts = flagLine.split("\\s+");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Illegal FLAG specification: " + flagLine);
        }
        String flagType = parts[1];
        if ("num".equals(flagType)) {
            return new NumFlagParsingStrategy();
        }
        if ("UTF-8".equals(flagType)) {
            if (DEFAULT_CHARSET.equals(charset)) {
                return new DefaultAsUtf8FlagParsingStrategy();
            }
            return new SimpleFlagParsingStrategy();
        }
        if ("long".equals(flagType)) {
            return new DoubleASCIIFlagParsingStrategy();
        }
        throw new IllegalArgumentException("Unknown flag type: " + flagType);
    }

    private String unescapeEntry(String entry) {
        int i;
        StringBuilder sb = new StringBuilder();
        int end = Dictionary.morphBoundary(entry);
        for (i = 0; i < end; ++i) {
            char ch = entry.charAt(i);
            if (ch == '\\' && i + 1 < entry.length()) {
                sb.append(entry.charAt(i + 1));
                ++i;
                continue;
            }
            if (ch == '/' && i > 0) {
                sb.append('\u001f');
                continue;
            }
            if (Dictionary.shouldSkipEscapedChar(ch)) continue;
            sb.append(ch);
        }
        sb.append('\u001e');
        if (end < entry.length()) {
            for (i = end; i < entry.length(); ++i) {
                char c = entry.charAt(i);
                if (Dictionary.shouldSkipEscapedChar(c)) continue;
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private static boolean shouldSkipEscapedChar(char ch) {
        return ch == '\u001f' || ch == '\u001e';
    }

    private static int morphBoundary(String line) {
        int end = Dictionary.indexOfSpaceOrTab(line, 0);
        if (end == -1) {
            return line.length();
        }
        while (!(end < 0 || end >= line.length() || line.charAt(end) == '\t' || end > 0 && end + 3 < line.length() && Character.isLetter(line.charAt(end + 1)) && Character.isLetter(line.charAt(end + 2)) && line.charAt(end + 3) == ':')) {
            end = Dictionary.indexOfSpaceOrTab(line, end + 1);
        }
        if (end == -1) {
            return line.length();
        }
        return end;
    }

    static int indexOfSpaceOrTab(String text, int start) {
        int pos1 = text.indexOf(9, start);
        int pos2 = text.indexOf(32, start);
        if (pos1 >= 0 && pos2 >= 0) {
            return Math.min(pos1, pos2);
        }
        return Math.max(pos1, pos2);
    }

    private int mergeDictionaries(List<InputStream> dictionaries, CharsetDecoder decoder, IndexOutput output) throws IOException {
        StringBuilder sb = new StringBuilder();
        int wordCount = 0;
        try (OfflineSorter.ByteSequencesWriter writer = new OfflineSorter.ByteSequencesWriter(output);){
            for (InputStream dictionary : dictionaries) {
                String line;
                BufferedReader lines = new BufferedReader(new InputStreamReader(dictionary, decoder));
                lines.readLine();
                while ((line = lines.readLine()) != null) {
                    int morphStart;
                    if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '\t') continue;
                    line = this.unescapeEntry(line);
                    if (!this.hasCustomMorphData && (morphStart = line.indexOf(30)) >= 0 && morphStart < line.length()) {
                        String data = line.substring(morphStart + 1);
                        this.hasCustomMorphData = this.splitMorphData(data).stream().anyMatch(s2 -> !s2.startsWith("ph:"));
                    }
                    wordCount += this.writeNormalizedWordEntry(sb, writer, line);
                }
            }
            CodecUtil.writeFooter(output);
        }
        return wordCount;
    }

    private int writeNormalizedWordEntry(StringBuilder reuse, OfflineSorter.ByteSequencesWriter writer, String line) throws IOException {
        CharSequence toWrite;
        int sep;
        int flagSep = line.indexOf(31);
        int morphSep = line.indexOf(30);
        assert (morphSep > 0);
        assert (morphSep > flagSep);
        int n = sep = flagSep < 0 ? morphSep : flagSep;
        if (sep == 0) {
            return 0;
        }
        String beforeSep = line.substring(0, sep);
        if (this.needsInputCleaning(beforeSep)) {
            this.cleanInput(beforeSep, reuse);
            reuse.append(line, sep, line.length());
            toWrite = reuse;
        } else {
            toWrite = line;
        }
        String written = toWrite.toString();
        sep = written.length() - (line.length() - sep);
        writer.write(written.getBytes(StandardCharsets.UTF_8));
        WordCase wordCase = WordCase.caseOf(written, sep);
        if (wordCase == WordCase.MIXED || wordCase == WordCase.UPPER && flagSep > 0) {
            this.addHiddenCapitalizedWord(reuse, writer, written.substring(0, sep), written.substring(sep));
            return 2;
        }
        return 1;
    }

    private void addHiddenCapitalizedWord(StringBuilder reuse, OfflineSorter.ByteSequencesWriter writer, String word, String afterSep) throws IOException {
        reuse.setLength(0);
        reuse.append(Character.toUpperCase(word.charAt(0)));
        for (int i = 1; i < word.length(); ++i) {
            reuse.append(this.caseFold(word.charAt(i)));
        }
        reuse.append('\u001f');
        reuse.append('\uffe7');
        reuse.append(afterSep, afterSep.charAt(0) == '\u001f' ? 1 : 0, afterSep.length());
        writer.write(reuse.toString().getBytes(StandardCharsets.UTF_8));
    }

    String toLowerCase(String word) {
        char[] chars = new char[word.length()];
        for (int i = 0; i < word.length(); ++i) {
            chars[i] = this.caseFold(word.charAt(i));
        }
        return new String(chars);
    }

    String toTitleCase(String word) {
        char[] chars = new char[word.length()];
        chars[0] = Character.toUpperCase(word.charAt(0));
        for (int i = 1; i < word.length(); ++i) {
            chars[i] = this.caseFold(word.charAt(i));
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sortWordsOffline(Directory tempDir, String tempFileNamePrefix, IndexOutput unsorted) throws IOException {
        String sorted;
        block5: {
            block4: {
                OfflineSorter sorter = new OfflineSorter(tempDir, tempFileNamePrefix, new Comparator<BytesRef>(){
                    final BytesRef scratch1 = new BytesRef();
                    final BytesRef scratch2 = new BytesRef();

                    private void initScratch(BytesRef o, BytesRef scratch) {
                        scratch.bytes = o.bytes;
                        scratch.offset = o.offset;
                        scratch.length = o.length;
                        for (int i = scratch.length - 1; i >= 0; --i) {
                            if (scratch.bytes[scratch.offset + i] != 31 && scratch.bytes[scratch.offset + i] != 30) continue;
                            scratch.length = i;
                            break;
                        }
                    }

                    @Override
                    public int compare(BytesRef o1, BytesRef o2) {
                        this.initScratch(o1, this.scratch1);
                        this.initScratch(o2, this.scratch2);
                        int cmp = this.scratch1.compareTo(this.scratch2);
                        if (cmp == 0) {
                            return o1.compareTo(o2);
                        }
                        return cmp;
                    }
                });
                boolean success = false;
                try {
                    sorted = sorter.sort(unsorted.getName());
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        tempDir.deleteFile(unsorted.getName());
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions(tempDir, unsorted.getName());
                    }
                    throw throwable;
                }
                tempDir.deleteFile(unsorted.getName());
                break block5;
            }
            IOUtils.deleteFilesIgnoringExceptions(tempDir, unsorted.getName());
        }
        return sorted;
    }

    /*
     * Loose catch block
     */
    private WordStorage readSortedDictionaries(Directory tempDir, String sorted, FlagEnumerator flags, int wordCount) throws IOException {
        WordStorage wordStorage;
        Throwable throwable;
        OfflineSorter.ByteSequencesReader reader;
        boolean success;
        block24: {
            block23: {
                BytesRef scratch;
                success = false;
                HashMap<String, Integer> morphIndices = new HashMap<String, Integer>();
                WordStorage.Builder builder = new WordStorage.Builder(wordCount, this.hasCustomMorphData, flags);
                reader = new OfflineSorter.ByteSequencesReader(tempDir.openChecksumInput(sorted, IOContext.READONCE), sorted);
                throwable = null;
                while ((scratch = reader.next()) != null) {
                    List<String> morphFields;
                    String entry;
                    int end;
                    char[] wordForm;
                    String line = scratch.utf8ToString();
                    int flagSep = line.indexOf(31);
                    if (flagSep == -1) {
                        wordForm = NOFLAGS;
                        end = line.indexOf(30);
                        entry = line.substring(0, end);
                    } else {
                        end = line.indexOf(30);
                        boolean hidden = line.charAt(flagSep + 1) == '\uffe7';
                        String flagPart = line.substring(flagSep + (hidden ? 2 : 1), end);
                        if (this.aliasCount > 0 && !flagPart.isEmpty()) {
                            flagPart = this.getAliasValue(Integer.parseInt(flagPart));
                        }
                        wordForm = this.flagParsingStrategy.parseFlags(flagPart);
                        if (hidden) {
                            wordForm = ArrayUtil.growExact(wordForm, wordForm.length + 1);
                            wordForm[wordForm.length - 1] = 65511;
                        }
                        entry = line.substring(0, flagSep);
                    }
                    if (entry.isEmpty()) continue;
                    int morphDataID = 0;
                    if (end + 1 < line.length() && !(morphFields = this.readMorphFields(entry, line.substring(end + 1))).isEmpty()) {
                        morphFields.sort(Comparator.naturalOrder());
                        morphDataID = this.addMorphFields(morphIndices, String.join((CharSequence)" ", morphFields));
                    }
                    builder.add(entry, wordForm, morphDataID);
                }
                success = true;
                wordStorage = builder.build();
                if (!success) break block23;
                tempDir.deleteFile(sorted);
                break block24;
            }
            IOUtils.deleteFilesIgnoringExceptions(tempDir, sorted);
        }
        return wordStorage;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            {
                catch (Throwable throwable4) {
                    if (success) {
                        tempDir.deleteFile(sorted);
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions(tempDir, sorted);
                    }
                    throw throwable4;
                }
            }
        }
    }

    private List<String> readMorphFields(String word, String unparsed) {
        ArrayList<String> morphFields = null;
        for (String datum : this.splitMorphData(unparsed)) {
            if (datum.startsWith("ph:")) {
                this.addPhoneticRepEntries(word, datum.substring(3));
                continue;
            }
            if (morphFields == null) {
                morphFields = new ArrayList<String>(1);
            }
            morphFields.add(datum);
        }
        return morphFields == null ? Collections.emptyList() : morphFields;
    }

    private int addMorphFields(Map<String, Integer> indices, String morphFields) {
        Integer alreadyCached = indices.get(morphFields);
        if (alreadyCached != null) {
            return alreadyCached;
        }
        int index = this.morphData.size();
        indices.put(morphFields, index);
        this.morphData.add(morphFields);
        return index;
    }

    private void addPhoneticRepEntries(String word, String ph) {
        String replacement;
        String pattern;
        int arrow = ph.indexOf("->");
        if (arrow > 0) {
            pattern = ph.substring(0, arrow);
            replacement = ph.substring(arrow + 2);
        } else {
            pattern = ph;
            replacement = word;
        }
        if (pattern.endsWith("*") && pattern.length() > 2 && replacement.length() > 1) {
            pattern = pattern.substring(0, pattern.length() - 2);
            replacement = replacement.substring(0, replacement.length() - 1);
        }
        if (WordCase.caseOf(word) == WordCase.TITLE && WordCase.caseOf(pattern) == WordCase.LOWER) {
            if (this.hasLanguage("de", "hu")) {
                this.repTable.add(new RepEntry(pattern, this.toLowerCase(replacement)));
            }
            this.repTable.add(new RepEntry(this.toTitleCase(pattern), replacement));
        }
        this.repTable.add(new RepEntry(pattern, replacement));
    }

    boolean isDotICaseChangeDisallowed(char[] word) {
        return word[0] == '\u0130' && !this.alternateCasing;
    }

    private void parseAlias(String line) {
        String[] ruleArgs = line.split("\\s+");
        if (this.aliases == null) {
            int count = Integer.parseInt(ruleArgs[1]);
            this.aliases = new String[count];
        } else {
            String aliasValue = ruleArgs.length == 1 ? "" : ruleArgs[1];
            this.aliases[this.aliasCount++] = aliasValue;
        }
    }

    private String getAliasValue(int id) {
        try {
            return this.aliases[id - 1];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Bad flag alias number:" + id, ex);
        }
    }

    private void parseMorphAlias(String line) {
        if (this.morphAliases == null) {
            int count = Integer.parseInt(line.substring(3));
            this.morphAliases = new String[count];
        } else {
            String arg = line.substring(2);
            this.morphAliases[this.morphAliasCount++] = arg;
        }
    }

    private List<String> splitMorphData(String morphData) {
        if (this.morphAliasCount > 0) {
            try {
                int alias = Integer.parseInt(morphData.trim());
                morphData = this.morphAliases[alias - 1];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (morphData.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(morphData.split("\\s+")).filter(s2 -> s2.length() > 3 && Character.isLetter(s2.charAt(0)) && Character.isLetter(s2.charAt(1)) && s2.charAt(2) == ':').collect(Collectors.toList());
    }

    boolean hasFlag(IntsRef forms, char flag) {
        int formStep = this.formStep();
        for (int i = 0; i < forms.length; i += formStep) {
            if (!this.hasFlag(forms.ints[forms.offset + i], flag)) continue;
            return true;
        }
        return false;
    }

    boolean hasFlag(int entryId, char flag) {
        return this.flagLookup.hasFlag(entryId, flag);
    }

    boolean mayNeedInputCleaning() {
        return this.ignoreCase || this.ignore != null || this.iconv != null;
    }

    boolean needsInputCleaning(CharSequence input) {
        if (this.mayNeedInputCleaning()) {
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (!(this.ignore != null && Arrays.binarySearch(this.ignore, ch) >= 0 || this.ignoreCase && this.caseFold(ch) != ch) && (this.iconv == null || !this.iconv.mightReplaceChar(ch))) continue;
                return true;
            }
        }
        return false;
    }

    CharSequence cleanInput(CharSequence input, StringBuilder reuse) {
        int i;
        reuse.setLength(0);
        for (i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (this.ignore != null && Arrays.binarySearch(this.ignore, ch) >= 0) continue;
            if (this.ignoreCase && this.iconv == null) {
                ch = this.caseFold(ch);
            }
            reuse.append(ch);
        }
        if (this.iconv != null) {
            this.iconv.applyMappings(reuse);
            if (this.ignoreCase) {
                for (i = 0; i < reuse.length(); ++i) {
                    reuse.setCharAt(i, this.caseFold(reuse.charAt(i)));
                }
            }
        }
        return reuse;
    }

    static char[] toSortedCharArray(Set<Character> set) {
        char[] chars = new char[set.size()];
        int i = 0;
        for (Character c : set) {
            chars[i++] = c.charValue();
        }
        Arrays.sort(chars);
        return chars;
    }

    boolean isSecondStagePrefix(char flag) {
        return Arrays.binarySearch(this.secondStagePrefixFlags, flag) >= 0;
    }

    boolean isSecondStageSuffix(char flag) {
        return Arrays.binarySearch(this.secondStageSuffixFlags, flag) >= 0;
    }

    char caseFold(char c) {
        if (this.alternateCasing) {
            if (c == 'I') {
                return '\u0131';
            }
            if (c == '\u0130') {
                return 'i';
            }
            return Character.toLowerCase(c);
        }
        return Character.toLowerCase(c);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    static Path getDefaultTempDir() throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            throw new IOException("No temporary path (java.io.tmpdir)?");
        }
        Path tmpPath = Paths.get(tmpDir, new String[0]);
        if (!Files.isWritable(tmpPath)) {
            throw new IOException("Temporary path not present or writeable?: " + tmpPath.toAbsolutePath());
        }
        return tmpPath;
    }

    static {
        CHARSET_ALIASES.put("microsoft-cp1251", "windows-1251");
        CHARSET_ALIASES.put("TIS620-2533", "TIS-620");
    }

    static class Breaks {
        private static final Set<String> MINUS = Collections.singleton("-");
        static final Breaks DEFAULT = new Breaks(MINUS, MINUS, MINUS);
        final String[] starting;
        final String[] ending;
        final String[] middle;

        Breaks(Collection<String> starting, Collection<String> ending, Collection<String> middle) {
            this.starting = starting.toArray(new String[0]);
            this.ending = ending.toArray(new String[0]);
            this.middle = middle.toArray(new String[0]);
        }

        boolean isNotEmpty() {
            return this.middle.length > 0 || this.starting.length > 0 || this.ending.length > 0;
        }
    }

    private static class DoubleASCIIFlagParsingStrategy
    extends FlagParsingStrategy {
        private DoubleASCIIFlagParsingStrategy() {
        }

        @Override
        public char[] parseFlags(String rawFlags) {
            char[] flags = new char[rawFlags.length() / 2];
            for (int i = 0; i < flags.length; ++i) {
                char f1 = rawFlags.charAt(i * 2);
                char f2 = rawFlags.charAt(i * 2 + 1);
                if (f1 >= '\u0100' || f2 >= '\u0100') {
                    throw new IllegalArgumentException("Invalid flags (LONG flags must be double ASCII): " + rawFlags);
                }
                flags[i] = (char)(f1 << 8 | f2);
            }
            return flags;
        }
    }

    private static class NumFlagParsingStrategy
    extends FlagParsingStrategy {
        private NumFlagParsingStrategy() {
        }

        @Override
        public char[] parseFlags(String rawFlags) {
            StringBuilder result = new StringBuilder();
            StringBuilder group = new StringBuilder();
            for (int i = 0; i <= rawFlags.length(); ++i) {
                if (i == rawFlags.length() || rawFlags.charAt(i) == ',') {
                    if (group.length() <= 0) continue;
                    int flag = Integer.parseInt(group.toString());
                    if (flag >= 65510) {
                        throw new IllegalArgumentException("Num flags should be between 0 and 65510, found " + flag);
                    }
                    result.append((char)flag);
                    group.setLength(0);
                    continue;
                }
                if (rawFlags.charAt(i) < '0' || rawFlags.charAt(i) > '9') continue;
                group.append(rawFlags.charAt(i));
            }
            return result.toString().toCharArray();
        }
    }

    private static class DefaultAsUtf8FlagParsingStrategy
    extends FlagParsingStrategy {
        private DefaultAsUtf8FlagParsingStrategy() {
        }

        @Override
        public char[] parseFlags(String rawFlags) {
            return new String(rawFlags.getBytes(DEFAULT_CHARSET), StandardCharsets.UTF_8).toCharArray();
        }
    }

    private static class SimpleFlagParsingStrategy
    extends FlagParsingStrategy {
        private SimpleFlagParsingStrategy() {
        }

        @Override
        public char[] parseFlags(String rawFlags) {
            return rawFlags.toCharArray();
        }
    }

    static abstract class FlagParsingStrategy {
        static final boolean checkFlags = false;

        FlagParsingStrategy() {
        }

        char parseFlag(String rawFlag) {
            char[] flags = this.parseFlags(rawFlag);
            return flags[0];
        }

        abstract char[] parseFlags(String var1);
    }
}

