/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.maven.index.ArtifactInfo;

public final class NexusLegacyAnalyzer
extends AnalyzerWrapper {
    private static final Analyzer DEFAULT_ANALYZER = new StandardAnalyzer();
    private static final Analyzer LETTER_OR_DIGIT_ANALYZER = new Analyzer(){

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return new Analyzer.TokenStreamComponents(new CharTokenizer(){

                @Override
                protected boolean isTokenChar(int c) {
                    return Character.isLetterOrDigit(c);
                }

                @Override
                protected int normalize(int c) {
                    return Character.toLowerCase(c);
                }
            });
        }
    };

    public NexusLegacyAnalyzer() {
        super(PER_FIELD_REUSE_STRATEGY);
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        if (!this.isTextField(fieldName)) {
            return LETTER_OR_DIGIT_ANALYZER;
        }
        return DEFAULT_ANALYZER;
    }

    protected boolean isTextField(String field) {
        return ArtifactInfo.NAME.equals(field) || ArtifactInfo.DESCRIPTION.equals(field) || ArtifactInfo.NAMES.equals(field);
    }
}

