/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.HashMaps;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsResourceAccountant {
    private static final ConcurrentMap<Closeable, Account> accounts;
    private final Lock lock;
    private final Condition condition;

    FsResourceAccountant(Lock lock) {
        this.lock = lock;
        this.condition = this.lock.newCondition();
    }

    void startAccountingFor(@WillCloseWhenClosed Closeable resource) {
        accounts.put(resource, new Account());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAccountingFor(@WillNotClose Closeable resource) {
        if (null != accounts.remove(resource)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitOtherThreads(long timeout) {
        this.lock.lock();
        try {
            try {
                long toWait = TimeUnit.MILLISECONDS.toNanos(timeout);
                while (this.resources().isBusy()) {
                    if (0L < timeout) {
                        if (0L >= toWait) {
                            break;
                        }
                        toWait = this.condition.awaitNanos(toWait);
                        continue;
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException cancel) {
                if (0 == this.resources().total) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    Resources resources() {
        Thread currentThread = Thread.currentThread();
        int local = 0;
        int total = 0;
        for (Account account : accounts.values()) {
            if (account.getAccountant() != this) continue;
            if (account.owner == currentThread) {
                ++local;
            }
            ++total;
        }
        return new Resources(local, total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <X extends Exception> void closeAllResources(ExceptionHandler<? super IOException, X> handler) throws X {
        assert (null != handler);
        this.lock.lock();
        try {
            Iterator i = accounts.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Account account = (Account)entry.getValue();
                if (account.getAccountant() != this) continue;
                i.remove();
                Closeable closeable = (Closeable)entry.getKey();
                try {
                    closeable.close();
                }
                catch (IOException ex) {
                    handler.warn(ex);
                }
            }
        }
        finally {
            this.condition.signalAll();
            this.lock.unlock();
        }
    }

    static {
        int initialCapacity = HashMaps.initialCapacity(Runtime.getRuntime().availableProcessors() * 10);
        accounts = new ConcurrentHashMap<Closeable, Account>(initialCapacity, 0.75f, initialCapacity);
    }

    @Immutable
    static final class Resources {
        final int local;
        final int total;

        private Resources(int local, int total) {
            this.local = local;
            this.total = total;
        }

        boolean isBusy() {
            return this.local < this.total;
        }
    }

    private final class Account {
        final Thread owner = Thread.currentThread();

        private Account() {
        }

        FsResourceAccountant getAccountant() {
            return FsResourceAccountant.this;
        }
    }
}

