/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoGroup;
import org.apache.maven.index.Field;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.QueryCreator;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.context.ContextMemberProvider;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.MergedIndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.util.IndexCreatorSorter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Indexer.class)
public class DefaultIndexer
extends AbstractLogEnabled
implements Indexer {
    @Requirement
    private SearchEngine searcher;
    @Requirement
    private IndexerEngine indexerEngine;
    @Requirement
    private QueryCreator queryCreator;
    private static final char[] DIGITS = "0123456789abcdef".toCharArray();

    @Override
    public IndexingContext createIndexingContext(String id, String repositoryId, File repository, File indexDirectory, String repositoryUrl, String indexUpdateUrl, boolean searchable, boolean reclaim, List<? extends IndexCreator> indexers) throws IOException, ExistingLuceneIndexMismatchException, IllegalArgumentException {
        DefaultIndexingContext context = new DefaultIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, IndexCreatorSorter.sort(indexers), reclaim);
        context.setSearchable(searchable);
        return context;
    }

    @Override
    public IndexingContext createMergedIndexingContext(String id, String repositoryId, File repository, File indexDirectory, boolean searchable, ContextMemberProvider membersProvider) throws IOException {
        MergedIndexingContext context = new MergedIndexingContext(id, repositoryId, repository, indexDirectory, searchable, membersProvider);
        return context;
    }

    @Override
    public void closeIndexingContext(IndexingContext context, boolean deleteFiles) throws IOException {
        context.close(deleteFiles);
    }

    @Override
    public void addArtifactsToIndex(Collection<ArtifactContext> ac, IndexingContext context) throws IOException {
        if (ac != null && !ac.isEmpty()) {
            for (ArtifactContext actx : ac) {
                this.indexerEngine.update(context, actx);
            }
            context.commit();
        }
    }

    @Override
    public void deleteArtifactsFromIndex(Collection<ArtifactContext> ac, IndexingContext context) throws IOException {
        if (ac != null && !ac.isEmpty()) {
            for (ArtifactContext actx : ac) {
                this.indexerEngine.remove(context, actx);
                context.commit();
            }
        }
    }

    @Override
    public FlatSearchResponse searchFlat(FlatSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return new FlatSearchResponse(request.getQuery(), 0, Collections.<ArtifactInfo>emptySet());
        }
        return this.searcher.forceSearchFlatPaged(request, request.getContexts());
    }

    @Override
    public IteratorSearchResponse searchIterator(IteratorSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return IteratorSearchResponse.empty(request.getQuery());
        }
        return this.searcher.forceSearchIteratorPaged(request, request.getContexts());
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request) throws IOException {
        if (request.getContexts().isEmpty()) {
            return new GroupedSearchResponse(request.getQuery(), 0, Collections.<String, ArtifactInfoGroup>emptyMap());
        }
        return this.searcher.forceSearchGrouped(request, request.getContexts());
    }

    @Override
    public Collection<ArtifactInfo> identify(File artifact, Collection<IndexingContext> contexts) throws IOException {
        Collection<ArtifactInfo> collection;
        FileInputStream is = null;
        try {
            int n;
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            is = new FileInputStream(artifact);
            byte[] buff = new byte[4096];
            while ((n = is.read(buff)) > -1) {
                sha1.update(buff, 0, n);
            }
            byte[] digest = sha1.digest();
            collection = this.identify(this.constructQuery(MAVEN.SHA1, new SourcedSearchExpression(DefaultIndexer.encode(digest))), contexts);
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                IOException ioe = new IOException("Unable to calculate digest");
                ioe.initCause(ex);
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ArtifactInfo> identify(Query query, Collection<IndexingContext> contexts) throws IOException {
        IteratorSearchResponse result = this.searcher.searchIteratorPaged(new IteratorSearchRequest(query), contexts);
        try {
            ArrayList<ArtifactInfo> ais = new ArrayList<ArtifactInfo>(result.getTotalHitsCount());
            for (ArtifactInfo ai : result) {
                ais.add(ai);
            }
            Iterable<ArtifactInfo> iterable = ais;
            return iterable;
        }
        finally {
            result.close();
        }
    }

    @Override
    public Query constructQuery(Field field, SearchExpression expression) throws IllegalArgumentException {
        try {
            return this.queryCreator.constructQuery(field, expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String encode(byte[] digest) {
        char[] buff = new char[digest.length * 2];
        int n = 0;
        for (byte b : digest) {
            buff[n++] = DIGITS[(0xF0 & b) >> 4];
            buff[n++] = DIGITS[0xF & b];
        }
        return new String(buff);
    }
}

