/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexerEngine.class)
public class DefaultIndexerEngine
extends AbstractLogEnabled
implements IndexerEngine {
    @Override
    public void index(IndexingContext context, ArtifactContext ac) throws IOException {
        Document d;
        if (ac != null && ac.getGav() != null && (d = ac.createDocument(context)) != null) {
            context.getIndexWriter().addDocument(d);
            context.updateTimestamp();
        }
    }

    @Override
    public void update(IndexingContext context, ArtifactContext ac) throws IOException {
        Document old;
        Document d;
        if (ac != null && ac.getGav() != null && (d = ac.createDocument(context)) != null && !this.equals(d, old = this.getOldDocument(context, ac))) {
            IndexWriter w = context.getIndexWriter();
            w.updateDocument(new Term(ArtifactInfo.UINFO, ac.getArtifactInfo().getUinfo()), d);
            this.updateGroups(context, ac);
            context.updateTimestamp();
        }
    }

    @Override
    public void remove(IndexingContext context, ArtifactContext ac) throws IOException {
        if (ac != null) {
            String uinfo = ac.getArtifactInfo().getUinfo();
            Document doc = new Document();
            doc.add(new Field(ArtifactInfo.DELETED, uinfo, Field.Store.YES, Field.Index.NO));
            doc.add(new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
            IndexWriter w = context.getIndexWriter();
            w.addDocument(doc);
            w.deleteDocuments(new Term(ArtifactInfo.UINFO, uinfo));
            context.updateTimestamp();
        }
    }

    private boolean equals(Document d1, Document d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        Map<String, String> m1 = this.toMap(d1);
        Map<String, String> m2 = this.toMap(d2);
        m1.remove(MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey());
        m2.remove(MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey());
        return ((Object)m1).equals(m2);
    }

    private Map<String, String> toMap(Document d) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Fieldable o : d.getFields()) {
            Fieldable f = o;
            if (!f.isStored()) continue;
            result.put(f.name(), f.stringValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document getOldDocument(IndexingContext context, ArtifactContext ac) {
        try {
            IndexSearcher indexSearcher = context.acquireIndexSearcher();
            try {
                TopDocs result = indexSearcher.search((Query)new TermQuery(new Term(ArtifactInfo.UINFO, ac.getArtifactInfo().getUinfo())), 2);
                if (result.totalHits != 1) return null;
                Document document = indexSearcher.doc(result.scoreDocs[0].doc);
                return document;
            }
            finally {
                context.releaseIndexSearcher(indexSearcher);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void updateGroups(IndexingContext context, ArtifactContext ac) throws IOException {
        Set<String> allGroups;
        String rootGroup = ac.getArtifactInfo().getRootGroup();
        Set<String> rootGroups = context.getRootGroups();
        if (!rootGroups.contains(rootGroup)) {
            rootGroups.add(rootGroup);
            context.setRootGroups(rootGroups);
        }
        if (!(allGroups = context.getAllGroups()).contains(ac.getArtifactInfo().groupId)) {
            allGroups.add(ac.getArtifactInfo().groupId);
            context.setAllGroups(allGroups);
        }
    }
}

