/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

@CleanupObligation
public abstract class DecoratingOutputStream
extends OutputStream {
    @Nullable
    protected OutputStream delegate;

    @CreatesObligation
    protected DecoratingOutputStream(@Nullable @WillCloseWhenClosed OutputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return String.format("%s[delegate=%s]", this.getClass().getName(), this.delegate);
    }
}

