/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.rof.ByteArrayReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@NotThreadSafe
public class ByteArrayIOEntry
implements IOEntry<ByteArrayIOEntry> {
    private final String name;
    @CheckForNull
    private byte[] data;
    private int reads;
    private int writes;
    int initialCapacity = 32;

    public ByteArrayIOEntry(String name) {
        this(name, 32);
    }

    public ByteArrayIOEntry(String name, int initialCapacity) {
        this.name = name;
        this.setInitialCapacity(initialCapacity);
    }

    public final void setInitialCapacity(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    @CheckForNull
    public byte[] getData() {
        return this.data;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public void setData(@Nullable byte[] data) {
        this.data = data;
    }

    public int getReads() {
        return this.reads;
    }

    public int getWrites() {
        return this.writes;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Entry.Type getType() {
        return Entry.Type.FILE;
    }

    @Override
    public long getSize(Entry.Size type) {
        return null == this.data ? -1L : (long)this.data.length;
    }

    @Override
    public long getTime(Entry.Access type) {
        return System.currentTimeMillis();
    }

    @Override
    public InputSocket<ByteArrayIOEntry> getInputSocket() {
        return new ByteArrayInputSocket();
    }

    @Override
    public OutputSocket<ByteArrayIOEntry> getOutputSocket() {
        return new ByteArrayOutputSocket();
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ byte[] access$202(ByteArrayIOEntry x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    private class DataOutputStream
    extends ByteArrayOutputStream {
        DataOutputStream() {
            super(ByteArrayIOEntry.this.initialCapacity);
        }

        @Override
        public void close() throws IOException {
            super.close();
            ByteArrayIOEntry.access$202(ByteArrayIOEntry.this, this.toByteArray());
        }
    }

    private class ByteArrayOutputSocket
    extends OutputSocket<ByteArrayIOEntry> {
        private ByteArrayOutputSocket() {
        }

        @Override
        public ByteArrayIOEntry getLocalTarget() throws IOException {
            return ByteArrayIOEntry.this;
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            ByteArrayIOEntry.this.writes++;
            return new DataOutputStream();
        }
    }

    private final class ByteArrayInputSocket
    extends InputSocket<ByteArrayIOEntry> {
        private ByteArrayInputSocket() {
        }

        @Override
        public ByteArrayIOEntry getLocalTarget() throws IOException {
            return ByteArrayIOEntry.this;
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            byte[] data = ByteArrayIOEntry.this.data;
            if (null == data) {
                throw new FileNotFoundException();
            }
            ByteArrayIOEntry.this.reads++;
            return new ByteArrayReadOnlyFile(data);
        }

        @Override
        public InputStream newInputStream() throws IOException {
            byte[] data = ByteArrayIOEntry.this.data;
            if (null == data) {
                throw new FileNotFoundException();
            }
            ByteArrayIOEntry.this.reads++;
            return new ByteArrayInputStream(data);
        }
    }
}

