/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
public enum FsUriModifier {
    NULL{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            if (uri.normalize() != uri) {
                throw new URISyntaxException("\"" + uri + "\"", "URI path not in normal form");
            }
            return uri;
        }
    }
    ,
    CANONICALIZE{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            return fix.modify(uri.normalize());
        }
    };


    @NonNull
    abstract URI modify(@NonNull URI var1, @NonNull PostFix var2) throws URISyntaxException;

    @Immutable
    public static enum PostFix {
        PATH{

            @Override
            URI modify(URI uri) throws URISyntaxException {
                String s;
                int i;
                if (uri.isOpaque()) {
                    return uri;
                }
                if (uri.getRawPath().startsWith("//") && 0 <= (i = (s = uri.getPath()).indexOf(47, 2))) {
                    uri = new URI(uri.getScheme(), s.substring(2, i), s.substring(i), uri.getQuery(), uri.getFragment());
                }
                while ((s = uri.getPath()).endsWith("/") && 2 <= s.length() && ':' != s.charAt(s.length() - 2)) {
                    uri = new URI(uri.getScheme(), uri.getAuthority(), s.substring(0, s.length() - 1), uri.getQuery(), uri.getFragment());
                }
                return uri;
            }
        }
        ,
        MOUNT_POINT{

            @Override
            URI modify(URI uri) {
                return uri;
            }
        }
        ,
        ENTRY_NAME{

            @Override
            URI modify(URI uri) {
                return uri;
            }
        };


        @NonNull
        abstract URI modify(@NonNull URI var1) throws URISyntaxException;
    }
}

