/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Locale;
import net.jcip.annotations.Immutable;

@Immutable
public final class FsScheme
implements Serializable,
Comparable<FsScheme> {
    private static final long serialVersionUID = 2765230379628276648L;
    private final String scheme;

    @NonNull
    public static FsScheme create(String scheme) {
        try {
            return new FsScheme(scheme);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsScheme(@NonNull String scheme) throws URISyntaxException {
        int i = scheme.length();
        if (0 >= i) {
            throw new URISyntaxException(FsScheme.quote(scheme), "Empty URI scheme");
        }
        char c = scheme.charAt(0);
        if (!(c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c)) {
            throw new URISyntaxException(FsScheme.quote(scheme), "Illegal character in URI scheme", 0);
        }
        while (--i >= 1) {
            c = scheme.charAt(i);
            if (c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c || c >= '0' && '9' >= c || c == '+' || c == '-' || c == '.') continue;
            throw new URISyntaxException(FsScheme.quote(scheme), "Illegal character in URI scheme", i);
        }
        this.scheme = scheme;
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    public boolean equals(Object that) {
        return this == that || that instanceof FsScheme && this.scheme.equalsIgnoreCase(((FsScheme)that).scheme);
    }

    @Override
    public int compareTo(FsScheme that) {
        return this.scheme.compareToIgnoreCase(that.scheme);
    }

    public int hashCode() {
        return this.scheme.toLowerCase(Locale.ENGLISH).hashCode();
    }

    public String toString() {
        return this.scheme;
    }
}

