/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TDefaultArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.swing.TDecoratingFileView;
import de.schlichtherle.truezip.file.swing.TNullFileView;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;

@DefaultAnnotation(value={NonNull.class})
public class TFileView
extends TDecoratingFileView {
    private static final String CLASS_NAME = TFileView.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);

    public TFileView(@CheckForNull FileView fileView) {
        super(null != fileView ? fileView : new TNullFileView());
    }

    @Override
    @Nullable
    public String getTypeDescription(File file) {
        String typeDescription = TFileView.typeDescription(file);
        return typeDescription != null ? typeDescription : this.delegate.getTypeDescription(file);
    }

    @Nullable
    static String typeDescription(File file) {
        if (!(file instanceof TFile)) {
            return null;
        }
        TFile smartFile = (TFile)file;
        if (TFileView.isTrueArchive(smartFile)) {
            return resources.getString("archiveFile");
        }
        if (TFileView.isEntryInTrueArchive(smartFile)) {
            return smartFile.isDirectory() ? resources.getString("archiveDirectoryEntry") : resources.getString("archiveFileEntry");
        }
        return null;
    }

    @Override
    @Nullable
    public Icon getIcon(File file) {
        Icon icon = TFileView.icon(file);
        return null != icon ? icon : this.delegate.getIcon(file);
    }

    @Nullable
    static Icon icon(File file) {
        if (!(file instanceof TFile)) {
            return null;
        }
        TFile smartFile = (TFile)file;
        if (TFileView.isTrueArchive(smartFile)) {
            return UIManager.getIcon("FileView.directoryIcon");
        }
        if (TFileView.isEntryInTrueArchive(smartFile)) {
            return smartFile.isDirectory() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
        }
        return null;
    }

    private static boolean isTrueArchive(TFile file) {
        return file.isArchive() && file.isDirectory() && !TFileView.newNonArchiveFile(file).isDirectory();
    }

    private static TFile newNonArchiveFile(@NonNull TFile file) {
        TFile parent = file.getParentFile();
        assert (null != parent) : "expected non-null from context!";
        return new TFile((File)parent, file.getName(), (TArchiveDetector)TDefaultArchiveDetector.NULL);
    }

    private static boolean isEntryInTrueArchive(TFile file) {
        if (!file.isEntry()) {
            return false;
        }
        TFile parent = file.getParentFile();
        assert (parent != null) : "An archive entry must always name a parent!";
        return parent.isDirectory() && !new TFile(parent.getPath(), (TArchiveDetector)TDefaultArchiveDetector.NULL).isDirectory();
    }

    @Override
    @Nullable
    public Boolean isTraversable(File file) {
        return file instanceof TFile ? Boolean.valueOf(((TFile)file).isDirectory()) : this.delegate.isTraversable(file);
    }
}

