/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.swing.TFileTreeCellRenderer;
import de.schlichtherle.truezip.file.swing.TFileTreeModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@DefaultAnnotation(value={NonNull.class})
public final class TFileTree
extends JTree {
    private static final Collator COLLATOR = Collator.getInstance();
    public static final Comparator<TFile> FILE_NAME_COMPARATOR;
    private static final String PROPERTY_DISPLAYING_SUFFIXES = "displayingSuffixes";
    private static final String PROPERTY_EDITING_SUFFIXES = "editingSuffixes";
    private static final String PROPERTY_DEFAULT_SUFFIX = "defaultSuffix";
    private static final long serialVersionUID = 1064787562479927601L;
    private final Controller controller = new Controller();
    private boolean displayingSuffixes = true;
    private boolean editingSuffixes = true;
    @CheckForNull
    private String defaultSuffix;
    @CheckForNull
    private TFile editedNode;

    public TFileTree() {
        this(new TFileTreeModel(null, null, FILE_NAME_COMPARATOR));
    }

    public TFileTree(TFile root) {
        this(new TFileTreeModel(root, null, FILE_NAME_COMPARATOR));
    }

    public TFileTree(TFileTreeModel model) {
        super(model);
        super.addTreeExpansionListener(this.controller);
        super.setCellRenderer(new TFileTreeCellRenderer(this));
    }

    @Override
    public TFileTreeModel getModel() {
        return (TFileTreeModel)super.getModel();
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void setModel(TreeModel model) {
        if (null == model) {
            throw new NullPointerException();
        }
        super.setModel((TFileTreeModel)model);
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable) {
            super.setEditable(true);
            this.getCellEditor().addCellEditorListener(this.controller);
        } else {
            TreeCellEditor ce = this.getCellEditor();
            if (ce != null) {
                ce.removeCellEditorListener(this.controller);
            }
            super.setEditable(false);
        }
    }

    public boolean isDisplayingSuffixes() {
        return this.displayingSuffixes;
    }

    public void setDisplayingSuffixes(boolean displayingSuffixes) {
        boolean oldDisplayingSuffixes = this.displayingSuffixes;
        this.displayingSuffixes = displayingSuffixes;
        this.firePropertyChange(PROPERTY_DISPLAYING_SUFFIXES, oldDisplayingSuffixes, displayingSuffixes);
    }

    public boolean isEditingSuffixes() {
        return this.editingSuffixes;
    }

    public void setEditingSuffixes(boolean editingSuffixes) {
        boolean oldEditingSuffixes = this.editingSuffixes;
        this.editingSuffixes = editingSuffixes;
        this.firePropertyChange(PROPERTY_EDITING_SUFFIXES, oldEditingSuffixes, editingSuffixes);
    }

    @Nullable
    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(@CheckForNull String defaultSuffix) {
        String oldDefaultSuffix = this.defaultSuffix;
        if (null != defaultSuffix) {
            if ((defaultSuffix = defaultSuffix.trim()).length() <= 0) {
                defaultSuffix = null;
            } else if (defaultSuffix.charAt(0) != '.') {
                defaultSuffix = "." + defaultSuffix;
            }
        }
        this.defaultSuffix = defaultSuffix;
        this.firePropertyChange(PROPERTY_DEFAULT_SUFFIX, oldDefaultSuffix, defaultSuffix);
    }

    @Nullable
    TFile getEditedNode() {
        return this.editedNode;
    }

    @Override
    public boolean isEditing() {
        return null != this.editedNode;
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        this.editedNode = (TFile)path.getLastPathComponent();
        super.startEditingAtPath(path);
    }

    @Override
    public void cancelEditing() {
        this.editedNode = null;
        super.cancelEditing();
    }

    @Override
    public boolean stopEditing() {
        boolean stop = super.stopEditing();
        if (stop) {
            this.editedNode = null;
        }
        return stop;
    }

    protected void onEditingStopped(ChangeEvent evt) {
        TFile node;
        TreeCellEditor tce = (TreeCellEditor)evt.getSource();
        String base = tce.getCellEditorValue().toString().trim();
        TFile oldNode = (TFile)this.getLeadSelectionPath().getLastPathComponent();
        TFile parent = oldNode.getParentFile();
        assert (parent != null);
        if (!oldNode.isDirectory()) {
            String suffix;
            if (this.isDisplayingSuffixes() && this.isEditingSuffixes()) {
                String defaultSuffix;
                suffix = this.getSuffix(base);
                if (null == suffix && (defaultSuffix = this.getDefaultSuffix()) != null) {
                    base = base + defaultSuffix;
                }
            } else {
                suffix = this.getSuffix(oldNode.getName());
                if (null != suffix) {
                    base = base + suffix;
                }
            }
        }
        if (!this.renameTo(oldNode, node = new TFile((File)parent, base))) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Nullable
    private String getSuffix(String base) {
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(i) : null;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TFile node = (TFile)value;
        TFile editedNode = this.getEditedNode();
        if (node != editedNode && !node.exists()) {
            return "?";
        }
        String base = node.getName();
        if (base.length() <= 0) {
            return node.getPath();
        }
        if (node.isDirectory() || this.isDisplayingSuffixes() && (!node.equals(editedNode) || this.isEditingSuffixes())) {
            return base;
        }
        int i = base.lastIndexOf(46);
        return i != -1 ? base.substring(0, i) : base;
    }

    public void refresh() {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(ftm.getRoot());
        if (null != path) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(TFile node) {
        if (node == null) {
            throw new NullPointerException();
        }
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path != null) {
            this.refresh(new TreePath[]{path});
        }
    }

    public void refresh(TreePath[] paths) {
        if (paths == null || paths.length <= 0) {
            return;
        }
        TFileTreeModel ftm = this.getModel();
        TreePath lead = this.getLeadSelectionPath();
        TreePath anchor = this.getAnchorSelectionPath();
        TreePath[] selections = this.getSelectionPaths();
        for (TreePath path : paths) {
            Enumeration<TreePath> expansions = this.getExpandedDescendants(path);
            ftm.refresh((TFile)path.getLastPathComponent());
            this.setExpandedDescendants(expansions);
        }
        this.setSelectionPaths(selections);
        this.setAnchorSelectionPath(anchor);
        this.setLeadSelectionPath(lead);
        this.scrollPathToVisible(lead);
    }

    private void setExpandedDescendants(Enumeration<TreePath> expansions) {
        if (expansions == null) {
            return;
        }
        while (expansions.hasMoreElements()) {
            this.setExpandedState(expansions.nextElement(), true);
        }
    }

    public boolean createNewFile(TFile node) throws IOException {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.createNewFile(node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean mkdir(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.mkdir(node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean mkdirs(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.mkdirs(node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean copyFrom(TFile node, InputStream in) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.copyFrom(node, in)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean copyTo(TFile oldNode, TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.copyTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean copyAllTo(TFile oldNode, TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.copyAllTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean archiveCopyTo(TFile oldNode, TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.archiveCopyTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean archiveCopyAllTo(TFile oldNode, TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        if (!ftm.archiveCopyAllTo(oldNode, node)) {
            return false;
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    public boolean renameTo(TFile oldNode, TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        TreePath oldPath = ftm.newTreePath(oldNode);
        Enumeration<TreePath> expansions = oldPath != null ? this.getExpandedDescendants(oldPath) : null;
        if (!ftm.renameTo(oldNode, node)) {
            return false;
        }
        if (expansions != null) {
            while (expansions.hasMoreElements()) {
                this.setExpandedState(this.substPath(expansions.nextElement(), oldPath, path), true);
            }
        }
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        return true;
    }

    private TreePath substPath(TreePath tp, TreePath oldPath, TreePath path) {
        TFile file = (TFile)tp.getLastPathComponent();
        if (file.equals(oldPath.getLastPathComponent())) {
            return path;
        }
        TreePath parent = this.substPath(tp.getParentPath(), oldPath, path);
        return parent.pathByAddingChild(new TFile((File)((TFile)parent.getLastPathComponent()), file.getName()));
    }

    public boolean delete(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        if (!ftm.delete(node)) {
            return false;
        }
        this.setSelectionRow(row);
        return true;
    }

    public boolean deleteAll(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path == null) {
            return false;
        }
        this.scrollPathToVisible(path);
        int row = this.getRowForPath(path);
        if (!ftm.deleteAll(node)) {
            return false;
        }
        this.setSelectionRow(row);
        return true;
    }

    public void setSelectionNode(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    public void setSelectionNodes(TFile[] nodes) {
        TFileTreeModel ftm = this.getModel();
        LinkedList<TreePath> list = new LinkedList<TreePath>();
        TreePath lastPath = null;
        int l = nodes.length;
        for (int i = 0; i < l; ++i) {
            lastPath = ftm.newTreePath(nodes[i]);
            if (lastPath == null) continue;
            list.add(lastPath);
        }
        int size = list.size();
        if (size > 0) {
            TreePath[] paths = new TreePath[size];
            list.toArray(paths);
            this.setSelectionPaths(paths);
        }
    }

    public void scrollNodeToVisible(TFile node) {
        TFileTreeModel ftm = this.getModel();
        TreePath path = ftm.newTreePath(node);
        if (path != null) {
            this.scrollPathToVisible(path);
        }
    }

    static {
        COLLATOR.setDecomposition(0);
        COLLATOR.setStrength(TFile.separatorChar == '\\' ? 1 : 2);
        FILE_NAME_COMPARATOR = new FileComparator();
    }

    private final class Controller
    implements TreeExpansionListener,
    CellEditorListener,
    Serializable {
        private static final long serialVersionUID = 6402557248752695675L;

        private Controller() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
            TFileTree.this.getModel().forget((TFile)evt.getPath().getLastPathComponent());
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
        }

        @Override
        public void editingCanceled(ChangeEvent evt) {
        }

        @Override
        public void editingStopped(ChangeEvent evt) {
            TFileTree.this.onEditingStopped(evt);
        }
    }

    private static final class FileComparator
    implements Comparator<TFile>,
    Serializable {
        private static final long serialVersionUID = 1234567890123456789L;

        private FileComparator() {
        }

        @Override
        public int compare(TFile f1, TFile f2) {
            return f1.isDirectory() ? (f2.isDirectory() ? COLLATOR.compare(f1.getName(), f2.getName()) : -1) : (f2.isDirectory() ? 1 : COLLATOR.compare(f1.getName(), f2.getName()));
        }
    }
}

