/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.module.fml.FmlContentParser;
import org.apache.maven.doxia.module.fml.FmlMarkup;
import org.apache.maven.doxia.module.fml.model.Faq;
import org.apache.maven.doxia.module.fml.model.Faqs;
import org.apache.maven.doxia.module.fml.model.Part;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.AbstractXmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.XhtmlBaseSink;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=Parser.class, hint="fml")
public class FmlParser
extends AbstractXmlParser
implements FmlMarkup {
    private Faqs faqs;
    private Part currentPart;
    private Faq currentFaq;
    private StringBuilder buffer;
    private Map<String, Set<String>> warnMessages;
    private String sourceContent;
    private String macroName;
    private Map<String, Object> macroParameters = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        this.faqs = null;
        this.sourceContent = null;
        this.init();
        try {
            StringWriter contentWriter = new StringWriter();
            IOUtil.copy((Reader)source, (Writer)contentWriter);
            this.sourceContent = contentWriter.toString();
        }
        catch (IOException ex) {
            throw new ParseException("Error reading the input source: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            IOUtil.close((Reader)source);
        }
        try {
            StringReader tmp = new StringReader(this.sourceContent);
            this.faqs = new Faqs();
            super.parse((Reader)tmp, sink, reference);
            this.writeFaqs(sink);
        }
        finally {
            this.logWarnings();
            this.faqs = null;
            this.sourceContent = null;
            this.setSecondParsing(false);
            this.init();
        }
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(FAQS_TAG.toString())) {
            String toplink;
            String title = parser.getAttributeValue(null, "title");
            if (title != null) {
                this.faqs.setTitle(title);
            }
            if ((toplink = parser.getAttributeValue(null, "toplink")) != null) {
                if (toplink.equalsIgnoreCase("true")) {
                    this.faqs.setToplink(true);
                } else {
                    this.faqs.setToplink(false);
                }
            }
        } else if (parser.getName().equals(PART_TAG.toString())) {
            this.currentPart = new Part();
            this.currentPart.setId(parser.getAttributeValue(null, HTML.Attribute.ID.toString()));
            if (this.currentPart.getId() == null) {
                throw new XmlPullParserException("id attribute required for <part> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            if (!DoxiaUtils.isValidId((String)this.currentPart.getId())) {
                String linkAnchor = DoxiaUtils.encodeId((String)this.currentPart.getId(), (boolean)true);
                String msg = "Modified invalid link: '" + this.currentPart.getId() + "' to '" + linkAnchor + "'";
                this.logMessage("modifiedLink", msg);
                this.currentPart.setId(linkAnchor);
            }
        } else if (parser.getName().equals(TITLE.toString())) {
            this.buffer = new StringBuilder();
            this.buffer.append('<').append(parser.getName()).append('>');
        } else if (parser.getName().equals(FAQ_TAG.toString())) {
            this.currentFaq = new Faq();
            this.currentFaq.setId(parser.getAttributeValue(null, HTML.Attribute.ID.toString()));
            if (this.currentFaq.getId() == null) {
                throw new XmlPullParserException("id attribute required for <faq> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            if (!DoxiaUtils.isValidId((String)this.currentFaq.getId())) {
                String linkAnchor = DoxiaUtils.encodeId((String)this.currentFaq.getId(), (boolean)true);
                String msg = "Modified invalid link: '" + this.currentFaq.getId() + "' to '" + linkAnchor + "'";
                this.logMessage("modifiedLink", msg);
                this.currentFaq.setId(linkAnchor);
            }
        } else if (parser.getName().equals(QUESTION_TAG.toString())) {
            this.buffer = new StringBuilder();
            this.buffer.append('<').append(parser.getName()).append('>');
        } else if (parser.getName().equals(ANSWER_TAG.toString())) {
            this.buffer = new StringBuilder();
            this.buffer.append('<').append(parser.getName()).append('>');
        } else if (parser.getName().equals(MACRO_TAG.toString())) {
            this.handleMacroStart(parser);
        } else if (parser.getName().equals(PARAM.toString())) {
            this.handleParamStart(parser, sink);
        } else if (this.buffer != null) {
            this.buffer.append('<').append(parser.getName());
            int count = parser.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                this.buffer.append(' ').append(parser.getAttributeName(i));
                this.buffer.append('=').append('\"');
                this.buffer.append(HtmlTools.escapeHTML((String)parser.getAttributeValue(i)));
                this.buffer.append('\"');
            }
            this.buffer.append('>');
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(FAQS_TAG.toString())) {
            return;
        }
        if (parser.getName().equals(PART_TAG.toString())) {
            this.faqs.addPart(this.currentPart);
            this.currentPart = null;
        } else if (parser.getName().equals(FAQ_TAG.toString())) {
            if (this.currentPart == null) {
                throw new XmlPullParserException("Missing <part>  at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            this.currentPart.addFaq(this.currentFaq);
            this.currentFaq = null;
        } else if (parser.getName().equals(QUESTION_TAG.toString())) {
            if (this.currentFaq == null) {
                throw new XmlPullParserException("Missing <faq> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            this.buffer.append('<').append('/').append(parser.getName()).append('>');
            this.currentFaq.setQuestion(this.buffer.toString());
            this.buffer = null;
        } else if (parser.getName().equals(ANSWER_TAG.toString())) {
            if (this.currentFaq == null) {
                throw new XmlPullParserException("Missing <faq> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            this.buffer.append('<').append('/').append(parser.getName()).append('>');
            this.currentFaq.setAnswer(this.buffer.toString());
            this.buffer = null;
        } else if (parser.getName().equals(TITLE.toString())) {
            if (this.currentPart == null) {
                throw new XmlPullParserException("Missing <part> at: (" + parser.getLineNumber() + ":" + parser.getColumnNumber() + ")");
            }
            this.buffer.append('<').append('/').append(parser.getName()).append('>');
            this.currentPart.setTitle(this.buffer.toString());
            this.buffer = null;
        } else if (parser.getName().equals(MACRO_TAG.toString())) {
            this.handleMacroEnd(this.buffer);
        } else if (parser.getName().equals(PARAM.toString())) {
            if (!StringUtils.isNotEmpty((String)this.macroName)) {
                this.handleUnknown(parser, sink, 3);
            }
        } else if (this.buffer != null) {
            if (this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == ' ') {
                this.buffer.deleteCharAt(this.buffer.length() - 1);
            }
            this.buffer.append('<').append('/').append(parser.getName()).append('>');
        }
    }

    protected void handleText(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (this.buffer != null) {
            this.buffer.append(parser.getText());
        }
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String cdSection = parser.getText();
        if (this.buffer != null) {
            this.buffer.append('<').append('!').append('[').append("CDATA").append('[').append(cdSection).append(']').append(']').append('>');
        } else {
            sink.text(cdSection);
        }
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String comment = parser.getText();
        if (this.buffer != null) {
            this.buffer.append('<').append('!').append('-').append('-').append(comment).append('-').append('-').append('>');
        } else if (this.isEmitComments()) {
            sink.comment(comment);
        }
    }

    protected void handleEntity(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        if (this.buffer != null) {
            if (parser.getText() != null) {
                String text = parser.getText();
                if (text.length() == 1) {
                    text = HtmlTools.escapeHTML((String)text);
                }
                this.buffer.append(text);
            }
        } else {
            super.handleEntity(parser, sink);
        }
    }

    protected void init() {
        super.init();
        this.currentFaq = null;
        this.currentPart = null;
        this.buffer = null;
        this.warnMessages = null;
        this.macroName = null;
        this.macroParameters = null;
    }

    private void handleMacroStart(XmlPullParser parser) throws MacroExecutionException {
        if (!this.isSecondParsing()) {
            this.macroName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            if (this.macroParameters == null) {
                this.macroParameters = new HashMap<String, Object>();
            }
            if (StringUtils.isEmpty((String)this.macroName)) {
                throw new MacroExecutionException("The '" + HTML.Attribute.NAME.toString() + "' attribute for the '" + MACRO_TAG.toString() + "' tag is required.");
            }
        }
    }

    private void handleMacroEnd(StringBuilder buffer) throws MacroExecutionException {
        if (!this.isSecondParsing() && StringUtils.isNotEmpty((String)this.macroName)) {
            MacroRequest request = new MacroRequest(this.sourceContent, (AbstractParser)new FmlParser(), this.macroParameters, this.getBasedir());
            try {
                StringWriter sw = new StringWriter();
                XhtmlBaseSink sink = new XhtmlBaseSink((Writer)sw);
                this.executeMacro(this.macroName, request, (Sink)sink);
                sink.close();
                buffer.append(sw.toString());
            }
            catch (MacroNotFoundException me) {
                throw new MacroExecutionException("Macro not found: " + this.macroName, (Throwable)me);
            }
        }
        this.macroName = null;
        this.macroParameters = null;
    }

    private void handleParamStart(XmlPullParser parser, Sink sink) throws MacroExecutionException {
        if (!this.isSecondParsing()) {
            if (StringUtils.isNotEmpty((String)this.macroName)) {
                String paramName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
                String paramValue = parser.getAttributeValue(null, HTML.Attribute.VALUE.toString());
                if (StringUtils.isEmpty((String)paramName) || StringUtils.isEmpty((String)paramValue)) {
                    throw new MacroExecutionException("'" + HTML.Attribute.NAME.toString() + "' and '" + HTML.Attribute.VALUE.toString() + "' attributes for the '" + PARAM.toString() + "' tag are required inside the '" + MACRO_TAG.toString() + "' tag.");
                }
                this.macroParameters.put(paramName, paramValue);
            } else {
                this.handleUnknown(parser, sink, 2);
            }
        }
    }

    private void writeFaqs(Sink sink) throws ParseException {
        FmlContentParser xdocParser = new FmlContentParser();
        xdocParser.enableLogging(this.getLog());
        sink.head();
        sink.title();
        sink.text(this.faqs.getTitle());
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.anchor("top");
        sink.text(this.faqs.getTitle());
        sink.anchor_();
        sink.sectionTitle1_();
        for (Part part : this.faqs.getParts()) {
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.paragraph();
                sink.inline(SinkEventAttributeSet.Semantics.BOLD);
                xdocParser.parse(part.getTitle(), sink);
                sink.inline_();
                sink.paragraph_();
            }
            sink.numberedList(0);
            for (Faq faq : part.getFaqs()) {
                sink.numberedListItem();
                sink.link("#" + faq.getId());
                if (!StringUtils.isNotEmpty((String)faq.getQuestion())) {
                    throw new ParseException("Missing <question> for FAQ '" + faq.getId() + "'");
                }
                xdocParser.parse(faq.getQuestion(), sink);
                sink.link_();
                sink.numberedListItem_();
            }
            sink.numberedList_();
        }
        sink.section1_();
        for (Part part : this.faqs.getParts()) {
            if (StringUtils.isNotEmpty((String)part.getTitle())) {
                sink.section1();
                sink.sectionTitle1();
                xdocParser.parse(part.getTitle(), sink);
                sink.sectionTitle1_();
            }
            sink.definitionList();
            Iterator<Faq> faqIterator = part.getFaqs().iterator();
            while (faqIterator.hasNext()) {
                Faq faq;
                faq = faqIterator.next();
                sink.definedTerm();
                sink.anchor(faq.getId());
                if (!StringUtils.isNotEmpty((String)faq.getQuestion())) {
                    throw new ParseException("Missing <question> for FAQ '" + faq.getId() + "'");
                }
                xdocParser.parse(faq.getQuestion(), sink);
                sink.anchor_();
                sink.definedTerm_();
                sink.definition();
                if (!StringUtils.isNotEmpty((String)faq.getAnswer())) {
                    throw new ParseException("Missing <answer> for FAQ '" + faq.getId() + "'");
                }
                xdocParser.parse(faq.getAnswer(), sink);
                if (this.faqs.isToplink()) {
                    this.writeTopLink(sink);
                }
                if (faqIterator.hasNext()) {
                    sink.horizontalRule();
                }
                sink.definition_();
            }
            sink.definitionList_();
            if (!StringUtils.isNotEmpty((String)part.getTitle())) continue;
            sink.section1_();
        }
        sink.body_();
    }

    private void writeTopLink(Sink sink) {
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute((Object)"align", (Object)"right");
        sink.paragraph((SinkEventAttributes)atts);
        sink.link("#top");
        sink.text("[top]");
        sink.link_();
        sink.paragraph_();
    }

    private void logMessage(String key, String msg) {
        Set<String> set;
        msg = "[FML Parser] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)msg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, Set<String>>();
        }
        if ((set = this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(msg);
        this.warnMessages.put(key, set);
    }

    private void logWarnings() {
        if (this.getLog().isWarnEnabled() && this.warnMessages != null && !this.isSecondParsing()) {
            for (Map.Entry<String, Set<String>> entry : this.warnMessages.entrySet()) {
                for (String msg : entry.getValue()) {
                    this.getLog().warn((CharSequence)msg);
                }
            }
            this.warnMessages = null;
        }
    }
}

