/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser.list;

import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.list.TreeListBuilder;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class ListBlockParser
implements BlockParser {
    public static final int BULLETED_LIST = 0;
    public static final int NUMBERED_LIST = 1;

    public boolean accept(String line, ByLineSource source) {
        return this.isList(line);
    }

    public Block visit(String line, ByLineSource source) throws ParseException {
        TreeListBuilder treeListBuilder = new TreeListBuilder();
        StringBuffer text = new StringBuffer();
        while (line.trim().length() != 0) {
            if (text.length() > 0 && this.isList(line)) {
                this.addItem(treeListBuilder, text);
            }
            if (text.length() == 0) {
                text.append(line.trim());
            } else {
                text.append(" " + line.trim());
            }
            if ((line = source.getNextLine()) != null) continue;
        }
        if (text.length() > 0) {
            this.addItem(treeListBuilder, text);
        }
        return treeListBuilder.getBlock();
    }

    private void addItem(TreeListBuilder treeListBuilder, StringBuffer text) {
        String item = text.toString();
        if (this.isBulletedList(item)) {
            int level = this.getLevel(item, '*');
            treeListBuilder.feedEntry(0, level, item.substring(level));
        } else {
            int level = this.getLevel(item, '#');
            treeListBuilder.feedEntry(1, level, item.substring(level));
        }
        text.setLength(0);
    }

    private int getLevel(String line, char c) {
        int level = 0;
        while (line.charAt(level) == c) {
            ++level;
        }
        return level;
    }

    private boolean isBulletedList(String line) {
        return line.startsWith("*") || line.startsWith("-");
    }

    private boolean isList(String line) {
        return (line = line.trim()).startsWith("*") || line.startsWith("-") || line.startsWith("#");
    }
}

