/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser;

import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BlockParser;
import org.apache.maven.doxia.module.confluence.parser.FigureBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class FigureBlockParser
implements BlockParser {
    public boolean accept(String line, ByLineSource source) {
        return line.startsWith("!") && line.lastIndexOf("!") > 1;
    }

    public Block visit(String line, ByLineSource source) throws ParseException {
        String caption;
        String image = line.substring(1, line.lastIndexOf("!"));
        if ((line = line.substring(line.lastIndexOf("!") + 1).trim()).startsWith("\\\\")) {
            line = line.substring(2);
        }
        if ((caption = line + this.appendUntilEmptyLine(source)).trim().length() > 0) {
            return new FigureBlock(image, caption);
        }
        return new FigureBlock(image);
    }

    private String appendUntilEmptyLine(ByLineSource source) throws ParseException {
        String line;
        StringBuffer text = new StringBuffer();
        while ((line = source.getNextLine()) != null && line.trim().length() != 0) {
            if (text.length() == 0) {
                text.append(line.trim());
                continue;
            }
            text.append(" " + line.trim());
        }
        return text.toString();
    }
}

