/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.module.confluence.parser.AnchorBlock;
import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BoldBlock;
import org.apache.maven.doxia.module.confluence.parser.ItalicBlock;
import org.apache.maven.doxia.module.confluence.parser.LinebreakBlock;
import org.apache.maven.doxia.module.confluence.parser.LinkBlock;
import org.apache.maven.doxia.module.confluence.parser.MonospaceBlock;
import org.apache.maven.doxia.module.confluence.parser.TextBlock;
import org.codehaus.plexus.util.StringUtils;

public class ChildBlocksBuilder {
    private boolean insideBold = false;
    private boolean insideItalic = false;
    private boolean insideLink = false;
    private List blocks = new ArrayList();
    private StringBuffer text = new StringBuffer();
    private String input;
    private boolean insideMonospaced;

    public ChildBlocksBuilder(String input) {
        this.input = input;
    }

    public List getBlocks() {
        List specialBlocks = new ArrayList();
        for (int i = 0; i < this.input.length(); ++i) {
            char c = this.input.charAt(i);
            switch (c) {
                case '*': {
                    if (this.insideBold) {
                        this.insideBold = false;
                        specialBlocks = this.getList(new BoldBlock(this.getChildren(this.text, specialBlocks)), specialBlocks);
                        this.text = new StringBuffer();
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideBold = true;
                    break;
                }
                case '_': {
                    if (this.insideItalic) {
                        this.insideItalic = false;
                        specialBlocks = this.getList(new ItalicBlock(this.getChildren(this.text, specialBlocks)), specialBlocks);
                        this.text = new StringBuffer();
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideItalic = true;
                    break;
                }
                case '[': {
                    this.insideLink = true;
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    break;
                }
                case ']': {
                    if (!this.insideLink) break;
                    String link = this.text.toString();
                    if (link.indexOf("|") > 0) {
                        String[] pieces = StringUtils.split((String)this.text.toString(), (String)"|");
                        this.blocks.add(new LinkBlock(pieces[1], pieces[0]));
                    } else {
                        String value = link;
                        if (link.startsWith("#")) {
                            value = link.substring(1);
                        }
                        this.blocks.add(new LinkBlock(link, value));
                    }
                    this.text = new StringBuffer();
                    this.insideLink = false;
                    break;
                }
                case '{': {
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    if (ChildBlocksBuilder.charAt(this.input, i) != '{') break;
                    ++i;
                    this.insideMonospaced = true;
                    break;
                }
                case '}': {
                    if (ChildBlocksBuilder.charAt(this.input, i) == '}') {
                        ++i;
                        this.insideMonospaced = false;
                        specialBlocks = this.getList(new MonospaceBlock(this.getChildren(this.text, specialBlocks)), specialBlocks);
                        this.text = new StringBuffer();
                        break;
                    }
                    String name = this.text.toString();
                    if (name.startsWith("anchor:")) {
                        this.blocks.add(new AnchorBlock(name.substring("anchor:".length())));
                    } else {
                        this.blocks.add(new TextBlock("{" + name + "}"));
                    }
                    this.text = new StringBuffer();
                    break;
                }
                case '\\': {
                    if (ChildBlocksBuilder.charAt(this.input, i) == '\\') {
                        ++i;
                        this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                        this.blocks.add(new LinebreakBlock());
                        break;
                    }
                    this.text.append(this.input.charAt(++i));
                    break;
                }
                default: {
                    this.text.append(c);
                }
            }
            if (specialBlocks.isEmpty() || this.insideItalic || this.insideBold || this.insideMonospaced) continue;
            this.blocks.addAll(specialBlocks);
            specialBlocks.clear();
        }
        if (this.text.length() > 0) {
            this.blocks.add(new TextBlock(this.text.toString()));
        }
        return this.blocks;
    }

    private List getList(Block block, List currentBlocks) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (this.insideBold || this.insideItalic || this.insideMonospaced) {
            list.addAll(currentBlocks);
        }
        list.add(block);
        return list;
    }

    private List getChildren(StringBuffer buffer, List currentBlocks) {
        String text = buffer.toString().trim();
        if (currentBlocks.isEmpty() && StringUtils.isEmpty((String)text)) {
            return new ArrayList();
        }
        ArrayList<TextBlock> list = new ArrayList<TextBlock>();
        if (!(this.insideBold || this.insideItalic || this.insideMonospaced)) {
            list.addAll(currentBlocks);
        }
        if (StringUtils.isEmpty((String)text)) {
            return list;
        }
        list.add(new TextBlock(text));
        return list;
    }

    private static char charAt(String input, int i) {
        return input.length() > i + 1 ? input.charAt(i + 1) : (char)'\u0000';
    }

    private StringBuffer addTextBlockIfNecessary(List blocks, List specialBlocks, StringBuffer text) {
        if (text.length() == 0) {
            return text;
        }
        TextBlock textBlock = new TextBlock(text.toString());
        if (!(this.insideBold || this.insideItalic || this.insideMonospaced)) {
            blocks.add(textBlock);
        } else {
            specialBlocks.add(textBlock);
        }
        return new StringBuffer();
    }
}

