/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.commons.lang3.Validate;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.model.Plugin;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.DebugConfigurationListener;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MavenPluginValidator;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginIncompatibleException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginParameterException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.internal.ValidatingConfigurationListener;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.ExtensionDescriptorBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

@Component(role=MavenPluginManager.class)
public class DefaultMavenPluginManager
implements MavenPluginManager {
    public static final String KEY_EXTENSIONS_REALMS = DefaultMavenPluginManager.class.getName() + "/extensionsRealms";
    @Requirement
    private Logger logger;
    @Requirement
    private LoggerManager loggerManager;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ClassRealmManager classRealmManager;
    @Requirement
    private PluginDescriptorCache pluginDescriptorCache;
    @Requirement
    private PluginRealmCache pluginRealmCache;
    @Requirement
    private PluginDependenciesResolver pluginDependenciesResolver;
    @Requirement
    private RuntimeInformation runtimeInformation;
    @Requirement
    private ExtensionRealmCache extensionRealmCache;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private PluginArtifactsCache pluginArtifactsCache;
    private ExtensionDescriptorBuilder extensionDescriptorBuilder = new ExtensionDescriptorBuilder();
    private PluginDescriptorBuilder builder = new PluginDescriptorBuilder();

    @Override
    public synchronized PluginDescriptor getPluginDescriptor(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptorCache.Key cacheKey = this.pluginDescriptorCache.createKey(plugin, repositories, session);
        PluginDescriptor pluginDescriptor = this.pluginDescriptorCache.get(cacheKey);
        if (pluginDescriptor == null) {
            org.eclipse.aether.artifact.Artifact artifact = this.pluginDependenciesResolver.resolve(plugin, repositories, session);
            Artifact pluginArtifact = RepositoryUtils.toArtifact(artifact);
            pluginDescriptor = this.extractPluginDescriptor(pluginArtifact, plugin);
            pluginDescriptor.setRequiredMavenVersion(artifact.getProperty("requiredMavenVersion", null));
            this.pluginDescriptorCache.put(cacheKey, pluginDescriptor);
        }
        pluginDescriptor.setPlugin(plugin);
        return pluginDescriptor;
    }

    /*
     * Unable to fully structure code
     */
    private PluginDescriptor extractPluginDescriptor(Artifact pluginArtifact, Plugin plugin) throws PluginDescriptorParsingException, InvalidPluginDescriptorException {
        pluginDescriptor = null;
        pluginFile = pluginArtifact.getFile();
        try {
            if (pluginFile.isFile()) {
                pluginJar = new JarFile(pluginFile, false);
                var6_7 = null;
                try {
                    pluginDescriptorEntry = pluginJar.getEntry(this.getPluginDescriptorLocation());
                    if (pluginDescriptorEntry == null) ** GOTO lbl48
                    is = pluginJar.getInputStream(pluginDescriptorEntry);
                    pluginDescriptor = this.parsePluginDescriptor(is, plugin, pluginFile.getAbsolutePath());
                }
                catch (Throwable var7_11) {
                    var6_7 = var7_11;
                    throw var7_11;
                }
                finally {
                    if (pluginJar != null) {
                        if (var6_7 != null) {
                            try {
                                pluginJar.close();
                            }
                            catch (Throwable var7_10) {
                                var6_7.addSuppressed(var7_10);
                            }
                        } else {
                            pluginJar.close();
                        }
                    }
                }
            } else {
                pluginXml = new File(pluginFile, this.getPluginDescriptorLocation());
                if (pluginXml.isFile()) {
                    is = new BufferedInputStream(new FileInputStream(pluginXml));
                    var7_12 = null;
                    try {
                        pluginDescriptor = this.parsePluginDescriptor(is, plugin, pluginXml.getAbsolutePath());
                    }
                    catch (Throwable var8_15) {
                        var7_12 = var8_15;
                        throw var8_15;
                    }
                    finally {
                        if (is != null) {
                            if (var7_12 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable var8_14) {
                                    var7_12.addSuppressed(var8_14);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
            }
            if (pluginDescriptor == null) {
                throw new IOException("No plugin descriptor found at " + this.getPluginDescriptorLocation());
            }
        }
        catch (IOException e) {
            throw new PluginDescriptorParsingException(plugin, pluginFile.getAbsolutePath(), e);
        }
        validator = new MavenPluginValidator(pluginArtifact);
        validator.validate(pluginDescriptor);
        if (validator.hasErrors()) {
            throw new InvalidPluginDescriptorException("Invalid plugin descriptor for " + plugin.getId() + " (" + pluginFile + ")", validator.getErrors());
        }
        pluginDescriptor.setPluginArtifact(pluginArtifact);
        return pluginDescriptor;
    }

    private String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    private PluginDescriptor parsePluginDescriptor(InputStream is, Plugin plugin, String descriptorLocation) throws PluginDescriptorParsingException {
        try {
            XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)is);
            PluginDescriptor pluginDescriptor = this.builder.build((Reader)reader, descriptorLocation);
            return pluginDescriptor;
        }
        catch (IOException | PlexusConfigurationException e) {
            throw new PluginDescriptorParsingException(plugin, descriptorLocation, e);
        }
    }

    @Override
    public MojoDescriptor getMojoDescriptor(Plugin plugin, String goal, List<RemoteRepository> repositories, RepositorySystemSession session) throws MojoNotFoundException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(plugin, repositories, session);
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoNotFoundException(goal, pluginDescriptor);
        }
        return mojoDescriptor;
    }

    @Override
    public void checkRequiredMavenVersion(PluginDescriptor pluginDescriptor) throws PluginIncompatibleException {
        String requiredMavenVersion = pluginDescriptor.getRequiredMavenVersion();
        if (StringUtils.isNotBlank((String)requiredMavenVersion)) {
            try {
                if (!this.runtimeInformation.isMavenVersion(requiredMavenVersion)) {
                    throw new PluginIncompatibleException(pluginDescriptor.getPlugin(), "The plugin " + pluginDescriptor.getId() + " requires Maven version " + requiredMavenVersion);
                }
            }
            catch (RuntimeException e) {
                this.logger.warn("Could not verify plugin's Maven prerequisite: " + e.getMessage());
            }
        }
    }

    @Override
    public synchronized void setupPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports, DependencyFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = pluginDescriptor.getPlugin();
        MavenProject project = session.getCurrentProject();
        if (plugin.isExtensions()) {
            ExtensionRealmCache.CacheRecord extensionRecord;
            try {
                RepositorySystemSession repositorySession = session.getRepositorySession();
                extensionRecord = this.setupExtensionsRealm(project, plugin, repositorySession);
            }
            catch (PluginManagerException e) {
                throw new IllegalStateException(e);
            }
            ClassRealm pluginRealm = extensionRecord.getRealm();
            List<Artifact> pluginArtifacts = extensionRecord.getArtifacts();
            for (ComponentDescriptor componentDescriptor : pluginDescriptor.getComponents()) {
                componentDescriptor.setRealm(pluginRealm);
            }
            pluginDescriptor.setClassRealm(pluginRealm);
            pluginDescriptor.setArtifacts(pluginArtifacts);
        } else {
            Map<String, ClassLoader> foreignImports = this.calcImports(project, parent, imports);
            PluginRealmCache.Key cacheKey = this.pluginRealmCache.createKey(plugin, parent, foreignImports, filter, project.getRemotePluginRepositories(), session.getRepositorySession());
            PluginRealmCache.CacheRecord cacheRecord = this.pluginRealmCache.get(cacheKey);
            if (cacheRecord != null) {
                pluginDescriptor.setClassRealm(cacheRecord.getRealm());
                pluginDescriptor.setArtifacts(new ArrayList<Artifact>(cacheRecord.getArtifacts()));
                for (ComponentDescriptor componentDescriptor : pluginDescriptor.getComponents()) {
                    componentDescriptor.setRealm(cacheRecord.getRealm());
                }
            } else {
                this.createPluginRealm(pluginDescriptor, session, parent, foreignImports, filter);
                cacheRecord = this.pluginRealmCache.put(cacheKey, pluginDescriptor.getClassRealm(), pluginDescriptor.getArtifacts());
            }
            this.pluginRealmCache.register(project, cacheKey, cacheRecord);
        }
    }

    private void createPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, Map<String, ClassLoader> foreignImports, DependencyFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = (Plugin)Validate.notNull((Object)pluginDescriptor.getPlugin(), (String)"pluginDescriptor.plugin cannot be null", (Object[])new Object[0]);
        Artifact pluginArtifact = (Artifact)Validate.notNull((Object)pluginDescriptor.getPluginArtifact(), (String)"pluginDescriptor.pluginArtifact cannot be null", (Object[])new Object[0]);
        MavenProject project = session.getCurrentProject();
        RepositorySystemSession repositorySession = session.getRepositorySession();
        DependencyFilter dependencyFilter = project.getExtensionDependencyFilter();
        dependencyFilter = AndDependencyFilter.newInstance((DependencyFilter)dependencyFilter, (DependencyFilter)filter);
        DependencyNode root = this.pluginDependenciesResolver.resolve(plugin, RepositoryUtils.toArtifact(pluginArtifact), dependencyFilter, project.getRemotePluginRepositories(), repositorySession);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept((DependencyVisitor)nlg);
        List<Artifact> pluginArtifacts = this.toMavenArtifacts(root, nlg);
        ClassRealm pluginRealm = this.classRealmManager.createPluginRealm(plugin, parent, null, foreignImports, this.toAetherArtifacts(pluginArtifacts));
        this.discoverPluginComponents(pluginRealm, plugin, pluginDescriptor);
        pluginDescriptor.setClassRealm(pluginRealm);
        pluginDescriptor.setArtifacts(pluginArtifacts);
    }

    private void discoverPluginComponents(ClassRealm pluginRealm, Plugin plugin, PluginDescriptor pluginDescriptor) throws PluginContainerException {
        try {
            if (pluginDescriptor != null) {
                for (ComponentDescriptor componentDescriptor : pluginDescriptor.getComponents()) {
                    componentDescriptor.setRealm(pluginRealm);
                    this.container.addComponentDescriptor(componentDescriptor);
                }
            }
            ((DefaultPlexusContainer)this.container).discoverComponents(pluginRealm, new Module[]{new SessionScopeModule(this.container), new MojoExecutionScopeModule(this.container)});
        }
        catch (CycleDetectedInComponentGraphException | ComponentLookupException e) {
            throw new PluginContainerException(plugin, pluginRealm, "Error in component graph of plugin " + plugin.getId() + ": " + e.getMessage(), e);
        }
    }

    private List<org.eclipse.aether.artifact.Artifact> toAetherArtifacts(List<Artifact> pluginArtifacts) {
        return new ArrayList<org.eclipse.aether.artifact.Artifact>(RepositoryUtils.toArtifacts(pluginArtifacts));
    }

    private List<Artifact> toMavenArtifacts(DependencyNode root, PreorderNodeListGenerator nlg) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(nlg.getNodes().size());
        RepositoryUtils.toArtifacts(artifacts, Collections.singleton(root), Collections.emptyList(), null);
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (artifact.getFile() != null) continue;
            it.remove();
        }
        return artifacts;
    }

    private Map<String, ClassLoader> calcImports(MavenProject project, ClassLoader parent, List<String> imports) {
        HashMap<String, ClassLoader> foreignImports = new HashMap<String, ClassLoader>();
        ClassRealm projectRealm = project.getClassRealm();
        if (projectRealm != null) {
            foreignImports.put("", (ClassLoader)projectRealm);
        } else {
            foreignImports.put("", (ClassLoader)this.classRealmManager.getMavenApiRealm());
        }
        if (parent != null && imports != null) {
            for (String parentImport : imports) {
                foreignImports.put(parentImport, parent);
            }
        }
        return foreignImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getConfiguredMojo(Class<T> mojoInterface, MavenSession session, MojoExecution mojoExecution) throws PluginConfigurationException, PluginContainerException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuring mojo " + mojoDescriptor.getId() + " from plugin realm " + pluginRealm);
        }
        ClassRealm oldLookupRealm = this.container.setLookupRealm(pluginRealm);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
        try {
            Xpp3Dom dom;
            MavenProject project;
            Map<String, Object> pluginContext;
            Object mojo;
            try {
                mojo = this.container.lookup(mojoInterface, mojoDescriptor.getRoleHint());
            }
            catch (ComponentLookupException e) {
                Throwable cause;
                for (cause = e.getCause(); cause != null && !(cause instanceof LinkageError) && !(cause instanceof ClassNotFoundException); cause = cause.getCause()) {
                }
                if (cause instanceof NoClassDefFoundError || cause instanceof ClassNotFoundException) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("Unable to load the mojo '" + mojoDescriptor.getGoal() + "' in the plugin '" + pluginDescriptor.getId() + "'. A required class is missing: " + cause.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
                }
                if (cause instanceof LinkageError) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("Unable to load the mojo '" + mojoDescriptor.getGoal() + "' in the plugin '" + pluginDescriptor.getId() + "' due to an API incompatibility: " + ((Object)((Object)e)).getClass().getName() + ": " + cause.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
                }
                throw new PluginContainerException(mojoDescriptor, pluginRealm, "Unable to load the mojo '" + mojoDescriptor.getGoal() + "' (or one of its required components) from the plugin '" + pluginDescriptor.getId() + "'", e);
            }
            if (mojo instanceof ContextEnabled && (pluginContext = session.getPluginContext(pluginDescriptor, project = session.getCurrentProject())) != null) {
                pluginContext.put("project", project);
                pluginContext.put("pluginDescriptor", pluginDescriptor);
                ((ContextEnabled)mojo).setPluginContext(pluginContext);
            }
            if (mojo instanceof Mojo) {
                Logger mojoLogger = this.loggerManager.getLoggerForComponent(mojoDescriptor.getImplementation());
                ((Mojo)mojo).setLog((Log)new DefaultLog(mojoLogger));
            }
            XmlPlexusConfiguration pomConfiguration = (dom = mojoExecution.getConfiguration()) == null ? new XmlPlexusConfiguration("configuration") : new XmlPlexusConfiguration(dom);
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
            this.populatePluginFields(mojo, mojoDescriptor, pluginRealm, (PlexusConfiguration)pomConfiguration, (ExpressionEvaluator)expressionEvaluator);
            Object object = mojo;
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.container.setLookupRealm(oldLookupRealm);
        }
    }

    private void populatePluginFields(Object mojo, MojoDescriptor mojoDescriptor, ClassRealm pluginRealm, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        ComponentConfigurator configurator = null;
        String configuratorId = mojoDescriptor.getComponentConfigurator();
        if (StringUtils.isEmpty((String)configuratorId)) {
            configuratorId = "basic";
        }
        try {
            configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, configuratorId);
            DebugConfigurationListener listener = new DebugConfigurationListener(this.logger);
            ValidatingConfigurationListener validator = new ValidatingConfigurationListener(mojo, mojoDescriptor, listener);
            this.logger.debug("Configuring mojo '" + mojoDescriptor.getId() + "' with " + configuratorId + " configurator -->");
            configurator.configureComponent(mojo, configuration, expressionEvaluator, pluginRealm, (ConfigurationListener)validator);
            this.logger.debug("-- end configuration --");
            Collection<Parameter> missingParameters = validator.getMissingParameters();
            if (!missingParameters.isEmpty()) {
                if ("basic".equals(configuratorId)) {
                    throw new PluginParameterException(mojoDescriptor, new ArrayList<Parameter>(missingParameters));
                }
                this.validateParameters(mojoDescriptor, configuration, expressionEvaluator);
            }
        }
        catch (ComponentConfigurationException e) {
            String message = "Unable to parse configuration of mojo " + mojoDescriptor.getId();
            if (e.getFailedConfiguration() != null) {
                message = message + " for parameter " + e.getFailedConfiguration().getName();
            }
            message = message + ": " + e.getMessage();
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), message, e);
        }
        catch (ComponentLookupException e) {
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "Unable to retrieve component configurator " + configuratorId + " for configuration of mojo " + mojoDescriptor.getId(), e);
        }
        catch (NoClassDefFoundError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("A required class was missing during configuration of mojo " + mojoDescriptor.getId() + ": " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        catch (LinkageError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("An API incompatibility was encountered during configuration of mojo " + mojoDescriptor.getId() + ": " + e.getClass().getName() + ": " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        finally {
            if (configurator != null) {
                try {
                    this.container.release((Object)configurator);
                }
                catch (ComponentLifecycleException e) {
                    this.logger.debug("Failed to release mojo configurator - ignoring.");
                }
            }
        }
    }

    private void validateParameters(MojoDescriptor mojoDescriptor, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException, PluginParameterException {
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        ArrayList<Parameter> invalidParameters = new ArrayList<Parameter>();
        for (Parameter parameter : mojoDescriptor.getParameters()) {
            if (!parameter.isRequired()) continue;
            Object value = null;
            PlexusConfiguration config = configuration.getChild(parameter.getName(), false);
            if (config != null) {
                String expression = config.getValue(null);
                try {
                    value = expressionEvaluator.evaluate(expression);
                    if (value == null) {
                        value = config.getAttribute("default-value", null);
                    }
                }
                catch (ExpressionEvaluationException e) {
                    String msg = "Error evaluating the expression '" + expression + "' for configuration value '" + configuration.getName() + "'";
                    throw new ComponentConfigurationException(configuration, msg, (Throwable)e);
                }
            }
            if (value != null || config != null && config.getChildCount() > 0) continue;
            invalidParameters.add(parameter);
        }
        if (!invalidParameters.isEmpty()) {
            throw new PluginParameterException(mojoDescriptor, invalidParameters);
        }
    }

    @Override
    public void releaseMojo(Object mojo, MojoExecution mojoExecution) {
        if (mojo != null) {
            try {
                this.container.release(mojo);
            }
            catch (ComponentLifecycleException e) {
                String goalExecId = mojoExecution.getGoal();
                if (mojoExecution.getExecutionId() != null) {
                    goalExecId = goalExecId + " {execution: " + mojoExecution.getExecutionId() + "}";
                }
                this.logger.debug("Error releasing mojo for " + goalExecId, (Throwable)e);
            }
        }
    }

    @Override
    public ExtensionRealmCache.CacheRecord setupExtensionsRealm(MavenProject project, Plugin plugin, RepositorySystemSession session) throws PluginManagerException {
        List<Artifact> artifacts;
        PluginArtifactsCache.CacheRecord recordArtifacts;
        String pluginKey;
        ExtensionRealmCache.CacheRecord extensionRecord;
        HashMap<String, ExtensionRealmCache.CacheRecord> pluginRealms = (HashMap<String, ExtensionRealmCache.CacheRecord>)project.getContextValue(KEY_EXTENSIONS_REALMS);
        if (pluginRealms == null) {
            pluginRealms = new HashMap<String, ExtensionRealmCache.CacheRecord>();
            project.setContextValue(KEY_EXTENSIONS_REALMS, pluginRealms);
        }
        if ((extensionRecord = (ExtensionRealmCache.CacheRecord)pluginRealms.get(pluginKey = plugin.getId())) != null) {
            return extensionRecord;
        }
        List<RemoteRepository> repositories = project.getRemotePluginRepositories();
        if (plugin.getVersion() == null) {
            DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session, repositories);
            try {
                plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
            }
            catch (PluginVersionResolutionException e) {
                throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
            }
        }
        PluginArtifactsCache.Key cacheKey = this.pluginArtifactsCache.createKey(plugin, null, repositories, session);
        try {
            recordArtifacts = this.pluginArtifactsCache.get(cacheKey);
        }
        catch (PluginResolutionException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        if (recordArtifacts != null) {
            artifacts = recordArtifacts.getArtifacts();
        } else {
            try {
                artifacts = this.resolveExtensionArtifacts(plugin, repositories, session);
                recordArtifacts = this.pluginArtifactsCache.put(cacheKey, artifacts);
            }
            catch (PluginResolutionException e) {
                this.pluginArtifactsCache.put(cacheKey, e);
                this.pluginArtifactsCache.register(project, cacheKey, recordArtifacts);
                throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
            }
        }
        this.pluginArtifactsCache.register(project, cacheKey, recordArtifacts);
        ExtensionRealmCache.Key extensionKey = this.extensionRealmCache.createKey(artifacts);
        extensionRecord = this.extensionRealmCache.get(extensionKey);
        if (extensionRecord == null) {
            ClassRealm extensionRealm = this.classRealmManager.createExtensionRealm(plugin, this.toAetherArtifacts(artifacts));
            PluginDescriptor pluginDescriptor = null;
            if (plugin.isExtensions() && !artifacts.isEmpty()) {
                try {
                    pluginDescriptor = this.extractPluginDescriptor(artifacts.get(0), plugin);
                }
                catch (InvalidPluginDescriptorException | PluginDescriptorParsingException exception) {
                    // empty catch block
                }
            }
            this.discoverPluginComponents(extensionRealm, plugin, pluginDescriptor);
            ExtensionDescriptor extensionDescriptor = null;
            Artifact extensionArtifact = artifacts.get(0);
            try {
                extensionDescriptor = this.extensionDescriptorBuilder.build(extensionArtifact.getFile());
            }
            catch (IOException e) {
                String message = "Invalid extension descriptor for " + plugin.getId() + ": " + e.getMessage();
                if (this.logger.isDebugEnabled()) {
                    this.logger.error(message, (Throwable)e);
                }
                this.logger.error(message);
            }
            extensionRecord = this.extensionRealmCache.put(extensionKey, extensionRealm, extensionDescriptor, artifacts);
        }
        this.extensionRealmCache.register(project, extensionKey, extensionRecord);
        pluginRealms.put(pluginKey, extensionRecord);
        return extensionRecord;
    }

    private List<Artifact> resolveExtensionArtifacts(Plugin extensionPlugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyNode root = this.pluginDependenciesResolver.resolve(extensionPlugin, null, null, repositories, session);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept((DependencyVisitor)nlg);
        return this.toMavenArtifacts(root, nlg);
    }
}

