/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser.builders;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryFilter;
import org.apache.lucene.xmlparser.DOMUtils;
import org.apache.lucene.xmlparser.FilterBuilder;
import org.apache.lucene.xmlparser.FilterBuilderFactory;
import org.apache.lucene.xmlparser.ParserException;
import org.apache.lucene.xmlparser.QueryBuilder;
import org.apache.lucene.xmlparser.QueryBuilderFactory;
import org.w3c.dom.Element;

public class CachedFilterBuilder
implements FilterBuilder {
    private QueryBuilderFactory queryFactory;
    private FilterBuilderFactory filterFactory;
    private LRUCache filterCache = null;
    private int cacheSize;

    public CachedFilterBuilder(QueryBuilderFactory queryFactory, FilterBuilderFactory filterFactory, int cacheSize) {
        this.queryFactory = queryFactory;
        this.filterFactory = filterFactory;
        this.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter(Element e) throws ParserException {
        Element childElement = DOMUtils.getFirstChildOrFail(e);
        if (this.filterCache == null) {
            this.filterCache = new LRUCache(this.cacheSize);
        }
        QueryBuilder qb = this.queryFactory.getQueryBuilder(childElement.getNodeName());
        Query cacheKey = null;
        Query q = null;
        Filter f = null;
        if (qb != null) {
            cacheKey = q = qb.getQuery(childElement);
        } else {
            f = this.filterFactory.getFilter(childElement);
            cacheKey = f;
        }
        Object cachedFilter = null;
        LRUCache lRUCache = this.filterCache;
        synchronized (lRUCache) {
            cachedFilter = (Filter)this.filterCache.get(cacheKey);
            if (cachedFilter != null) {
                return cachedFilter;
            }
        }
        cachedFilter = qb != null ? new QueryFilter(q) : new CachingWrapperFilter(f);
        lRUCache = this.filterCache;
        synchronized (lRUCache) {
            this.filterCache.put(cacheKey, cachedFilter);
        }
        return cachedFilter;
    }

    static class LRUCache
    extends LinkedHashMap {
        protected int maxsize;

        public LRUCache(int maxsize) {
            super(maxsize * 4 / 3 + 1, 0.75f, true);
            this.maxsize = maxsize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxsize;
        }
    }
}

