/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.wordnet;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class SynLookup {
    public static void main(String[] args) throws IOException {
        String word;
        FSDirectory directory;
        IndexSearcher searcher;
        Hits hits;
        if (args.length != 2) {
            System.out.println("java org.apache.lucene.wordnet.SynLookup <index path> <word>");
        }
        if ((hits = (searcher = new IndexSearcher((Directory)(directory = FSDirectory.getDirectory((String)args[0], (boolean)false)))).search((Query)new TermQuery(new Term("word", word = args[1])))).length() == 0) {
            System.out.println("No synonyms found for " + word);
        } else {
            System.out.println("Synonyms found for \"" + word + "\":");
        }
        for (int i = 0; i < hits.length(); ++i) {
            Document doc = hits.doc(i);
            String[] values = doc.getValues("syn");
            for (int j = 0; j < values.length; ++j) {
                System.out.println(values[j]);
            }
        }
        searcher.close();
        directory.close();
    }

    public static Query expand(String query, Searcher syns, Analyzer a, String field, float boost) throws IOException {
        Token t;
        HashSet<String> already = new HashSet<String>();
        LinkedList<String> top = new LinkedList<String>();
        TokenStream ts = a.tokenStream(field, (Reader)new StringReader(query));
        while ((t = ts.next()) != null) {
            String word = t.termText();
            if (!already.add(word)) continue;
            top.add(word);
        }
        BooleanQuery tmp = new BooleanQuery();
        Iterator it = top.iterator();
        while (it.hasNext()) {
            String word = (String)it.next();
            TermQuery tq = new TermQuery(new Term(field, word));
            tmp.add((Query)tq, BooleanClause.Occur.SHOULD);
            Hits hits = syns.search((Query)new TermQuery(new Term("word", word)));
            for (int i = 0; i < hits.length(); ++i) {
                Document doc = hits.doc(i);
                String[] values = doc.getValues("syn");
                for (int j = 0; j < values.length; ++j) {
                    String syn = values[j];
                    if (!already.add(syn)) continue;
                    tq = new TermQuery(new Term(field, syn));
                    if (boost > 0.0f) {
                        tq.setBoost(boost);
                    }
                    tmp.add((Query)tq, BooleanClause.Occur.SHOULD);
                }
            }
        }
        return tmp;
    }
}

