/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search.similarities;

import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.Similarity;

public class AssertingSimilarity
extends Similarity {
    private final Similarity delegate;

    public AssertingSimilarity(Similarity delegate) {
        this.delegate = delegate;
    }

    public long computeNorm(FieldInvertState state) {
        assert (state != null);
        assert (state.getLength() > 0);
        assert (state.getPosition() >= 0);
        assert (state.getOffset() >= 0);
        assert (state.getMaxTermFrequency() >= 0);
        assert (state.getMaxTermFrequency() <= state.getLength());
        assert (state.getNumOverlap() >= 0);
        assert (state.getNumOverlap() < state.getLength());
        assert (state.getUniqueTermCount() > 0);
        assert (state.getUniqueTermCount() <= state.getLength());
        long norm = this.delegate.computeNorm(state);
        assert (norm != 0L);
        return norm;
    }

    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        assert (boost >= 0.0f);
        assert (collectionStats != null);
        assert (termStats.length > 0);
        for (TermStatistics term : termStats) {
            assert (term != null);
        }
        Similarity.SimScorer scorer = this.delegate.scorer(boost, collectionStats, termStats);
        assert (scorer != null);
        return new AssertingSimScorer(scorer, boost);
    }

    public String toString() {
        return "Asserting(" + this.delegate + ")";
    }

    static class AssertingSimScorer
    extends Similarity.SimScorer {
        final Similarity.SimScorer delegate;
        final float boost;

        AssertingSimScorer(Similarity.SimScorer delegate, float boost) {
            this.delegate = delegate;
            this.boost = boost;
        }

        public float score(float freq, long norm) {
            assert (Float.isFinite(freq));
            assert (freq > 0.0f);
            float score = this.delegate.score(freq, norm);
            assert (Float.isFinite(score));
            assert (score <= this.delegate.score(freq, 1L));
            assert (score >= 0.0f);
            return score;
        }

        public Explanation explain(Explanation freq, long norm) {
            assert (freq != null);
            assert (Float.isFinite(freq.getValue().floatValue()));
            Explanation explanation = this.delegate.explain(freq, norm);
            assert (explanation != null);
            assert (Float.isFinite(explanation.getValue().floatValue()));
            assert (explanation.getValue().floatValue() == this.delegate.score(freq.getValue().floatValue(), norm));
            return explanation;
        }
    }
}

