/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.store.FilterIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.tests.store.MockDirectoryWrapper;

public class MockIndexInputWrapper
extends FilterIndexInput {
    private MockDirectoryWrapper dir;
    final String name;
    private volatile boolean closed;
    private final MockIndexInputWrapper parent;

    public MockIndexInputWrapper(MockDirectoryWrapper dir, String name, IndexInput delegate, MockIndexInputWrapper parent) {
        super("MockIndexInputWrapper(name=" + name + " delegate=" + delegate + ")", delegate);
        assert (parent == null || parent.parent == null);
        this.parent = parent;
        this.name = name;
        this.dir = dir;
    }

    public void close() throws IOException {
        if (this.closed) {
            this.in.close();
            return;
        }
        this.closed = true;
        try (IndexInput delegate = this.in;){
            assert (delegate != null);
            if (this.parent == null) {
                this.dir.removeIndexInput((IndexInput)this, this.name);
            }
            this.dir.maybeThrowDeterministicException();
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new RuntimeException("Abusing closed IndexInput!");
        }
        if (this.parent != null && this.parent.closed) {
            throw new RuntimeException("Abusing clone of a closed IndexInput!");
        }
    }

    public MockIndexInputWrapper clone() {
        this.ensureOpen();
        if (this.dir.verboseClone) {
            new Exception("clone: " + this).printStackTrace(System.out);
        }
        this.dir.inputCloneCount.incrementAndGet();
        IndexInput iiclone = this.in.clone();
        MockIndexInputWrapper clone = new MockIndexInputWrapper(this.dir, this.name, iiclone, this.parent != null ? this.parent : this);
        return clone;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        this.ensureOpen();
        if (this.dir.verboseClone) {
            new Exception("slice: " + this).printStackTrace(System.out);
        }
        this.dir.inputCloneCount.incrementAndGet();
        IndexInput slice = this.in.slice(sliceDescription, offset, length);
        MockIndexInputWrapper clone = new MockIndexInputWrapper(this.dir, sliceDescription, slice, this.parent != null ? this.parent : this);
        return clone;
    }

    public long getFilePointer() {
        this.ensureOpen();
        return this.in.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.ensureOpen();
        this.in.seek(pos);
    }

    public long length() {
        this.ensureOpen();
        return this.in.length();
    }

    public byte readByte() throws IOException {
        this.ensureOpen();
        return this.in.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.ensureOpen();
        this.in.readBytes(b, offset, len);
    }

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.ensureOpen();
        this.in.readBytes(b, offset, len, useBuffer);
    }

    public void readFloats(float[] floats, int offset, int len) throws IOException {
        this.ensureOpen();
        this.in.readFloats(floats, offset, len);
    }

    public short readShort() throws IOException {
        this.ensureOpen();
        return this.in.readShort();
    }

    public int readInt() throws IOException {
        this.ensureOpen();
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        this.ensureOpen();
        return this.in.readLong();
    }

    public String readString() throws IOException {
        this.ensureOpen();
        return this.in.readString();
    }

    public int readVInt() throws IOException {
        this.ensureOpen();
        return this.in.readVInt();
    }

    public long readVLong() throws IOException {
        this.ensureOpen();
        return this.in.readVLong();
    }

    public int readZInt() throws IOException {
        this.ensureOpen();
        return this.in.readZInt();
    }

    public long readZLong() throws IOException {
        this.ensureOpen();
        return this.in.readZLong();
    }

    public void skipBytes(long numBytes) throws IOException {
        this.ensureOpen();
        super.skipBytes(numBytes);
    }

    public Map<String, String> readMapOfStrings() throws IOException {
        this.ensureOpen();
        return this.in.readMapOfStrings();
    }

    public Set<String> readSetOfStrings() throws IOException {
        this.ensureOpen();
        return this.in.readSetOfStrings();
    }

    public String toString() {
        return "MockIndexInputWrapper(" + this.in + ")";
    }

    static {
        TestSecrets.getFilterInputIndexAccess().addTestFilterType(MockIndexInputWrapper.class);
    }
}

