/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.tests.mockfile.FilterFileSystemProvider;
import org.apache.lucene.tests.util.LuceneTestCase;

public class VirusCheckingFS
extends FilterFileSystemProvider {
    private volatile boolean enabled = true;
    private final AtomicLong state;

    public VirusCheckingFS(FileSystem delegate, long salt) {
        super("viruschecking://", delegate);
        this.state = new AtomicLong(salt);
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    @Override
    public void delete(Path path) throws IOException {
        long hash = this.state.incrementAndGet() * (long)path.getFileName().hashCode();
        if (this.enabled && Files.exists(path, new LinkOption[0]) && !path.getFileName().toString().equals("write.lock") && hash % 5L == 1L) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("NOTE: VirusCheckingFS now refusing to delete " + path);
            }
            throw new AccessDeniedException("VirusCheckingFS is randomly refusing to delete file \"" + path + "\"");
        }
        super.delete(path);
    }
}

