/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.tests.mockfile.HandleTrackingFS;

public class LeakFS
extends HandleTrackingFS {
    private final Map<Object, Exception> openHandles = new ConcurrentHashMap<Object, Exception>();

    public LeakFS(FileSystem delegate) {
        super("leakfs://", delegate);
    }

    @Override
    protected void onOpen(Path path, Object stream) {
        this.openHandles.put(stream, new Exception());
    }

    @Override
    protected void onClose(Path path, Object stream) {
        this.openHandles.remove(stream);
    }

    @Override
    public synchronized void onClose() {
        if (!this.openHandles.isEmpty()) {
            Exception cause = null;
            Iterator<Exception> stacktraces = this.openHandles.values().iterator();
            if (stacktraces.hasNext()) {
                cause = stacktraces.next();
            }
            throw new RuntimeException("file handle leaks: " + this.openHandles.keySet(), cause);
        }
    }
}

