/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.mocksep;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blockterms.BlockTermsReader;
import org.apache.lucene.codecs.blockterms.BlockTermsWriter;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexReader;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexWriter;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.codecs.mocksep.MockSingleIntFactory;
import org.apache.lucene.codecs.sep.IntStreamFactory;
import org.apache.lucene.codecs.sep.SepPostingsReader;
import org.apache.lucene.codecs.sep.SepPostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.BytesRef;

public final class MockSepPostingsFormat
extends PostingsFormat {
    public MockSepPostingsFormat() {
        super("MockSep");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FixedGapTermsIndexWriter indexWriter;
        SepPostingsWriter postingsWriter = new SepPostingsWriter(state, (IntStreamFactory)new MockSingleIntFactory());
        boolean success = false;
        try {
            indexWriter = new FixedGapTermsIndexWriter(state);
            success = true;
        }
        finally {
            if (!success) {
                postingsWriter.close();
            }
        }
        success = false;
        try {
            BlockTermsWriter ret = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)postingsWriter);
            success = true;
            BlockTermsWriter blockTermsWriter = ret;
            return blockTermsWriter;
        }
        finally {
            if (!success) {
                try {
                    postingsWriter.close();
                }
                finally {
                    indexWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FixedGapTermsIndexReader indexReader;
        SepPostingsReader postingsReader = new SepPostingsReader(state.directory, state.fieldInfos, state.segmentInfo, state.context, (IntStreamFactory)new MockSingleIntFactory(), state.segmentSuffix);
        boolean success = false;
        try {
            indexReader = new FixedGapTermsIndexReader(state.directory, state.fieldInfos, state.segmentInfo.name, state.termsIndexDivisor, BytesRef.getUTF8SortedAsUnicodeComparator(), state.segmentSuffix, state.context);
            success = true;
        }
        finally {
            if (!success) {
                postingsReader.close();
            }
        }
        success = false;
        try {
            BlockTermsReader ret = new BlockTermsReader((TermsIndexReaderBase)indexReader, state.directory, state.fieldInfos, state.segmentInfo, (PostingsReaderBase)postingsReader, state.context, 1024, state.segmentSuffix);
            success = true;
            BlockTermsReader blockTermsReader = ret;
            return blockTermsReader;
        }
        finally {
            if (!success) {
                try {
                    postingsReader.close();
                }
                finally {
                    indexReader.close();
                }
            }
        }
    }
}

