/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.codecs.FieldInfosReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

class PreFlexRWFieldInfosReader
extends FieldInfosReader {
    static final int FORMAT_MINIMUM = -2;

    PreFlexRWFieldInfosReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldInfos read(Directory directory, String segmentName, IOContext iocontext) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segmentName, (String)"", (String)"fnm");
        try (IndexInput input = directory.openInput(fileName, iocontext);){
            int format = input.readVInt();
            if (format > -2) {
                throw new IndexFormatTooOldException((DataInput)input, format, -2, -3);
            }
            if (format < -3 && format != Integer.MIN_VALUE) {
                throw new IndexFormatTooNewException((DataInput)input, format, -2, -3);
            }
            int size = input.readVInt();
            FieldInfo[] infos = new FieldInfo[size];
            for (int i = 0; i < size; ++i) {
                FieldInfo.DocValuesType normType;
                FieldInfo.IndexOptions indexOptions;
                boolean storePayloads;
                String name = input.readString();
                int fieldNumber = format == Integer.MIN_VALUE ? input.readInt() : i;
                byte bits = input.readByte();
                boolean isIndexed = (bits & 1) != 0;
                boolean storeTermVector = (bits & 2) != 0;
                boolean omitNorms = (bits & 0x10) != 0;
                boolean bl = storePayloads = (bits & 0x20) != 0;
                if (!isIndexed) {
                    indexOptions = null;
                } else if ((bits & 0x40) != 0) {
                    indexOptions = FieldInfo.IndexOptions.DOCS_ONLY;
                } else if ((bits & 0xFFFFFF80) != 0) {
                    if (format > -3) throw new CorruptIndexException("Corrupt fieldinfos, OMIT_POSITIONS set but format=" + format + " (resource: " + input + ")");
                    indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS;
                } else {
                    indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
                }
                if (indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                    storePayloads = false;
                }
                FieldInfo.DocValuesType docValuesType = normType = isIndexed && !omitNorms ? FieldInfo.DocValuesType.NUMERIC : null;
                if (format == Integer.MIN_VALUE && normType != null) {
                    normType = input.readByte() != 0 ? FieldInfo.DocValuesType.NUMERIC : null;
                }
                infos[i] = new FieldInfo(name, isIndexed, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, null, normType, null);
            }
            if (input.getFilePointer() != input.length()) {
                throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input.getFilePointer() + " vs size " + input.length() + " (resource: " + input + ")");
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
    }

    public static void files(Directory dir, SegmentInfo info, Set<String> files) throws IOException {
        files.add(IndexFileNames.segmentFileName((String)info.name, (String)"", (String)"fnm"));
    }
}

