/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.lucene3x.TermInfo;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.UnicodeUtil;

final class TermInfosWriter
implements Closeable {
    public static final int FORMAT = -3;
    public static final int FORMAT_VERSION_UTF8_LENGTH_IN_BYTES = -4;
    public static final int FORMAT_CURRENT = -4;
    private FieldInfos fieldInfos;
    private IndexOutput output;
    private TermInfo lastTi = new TermInfo();
    private long size;
    int indexInterval = 128;
    int skipInterval = 16;
    int maxSkipLevels = 10;
    private long lastIndexPointer;
    private boolean isIndex;
    private final BytesRef lastTerm = new BytesRef();
    private int lastFieldNumber = -1;
    private TermInfosWriter other;
    CharsRef utf16Result1;
    CharsRef utf16Result2;
    private final BytesRef scratchBytes = new BytesRef();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TermInfosWriter(Directory directory, String segment, FieldInfos fis, int interval) throws IOException {
        this.initialize(directory, segment, fis, interval, false);
        boolean success = false;
        try {
            this.other = new TermInfosWriter(directory, segment, fis, interval, true);
            this.other.other = this;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.output});
            try {
                directory.deleteFile(IndexFileNames.segmentFileName((String)segment, (String)"", (String)(this.isIndex ? "tii" : "tis")));
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private TermInfosWriter(Directory directory, String segment, FieldInfos fis, int interval, boolean isIndex) throws IOException {
        this.initialize(directory, segment, fis, interval, isIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize(Directory directory, String segment, FieldInfos fis, int interval, boolean isi) throws IOException {
        this.indexInterval = interval;
        this.fieldInfos = fis;
        this.isIndex = isi;
        this.output = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)(this.isIndex ? "tii" : "tis")), IOContext.DEFAULT);
        boolean success = false;
        try {
            this.output.writeInt(-4);
            this.output.writeLong(0L);
            this.output.writeInt(this.indexInterval);
            this.output.writeInt(this.skipInterval);
            this.output.writeInt(this.maxSkipLevels);
            assert (this.initUTF16Results());
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.output});
            try {
                directory.deleteFile(IndexFileNames.segmentFileName((String)segment, (String)"", (String)(this.isIndex ? "tii" : "tis")));
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.output});
        try {
            directory.deleteFile(IndexFileNames.segmentFileName((String)segment, (String)"", (String)(this.isIndex ? "tii" : "tis")));
            return;
        }
        catch (IOException iOException) {}
    }

    private boolean initUTF16Results() {
        this.utf16Result1 = new CharsRef(10);
        this.utf16Result2 = new CharsRef(10);
        return true;
    }

    static String fieldName(FieldInfos infos, int fieldNumber) {
        FieldInfo fi = infos.fieldInfo(fieldNumber);
        return fi != null ? fi.name : "";
    }

    private int compareToLastTerm(int fieldNumber, BytesRef term) {
        int cmp;
        if (this.lastFieldNumber != fieldNumber && ((cmp = TermInfosWriter.fieldName(this.fieldInfos, this.lastFieldNumber).compareTo(TermInfosWriter.fieldName(this.fieldInfos, fieldNumber))) != 0 || this.lastFieldNumber != -1)) {
            return cmp;
        }
        this.scratchBytes.copyBytes(term);
        assert (this.lastTerm.offset == 0);
        UnicodeUtil.UTF8toUTF16((byte[])this.lastTerm.bytes, (int)0, (int)this.lastTerm.length, (CharsRef)this.utf16Result1);
        assert (this.scratchBytes.offset == 0);
        UnicodeUtil.UTF8toUTF16((byte[])this.scratchBytes.bytes, (int)0, (int)this.scratchBytes.length, (CharsRef)this.utf16Result2);
        int len = this.utf16Result1.length < this.utf16Result2.length ? this.utf16Result1.length : this.utf16Result2.length;
        for (int i = 0; i < len; ++i) {
            char ch1 = this.utf16Result1.chars[i];
            char ch2 = this.utf16Result2.chars[i];
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        if (this.utf16Result1.length == 0 && this.lastFieldNumber == -1) {
            return -1;
        }
        return this.utf16Result1.length - this.utf16Result2.length;
    }

    public void add(int fieldNumber, BytesRef term, TermInfo ti) throws IOException {
        assert (this.compareToLastTerm(fieldNumber, term) < 0 || this.isIndex && term.length == 0 && this.lastTerm.length == 0) : "Terms are out of order: field=" + TermInfosWriter.fieldName(this.fieldInfos, fieldNumber) + " (number " + fieldNumber + ") lastField=" + TermInfosWriter.fieldName(this.fieldInfos, this.lastFieldNumber) + " (number " + this.lastFieldNumber + ") text=" + term.utf8ToString() + " lastText=" + this.lastTerm.utf8ToString();
        assert (ti.freqPointer >= this.lastTi.freqPointer) : "freqPointer out of order (" + ti.freqPointer + " < " + this.lastTi.freqPointer + ")";
        assert (ti.proxPointer >= this.lastTi.proxPointer) : "proxPointer out of order (" + ti.proxPointer + " < " + this.lastTi.proxPointer + ")";
        if (!this.isIndex && this.size % (long)this.indexInterval == 0L) {
            this.other.add(this.lastFieldNumber, this.lastTerm, this.lastTi);
        }
        this.writeTerm(fieldNumber, term);
        this.output.writeVInt(ti.docFreq);
        this.output.writeVLong(ti.freqPointer - this.lastTi.freqPointer);
        this.output.writeVLong(ti.proxPointer - this.lastTi.proxPointer);
        if (ti.docFreq >= this.skipInterval) {
            this.output.writeVInt(ti.skipOffset);
        }
        if (this.isIndex) {
            this.output.writeVLong(this.other.output.getFilePointer() - this.lastIndexPointer);
            this.lastIndexPointer = this.other.output.getFilePointer();
        }
        this.lastFieldNumber = fieldNumber;
        this.lastTi.set(ti);
        ++this.size;
    }

    private void writeTerm(int fieldNumber, BytesRef term) throws IOException {
        int start;
        int limit;
        int n = limit = term.length < this.lastTerm.length ? term.length : this.lastTerm.length;
        for (start = 0; start < limit && term.bytes[start + term.offset] == this.lastTerm.bytes[start + this.lastTerm.offset]; ++start) {
        }
        int length = term.length - start;
        this.output.writeVInt(start);
        this.output.writeVInt(length);
        this.output.writeBytes(term.bytes, start + term.offset, length);
        this.output.writeVInt(fieldNumber);
        this.lastTerm.copyBytes(term);
    }

    @Override
    public void close() throws IOException {
        try {
            this.output.seek(4L);
            this.output.writeLong(this.size);
        }
        finally {
            try {
                this.output.close();
            }
            finally {
                if (!this.isIndex) {
                    this.other.close();
                }
            }
        }
    }
}

