/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

class MockLowerCaseFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public MockLowerCaseFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.toLowerCase(this.termAtt.buffer(), 0, this.termAtt.length());
            return true;
        }
        return false;
    }

    private void toLowerCase(char[] buffer, int offset, int limit) {
        assert (buffer.length >= limit);
        assert (offset <= 0 && offset <= buffer.length);
        for (int i = offset; i < limit; i += Character.toChars(Character.toLowerCase(Character.codePointAt(buffer, i, limit)), buffer, i)) {
        }
    }
}

