/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MockDirectoryWrapper;

public class MockIndexInputWrapper
extends IndexInput {
    private MockDirectoryWrapper dir;
    final String name;
    private IndexInput delegate;
    private boolean isClone;
    private boolean closed;

    public MockIndexInputWrapper(MockDirectoryWrapper dir, String name, IndexInput delegate) {
        super("MockIndexInputWrapper(name=" + name + " delegate=" + delegate + ")");
        this.name = name;
        this.dir = dir;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block0: {
            this.closed = true;
            this.delegate.close();
            if (this.isClone) break block0;
            this.dir.removeIndexInput(this, this.name);
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new RuntimeException("Abusing closed IndexInput!");
        }
    }

    public MockIndexInputWrapper clone() {
        this.ensureOpen();
        this.dir.inputCloneCount.incrementAndGet();
        IndexInput iiclone = this.delegate.clone();
        MockIndexInputWrapper clone = new MockIndexInputWrapper(this.dir, this.name, iiclone);
        clone.isClone = true;
        return clone;
    }

    public long getFilePointer() {
        this.ensureOpen();
        return this.delegate.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.ensureOpen();
        this.delegate.seek(pos);
    }

    public long length() {
        this.ensureOpen();
        return this.delegate.length();
    }

    public byte readByte() throws IOException {
        this.ensureOpen();
        return this.delegate.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.ensureOpen();
        this.delegate.readBytes(b, offset, len);
    }

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.ensureOpen();
        this.delegate.readBytes(b, offset, len, useBuffer);
    }

    public short readShort() throws IOException {
        this.ensureOpen();
        return this.delegate.readShort();
    }

    public int readInt() throws IOException {
        this.ensureOpen();
        return this.delegate.readInt();
    }

    public long readLong() throws IOException {
        this.ensureOpen();
        return this.delegate.readLong();
    }

    public String readString() throws IOException {
        this.ensureOpen();
        return this.delegate.readString();
    }

    public Map<String, String> readStringStringMap() throws IOException {
        this.ensureOpen();
        return this.delegate.readStringStringMap();
    }

    public int readVInt() throws IOException {
        this.ensureOpen();
        return this.delegate.readVInt();
    }

    public long readVLong() throws IOException {
        this.ensureOpen();
        return this.delegate.readVLong();
    }

    public String toString() {
        return "MockIndexInputWrapper(" + this.delegate + ")";
    }
}

