/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class TestRuleReportUncaughtExceptions
implements TestRule {
    private Thread.UncaughtExceptionHandler savedUncaughtExceptionHandler;
    private final List<UncaughtExceptionEntry> uncaughtExceptions = new ArrayList<UncaughtExceptionEntry>();

    public Statement apply(final Statement s, Description d) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    TestRuleReportUncaughtExceptions.this.setupHandler();
                    s.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    TestRuleReportUncaughtExceptions.this.restoreHandler();
                }
                List list = TestRuleReportUncaughtExceptions.this.uncaughtExceptions;
                synchronized (list) {
                    for (UncaughtExceptionEntry e : TestRuleReportUncaughtExceptions.this.uncaughtExceptions) {
                        errors.add(new UncaughtExceptionsInBackgroundThread(e));
                    }
                    TestRuleReportUncaughtExceptions.this.uncaughtExceptions.clear();
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUncaughtExceptions() {
        List<UncaughtExceptionEntry> list = this.uncaughtExceptions;
        synchronized (list) {
            return !this.uncaughtExceptions.isEmpty();
        }
    }

    private void restoreHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.savedUncaughtExceptionHandler);
    }

    private void setupHandler() {
        this.savedUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e.getClass().getName().endsWith("AssumptionViolatedException")) {
                    String where = "<unknown>";
                    for (StackTraceElement elem : e.getStackTrace()) {
                        if (elem.getClassName().startsWith("org.junit")) continue;
                        where = elem.toString();
                        break;
                    }
                    System.err.print("NOTE: Uncaught exception handler caught a failed assumption at " + where + " (ignored):");
                } else {
                    List where = TestRuleReportUncaughtExceptions.this.uncaughtExceptions;
                    synchronized (where) {
                        TestRuleReportUncaughtExceptions.this.uncaughtExceptions.add(new UncaughtExceptionEntry(t, e));
                    }
                    StringWriter sw = new StringWriter();
                    sw.write("\n===>\nUncaught exception by thread: " + t + "\n");
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    sw.write("<===\n");
                    System.err.println(sw.toString());
                }
            }
        });
    }

    private static class UncaughtExceptionsInBackgroundThread
    extends RuntimeException {
        public UncaughtExceptionsInBackgroundThread(UncaughtExceptionEntry e) {
            super("Uncaught exception by thread: " + e.thread, e.exception);
        }
    }

    public static class UncaughtExceptionEntry {
        public final Thread thread;
        public final Throwable exception;

        public UncaughtExceptionEntry(Thread thread, Throwable exception) {
            this.thread = thread;
            this.exception = exception;
        }
    }
}

