/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.ClassValidator;
import com.carrotsearch.randomizedtesting.MethodCollector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestRuleNoInstanceHooksOverrides
implements TestRule,
ClassValidator {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestRuleNoInstanceHooksOverrides.this.validate(description.getTestClass());
                base.evaluate();
            }
        };
    }

    public void validate(Class<?> clazz) throws Throwable {
        List all = MethodCollector.allDeclaredMethods(clazz);
        this.checkNoShadows(clazz, all, Before.class);
        this.checkNoShadows(clazz, all, After.class);
    }

    private void checkNoShadows(Class<?> clazz, List<List<Method>> all, Class<? extends Annotation> ann) {
        List<List<Method>> methodHierarchy = this.filterIgnored(MethodCollector.annotatedWith(all, ann));
        List noOverrides = MethodCollector.removeOverrides(methodHierarchy);
        if (!((Object)noOverrides).equals(methodHierarchy)) {
            HashSet shadowed = new HashSet(MethodCollector.flatten(methodHierarchy));
            shadowed.removeAll(MethodCollector.flatten((List)noOverrides));
            StringBuilder b = new StringBuilder();
            for (Method m : shadowed) {
                String sig = this.signature(m);
                for (Method other : MethodCollector.flatten(methodHierarchy)) {
                    if (other == m || !sig.equals(this.signature(other))) continue;
                    b.append("Method: " + m.toString() + "#" + sig + " possibly overriden by " + other.toString() + "#" + this.signature(other) + "\n");
                }
            }
            throw new RuntimeException("There are overridden methods annotated with " + ann.getName() + ". These methods would not be executed by JUnit and need to manually chain themselves which can lead to" + " maintenance problems. Consider using different method names or make hook methods private.\n" + b.toString().trim());
        }
    }

    private List<List<Method>> filterIgnored(List<List<Method>> methods) {
        HashSet<String> ignored = new HashSet<String>(Arrays.asList("setUp", "tearDown"));
        ArrayList<List<Method>> copy = new ArrayList<List<Method>>();
        for (List<Method> m : methods) {
            if (ignored.contains(m.get(0).getName())) continue;
            copy.add(m);
        }
        return copy;
    }

    private String signature(Method m) {
        return m.getName() + Arrays.toString(m.getParameterTypes());
    }
}

