/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.mocksep;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public class MockSingleIntIndexInput
extends IntIndexInput {
    private final IndexInput in;

    public MockSingleIntIndexInput(Directory dir, String fileName, IOContext context) throws IOException {
        this.in = dir.openInput(fileName, context);
        CodecUtil.checkHeader((DataInput)this.in, (String)"SINGLE_INTS", (int)0, (int)0);
    }

    public Reader reader() throws IOException {
        return new Reader((IndexInput)this.in.clone());
    }

    public void close() throws IOException {
        this.in.close();
    }

    public IntIndexInput.Index index() {
        return new MockSingleIntIndexInputIndex();
    }

    class MockSingleIntIndexInputIndex
    extends IntIndexInput.Index {
        private long fp;

        MockSingleIntIndexInputIndex() {
        }

        public void read(DataInput indexIn, boolean absolute) throws IOException {
            this.fp = absolute ? indexIn.readVLong() : (this.fp += indexIn.readVLong());
        }

        public void set(IntIndexInput.Index other) {
            this.fp = ((MockSingleIntIndexInputIndex)other).fp;
        }

        public void seek(IntIndexInput.Reader other) throws IOException {
            ((Reader)other).in.seek(this.fp);
        }

        public String toString() {
            return Long.toString(this.fp);
        }

        public IntIndexInput.Index clone() {
            MockSingleIntIndexInputIndex other = new MockSingleIntIndexInputIndex();
            other.fp = this.fp;
            return other;
        }
    }

    public static class Reader
    extends IntIndexInput.Reader {
        private final IndexInput in;

        public Reader(IndexInput in) {
            this.in = in;
        }

        public int next() throws IOException {
            return this.in.readVInt();
        }
    }
}

