/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.mockintblock;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.BlockTermsReader;
import org.apache.lucene.codecs.BlockTermsWriter;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.FixedGapTermsIndexReader;
import org.apache.lucene.codecs.FixedGapTermsIndexWriter;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermsIndexReaderBase;
import org.apache.lucene.codecs.TermsIndexWriterBase;
import org.apache.lucene.codecs.intblock.FixedIntBlockIndexInput;
import org.apache.lucene.codecs.intblock.FixedIntBlockIndexOutput;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.codecs.sep.IntStreamFactory;
import org.apache.lucene.codecs.sep.SepPostingsReader;
import org.apache.lucene.codecs.sep.SepPostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class MockFixedIntBlockPostingsFormat
extends PostingsFormat {
    private final int blockSize;

    public MockFixedIntBlockPostingsFormat() {
        this(1);
    }

    public MockFixedIntBlockPostingsFormat(int blockSize) {
        super("MockFixedIntBlock");
        this.blockSize = blockSize;
    }

    public String toString() {
        return this.getName() + "(blockSize=" + this.blockSize + ")";
    }

    public IntStreamFactory getIntFactory() {
        return new MockIntFactory(this.blockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FixedGapTermsIndexWriter indexWriter;
        SepPostingsWriter postingsWriter = new SepPostingsWriter(state, (IntStreamFactory)new MockIntFactory(this.blockSize));
        boolean success = false;
        try {
            indexWriter = new FixedGapTermsIndexWriter(state);
            success = true;
        }
        finally {
            if (!success) {
                postingsWriter.close();
            }
        }
        success = false;
        try {
            BlockTermsWriter ret = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)postingsWriter);
            success = true;
            BlockTermsWriter blockTermsWriter = ret;
            return blockTermsWriter;
        }
        finally {
            if (!success) {
                try {
                    postingsWriter.close();
                }
                finally {
                    indexWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FixedGapTermsIndexReader indexReader;
        SepPostingsReader postingsReader = new SepPostingsReader(state.dir, state.fieldInfos, state.segmentInfo, state.context, (IntStreamFactory)new MockIntFactory(this.blockSize), state.segmentSuffix);
        boolean success = false;
        try {
            indexReader = new FixedGapTermsIndexReader(state.dir, state.fieldInfos, state.segmentInfo.name, state.termsIndexDivisor, BytesRef.getUTF8SortedAsUnicodeComparator(), state.segmentSuffix, IOContext.DEFAULT);
            success = true;
        }
        finally {
            if (!success) {
                postingsReader.close();
            }
        }
        success = false;
        try {
            BlockTermsReader ret = new BlockTermsReader((TermsIndexReaderBase)indexReader, state.dir, state.fieldInfos, state.segmentInfo.name, (PostingsReaderBase)postingsReader, state.context, 1024, state.segmentSuffix);
            success = true;
            BlockTermsReader blockTermsReader = ret;
            return blockTermsReader;
        }
        finally {
            if (!success) {
                try {
                    postingsReader.close();
                }
                finally {
                    indexReader.close();
                }
            }
        }
    }

    public static class MockIntFactory
    extends IntStreamFactory {
        private final int blockSize;

        public MockIntFactory(int blockSize) {
            this.blockSize = blockSize;
        }

        public IntIndexInput openInput(Directory dir, String fileName, IOContext context) throws IOException {
            return new FixedIntBlockIndexInput(dir.openInput(fileName, context)){

                protected FixedIntBlockIndexInput.BlockReader getBlockReader(final IndexInput in, final int[] buffer) throws IOException {
                    return new FixedIntBlockIndexInput.BlockReader(){

                        public void seek(long pos) {
                        }

                        public void readBlock() throws IOException {
                            for (int i = 0; i < buffer.length; ++i) {
                                buffer[i] = in.readVInt();
                            }
                        }
                    };
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IntIndexOutput createOutput(Directory dir, String fileName, IOContext context) throws IOException {
            FixedIntBlockIndexOutput fixedIntBlockIndexOutput;
            block3: {
                IndexOutput out = dir.createOutput(fileName, context);
                boolean success = false;
                try {
                    FixedIntBlockIndexOutput ret = new FixedIntBlockIndexOutput(out, this.blockSize){

                        protected void flushBlock() throws IOException {
                            for (int i = 0; i < this.buffer.length; ++i) {
                                this.out.writeVInt(this.buffer[i]);
                            }
                        }
                    };
                    success = true;
                    fixedIntBlockIndexOutput = ret;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
            }
            return fixedIntBlockIndexOutput;
        }
    }
}

