/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

public final class BlockScoreQueryWrapper
extends Query {
    private final Query query;
    private final int blockLength;

    public BlockScoreQueryWrapper(Query query, int blockLength) {
        this.query = Objects.requireNonNull(query);
        this.blockLength = blockLength;
    }

    public String toString(String field) {
        return this.query.toString(field);
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BlockScoreQueryWrapper that = (BlockScoreQueryWrapper)((Object)obj);
        return Objects.equals(this.query, that.query) && this.blockLength == that.blockLength;
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.query.hashCode();
        h = 31 * h + this.blockLength;
        return h;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (rewritten != this.query) {
            return new BlockScoreQueryWrapper(rewritten, this.blockLength);
        }
        return super.rewrite(indexSearcher);
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight inWeight = this.query.createWeight(searcher, scoreMode, boost);
        if (!scoreMode.needsScores()) {
            return inWeight;
        }
        return new Weight(this, this){
            final /* synthetic */ BlockScoreQueryWrapper this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return inWeight.isCacheable(ctx);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Scorer inScorer = inWeight.scorer(context);
                if (inScorer == null) {
                    return null;
                }
                int[] tmpDocs = new int[2];
                float[] tmpScores = new float[2];
                tmpDocs[0] = -1;
                DocIdSetIterator it = inScorer.iterator();
                int i = 1;
                int doc = it.nextDoc();
                while (true) {
                    tmpDocs = ArrayUtil.grow((int[])tmpDocs, (int)(i + 1));
                    tmpScores = ArrayUtil.grow((float[])tmpScores, (int)(i + 1));
                    tmpDocs[i] = doc;
                    if (doc == Integer.MAX_VALUE) break;
                    tmpScores[i] = inScorer.score();
                    ++i;
                    doc = it.nextDoc();
                }
                final int[] docs = ArrayUtil.copyOfSubArray((int[])tmpDocs, (int)0, (int)(++i));
                final float[] scores = ArrayUtil.copyOfSubArray((float[])tmpScores, (int)0, (int)i);
                Scorer scorer = new Scorer(this){
                    int i = 0;
                    int lastShallowTarget = -1;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int docID() {
                        return docs[this.i];
                    }

                    public float score() throws IOException {
                        return scores[this.i];
                    }

                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public int nextDoc() throws IOException {
                                assert (docs[this.this$2.i] != Integer.MAX_VALUE);
                                return docs[++this.this$2.i];
                            }

                            public int docID() {
                                return docs[this.this$2.i];
                            }

                            public long cost() {
                                return docs.length - 2;
                            }

                            public int advance(int target) throws IOException {
                                this.this$2.i = Arrays.binarySearch(docs, target);
                                if (this.this$2.i < 0) {
                                    this.this$2.i = -1 - this.this$2.i;
                                }
                                assert (docs[this.this$2.i] >= target);
                                return docs[this.this$2.i];
                            }
                        };
                    }

                    private int startOfBlock(int target) {
                        int i = Arrays.binarySearch(docs, target);
                        if (i < 0) {
                            i = -1 - i;
                        }
                        return i - i % this.this$1.this$0.blockLength;
                    }

                    private int endOfBlock(int target) {
                        return Math.min(this.startOfBlock(target) + this.this$1.this$0.blockLength, docs.length - 1);
                    }

                    public int advanceShallow(int target) throws IOException {
                        this.lastShallowTarget = target;
                        if (target == Integer.MAX_VALUE) {
                            return Integer.MAX_VALUE;
                        }
                        return docs[this.endOfBlock(target)] - 1;
                    }

                    public float getMaxScore(int upTo) throws IOException {
                        float max = 0.0f;
                        int j = this.startOfBlock(Math.max(docs[this.i], this.lastShallowTarget));
                        while (docs[j] <= upTo) {
                            max = Math.max(max, scores[j]);
                            if (j == docs.length - 1) break;
                            ++j;
                        }
                        return max;
                    }
                };
                return new Weight.DefaultScorerSupplier(scorer);
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return inWeight.explain(context, doc);
            }
        };
    }
}

