/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterDocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.FixedBitSet;

public class AssertingScorer
extends Scorer {
    final Random random;
    final Scorer in;
    final ScoreMode scoreMode;
    final boolean canCallMinCompetitiveScore;
    IteratorState state = IteratorState.ITERATING;
    int doc;
    float minCompetitiveScore = 0.0f;
    int lastShallowTarget = -1;

    public static Scorer wrap(Random random, Scorer other, ScoreMode scoreMode, boolean canCallMinCompetitiveScore) {
        if (other == null) {
            return null;
        }
        return new AssertingScorer(random, other, scoreMode, canCallMinCompetitiveScore);
    }

    private AssertingScorer(Random random, Scorer in, ScoreMode scoreMode, boolean canCallMinCompetitiveScore) {
        this.random = random;
        this.in = in;
        this.scoreMode = scoreMode;
        this.doc = in.docID();
        this.canCallMinCompetitiveScore = canCallMinCompetitiveScore;
    }

    public Scorer getIn() {
        return this.in;
    }

    boolean iterating() {
        switch (this.docID()) {
            case -1: 
            case 0x7FFFFFFF: {
                return false;
            }
        }
        return this.state == IteratorState.ITERATING;
    }

    public void setMinCompetitiveScore(float score) throws IOException {
        assert (this.scoreMode == ScoreMode.TOP_SCORES);
        assert (this.canCallMinCompetitiveScore);
        assert (!Float.isNaN(score));
        assert (score >= this.minCompetitiveScore);
        this.in.setMinCompetitiveScore(score);
        this.minCompetitiveScore = score;
    }

    public int advanceShallow(int target) throws IOException {
        assert (this.scoreMode.needsScores());
        assert (target >= this.lastShallowTarget) : "called on decreasing targets: target = " + target + " < last target = " + this.lastShallowTarget;
        assert (target >= this.docID()) : "target = " + target + " < docID = " + this.docID();
        int upTo = this.in.advanceShallow(target);
        assert (upTo >= target) : "upTo = " + upTo + " < target = " + target;
        this.lastShallowTarget = target;
        this.state = target != this.doc ? IteratorState.SHALLOW_ADVANCING : this.state;
        return upTo;
    }

    public float getMaxScore(int upTo) throws IOException {
        assert (this.scoreMode.needsScores());
        assert (upTo >= this.lastShallowTarget) : "uTo = " + upTo + " < last target = " + this.lastShallowTarget;
        assert (this.docID() >= 0 || this.lastShallowTarget >= 0) : "Cannot get max scores until the iterator is positioned or advanceShallow has been called";
        float maxScore = this.in.getMaxScore(upTo);
        return maxScore;
    }

    public float score() throws IOException {
        assert (this.scoreMode.needsScores());
        assert (this.iterating()) : this.state;
        float score = this.in.score();
        assert (!Float.isNaN(score)) : "NaN score for in=" + String.valueOf(this.in);
        assert (this.lastShallowTarget == -1 || score <= this.getMaxScore(this.docID()));
        assert (Float.compare(score, 0.0f) >= 0) : score;
        return score;
    }

    public Collection<Scorable.ChildScorable> getChildren() {
        return Collections.singletonList(new Scorable.ChildScorable((Scorable)this.in, "SHOULD"));
    }

    public int docID() {
        return this.in.docID();
    }

    public String toString() {
        return "AssertingScorer(" + String.valueOf(this.in) + ")";
    }

    public DocIdSetIterator iterator() {
        DocIdSetIterator in = this.in.iterator();
        assert (in != null);
        return new FilterDocIdSetIterator(in){

            public int docID() {
                assert (AssertingScorer.this.in.docID() == this.in.docID());
                return this.in.docID();
            }

            public int nextDoc() throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
                assert (this.docID() + 1 >= AssertingScorer.this.lastShallowTarget);
                int nextDoc = this.in.nextDoc();
                assert (nextDoc > AssertingScorer.this.doc) : "backwards nextDoc from " + AssertingScorer.this.doc + " to " + nextDoc + " " + String.valueOf(this.in);
                AssertingScorer.this.state = nextDoc == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
                assert (this.in.docID() == nextDoc);
                assert (AssertingScorer.this.in.docID() == this.in.docID());
                AssertingScorer.this.doc = nextDoc;
                return AssertingScorer.this.doc;
            }

            public int advance(int target) throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (target > AssertingScorer.this.doc) : "target must be > docID(), got " + target + " <= " + AssertingScorer.this.doc;
                assert (target >= AssertingScorer.this.lastShallowTarget);
                int advanced = this.in.advance(target);
                assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
                AssertingScorer.this.state = advanced == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
                assert (this.in.docID() == advanced) : this.in.docID() + " != " + advanced + " in " + String.valueOf(this.in);
                assert (AssertingScorer.this.in.docID() == this.in.docID());
                AssertingScorer.this.doc = advanced;
                return AssertingScorer.this.doc;
            }

            public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                assert (this.docID() != -1);
                assert (offset <= this.docID());
                this.in.intoBitSet(upTo, bitSet, offset);
                assert (this.docID() >= upTo);
            }

            public int docIDRunEnd() throws IOException {
                assert (AssertingScorer.this.state == IteratorState.ITERATING);
                int nextNonMatchingDocID = this.in.docIDRunEnd();
                assert (nextNonMatchingDocID > this.docID());
                return nextNonMatchingDocID;
            }
        };
    }

    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.in.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        assert (inApproximation.docID() == this.doc);
        FilterDocIdSetIterator assertingApproximation = new FilterDocIdSetIterator(this, inApproximation){
            final /* synthetic */ AssertingScorer this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public int nextDoc() throws IOException {
                assert (this.this$0.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (this.docID() + 1 >= this.this$0.lastShallowTarget);
                int nextDoc = inApproximation.nextDoc();
                assert (nextDoc > this.this$0.doc) : "backwards advance from: " + this.this$0.doc + " to: " + nextDoc;
                this.this$0.state = nextDoc == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.APPROXIMATING;
                assert (inApproximation.docID() == nextDoc);
                this.this$0.doc = nextDoc;
                return this.this$0.doc;
            }

            public int advance(int target) throws IOException {
                assert (this.this$0.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (target > this.this$0.doc) : "target must be > docID(), got " + target + " <= " + this.this$0.doc;
                assert (target >= this.this$0.lastShallowTarget);
                int advanced = inApproximation.advance(target);
                assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
                this.this$0.state = advanced == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.APPROXIMATING;
                assert (inApproximation.docID() == advanced);
                this.this$0.doc = advanced;
                return this.this$0.doc;
            }
        };
        return new TwoPhaseIterator(this, (DocIdSetIterator)assertingApproximation){
            final /* synthetic */ AssertingScorer this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public boolean matches() throws IOException {
                assert (this.this$0.state == IteratorState.APPROXIMATING) : this.this$0.state;
                boolean matches = in.matches();
                if (matches) {
                    assert (this.this$0.in.iterator().docID() == inApproximation.docID()) : "Approximation and scorer don't advance synchronously";
                    this.this$0.doc = inApproximation.docID();
                    this.this$0.state = IteratorState.ITERATING;
                }
                return matches;
            }

            public float matchCost() {
                float matchCost = in.matchCost();
                assert (!Float.isNaN(matchCost));
                assert (matchCost >= 0.0f);
                return matchCost;
            }

            public String toString() {
                return "AssertingScorer@asTwoPhaseIterator(" + String.valueOf(in) + ")";
            }
        };
    }

    static enum IteratorState {
        APPROXIMATING,
        ITERATING,
        SHALLOW_ADVANCING,
        FINISHED;

    }
}

