/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.tests.mockfile.FilterPath;
import org.apache.lucene.tests.mockfile.HandleTrackingFS;
import org.apache.lucene.tests.mockfile.WindowsPath;

public class WindowsFS
extends HandleTrackingFS {
    final Map<Object, Map<Path, Integer>> openFiles = new HashMap<Object, Map<Path, Integer>>();

    public WindowsFS(FileSystem delegate) {
        super("windows://", delegate);
    }

    private Object getKey(Path existing) throws IOException {
        return Optional.ofNullable(Files.readAttributes(existing, BasicFileAttributes.class, new LinkOption[0]).fileKey()).orElse(existing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onOpen(Path path2, Object stream) throws IOException {
        Map<Object, Map<Path, Integer>> map = this.openFiles;
        synchronized (map) {
            Object key = this.getKey(path2);
            Map pathMap = this.openFiles.computeIfAbsent(key, object -> new HashMap());
            pathMap.put(path2, pathMap.computeIfAbsent(path2, path -> 0) + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose(Path path, Object stream) throws IOException {
        Object key = this.getKey(path);
        Map<Object, Map<Path, Integer>> map = this.openFiles;
        synchronized (map) {
            Map<Path, Integer> pathMap = this.openFiles.get(key);
            assert (pathMap != null);
            assert (pathMap.containsKey(path));
            Integer v = pathMap.get(path);
            if (v != null) {
                if (v == 1) {
                    pathMap.remove(path);
                } else {
                    v = v - 1;
                    pathMap.put(path, v);
                }
            }
            if (pathMap.isEmpty()) {
                this.openFiles.remove(key);
            }
        }
    }

    private Object getKeyOrNull(Path path) {
        try {
            return this.getKey(path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDeleteAccess(Path path) throws IOException {
        Object key = this.getKeyOrNull(path);
        if (key != null) {
            Map<Object, Map<Path, Integer>> map = this.openFiles;
            synchronized (map) {
                if (this.openFiles.containsKey(key)) {
                    throw new IOException("access denied: " + String.valueOf(path));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Path path) throws IOException {
        Map<Object, Map<Path, Integer>> map = this.openFiles;
        synchronized (map) {
            this.checkDeleteAccess(path);
            super.delete(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        Map<Object, Map<Path, Integer>> map = this.openFiles;
        synchronized (map) {
            Map<Path, Integer> map2;
            Object newKey;
            this.checkDeleteAccess(source);
            Object key = this.getKeyOrNull(target);
            super.move(source, target, options);
            if (key != null && !(newKey = this.getKey(target)).equals(key) && (map2 = this.openFiles.get(key)) != null) {
                Integer v = map2.remove(target);
                if (v != null) {
                    Map pathIntegerMap = this.openFiles.computeIfAbsent(newKey, object -> new HashMap());
                    Integer existingValue = pathIntegerMap.getOrDefault(target, 0);
                    pathIntegerMap.put(target, existingValue + v);
                }
                if (map2.isEmpty()) {
                    this.openFiles.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        Map<Object, Map<Path, Integer>> map = this.openFiles;
        synchronized (map) {
            this.checkDeleteAccess(path);
            return super.deleteIfExists(path);
        }
    }

    @Override
    public FilterPath wrapPath(Path path) {
        return new WindowsPath(path, this.fileSystem);
    }
}

