/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Random;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;

public class MismatchedLeafReader
extends FilterLeafReader {
    final FieldInfos shuffled;

    public MismatchedLeafReader(LeafReader in, Random random) {
        super(in);
        this.shuffled = MismatchedLeafReader.shuffleInfos(in.getFieldInfos(), random);
    }

    public FieldInfos getFieldInfos() {
        return this.shuffled;
    }

    public StoredFields storedFields() throws IOException {
        final StoredFields inStoredFields = this.in.storedFields();
        return new StoredFields(this){
            final /* synthetic */ MismatchedLeafReader this$0;
            {
                this.this$0 = this$0;
            }

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                inStoredFields.document(docID, (StoredFieldVisitor)new MismatchedVisitor(visitor, this.this$0.shuffled));
            }
        };
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    static FieldInfos shuffleInfos(FieldInfos infos, Random random) {
        ArrayList<FieldInfo> shuffled = new ArrayList<FieldInfo>();
        for (FieldInfo info : infos) {
            shuffled.add(info);
        }
        Collections.shuffle(shuffled, random);
        for (int i = 0; i < shuffled.size(); ++i) {
            FieldInfo oldInfo = (FieldInfo)shuffled.get(i);
            FieldInfo newInfo = new FieldInfo(oldInfo.name, i, oldInfo.hasTermVectors(), oldInfo.omitsNorms(), oldInfo.hasPayloads(), oldInfo.getIndexOptions(), oldInfo.getDocValuesType(), oldInfo.docValuesSkipIndexType(), oldInfo.getDocValuesGen(), oldInfo.attributes(), oldInfo.getPointDimensionCount(), oldInfo.getPointIndexDimensionCount(), oldInfo.getPointNumBytes(), oldInfo.getVectorDimension(), oldInfo.getVectorEncoding(), oldInfo.getVectorSimilarityFunction(), oldInfo.isSoftDeletesField(), oldInfo.isParentField());
            shuffled.set(i, newInfo);
        }
        return new FieldInfos(shuffled.toArray(new FieldInfo[shuffled.size()]));
    }

    static class MismatchedVisitor
    extends StoredFieldVisitor {
        final StoredFieldVisitor in;
        final FieldInfos shuffled;

        MismatchedVisitor(StoredFieldVisitor in, FieldInfos shuffled) {
            this.in = in;
            this.shuffled = shuffled;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.in.binaryField(this.renumber(fieldInfo), value);
        }

        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            this.in.stringField(this.renumber(fieldInfo), Objects.requireNonNull(value, "String value should not be null"));
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.in.intField(this.renumber(fieldInfo), value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.in.longField(this.renumber(fieldInfo), value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.in.floatField(this.renumber(fieldInfo), value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.in.doubleField(this.renumber(fieldInfo), value);
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.in.needsField(this.renumber(fieldInfo));
        }

        FieldInfo renumber(FieldInfo original) {
            FieldInfo renumbered = this.shuffled.fieldInfo(original.name);
            if (renumbered == null) {
                throw new AssertionError((Object)"stored fields sending bogus infos!");
            }
            return renumbered;
        }
    }
}

