/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.FilterIterator;

public final class FieldFilterLeafReader
extends FilterLeafReader {
    private final Set<String> fields;
    private final boolean negate;
    private final FieldInfos fieldInfos;

    public FieldFilterLeafReader(LeafReader in, Set<String> fields, boolean negate) {
        super(in);
        this.fields = fields;
        this.negate = negate;
        ArrayList<FieldInfo> filteredInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fi : in.getFieldInfos()) {
            if (!this.hasField(fi.name)) continue;
            filteredInfos.add(fi);
        }
        this.fieldInfos = new FieldInfos(filteredInfos.toArray(new FieldInfo[filteredInfos.size()]));
    }

    boolean hasField(String field) {
        return this.negate ^ this.fields.contains(field);
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public TermVectors termVectors() throws IOException {
        final TermVectors orig = super.termVectors();
        return new TermVectors(this){
            final /* synthetic */ FieldFilterLeafReader this$0;
            {
                this.this$0 = this$0;
            }

            public Fields get(int docID) throws IOException {
                Object f = orig.get(docID);
                if (f == null) {
                    return null;
                }
                return (f = this.this$0.new FieldFilterFields((Fields)f)).iterator().hasNext() ? f : null;
            }
        };
    }

    public StoredFields storedFields() throws IOException {
        final StoredFields orig = super.storedFields();
        return new StoredFields(this){
            final /* synthetic */ FieldFilterLeafReader this$0;
            {
                this.this$0 = this$0;
            }

            public void document(int docID, final StoredFieldVisitor visitor) throws IOException {
                orig.document(docID, new StoredFieldVisitor(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                        visitor.binaryField(fieldInfo, value);
                    }

                    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
                        visitor.stringField(fieldInfo, Objects.requireNonNull(value, "String value should not be null"));
                    }

                    public void intField(FieldInfo fieldInfo, int value) throws IOException {
                        visitor.intField(fieldInfo, value);
                    }

                    public void longField(FieldInfo fieldInfo, long value) throws IOException {
                        visitor.longField(fieldInfo, value);
                    }

                    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                        visitor.floatField(fieldInfo, value);
                    }

                    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                        visitor.doubleField(fieldInfo, value);
                    }

                    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                        return this.this$1.this$0.hasField(fieldInfo.name) ? visitor.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
                    }
                });
            }
        };
    }

    public Terms terms(String field) throws IOException {
        return this.hasField(field) ? super.terms(field) : null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getBinaryDocValues(field) : null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedDocValues(field) : null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedNumericDocValues(field) : null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedSetDocValues(field) : null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return this.hasField(field) ? super.getNormValues(field) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FieldFilterLeafReader(reader=");
        sb.append(this.in).append(", fields=");
        if (this.negate) {
            sb.append('!');
        }
        return sb.append(this.fields).append(')').toString();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private class FieldFilterFields
    extends FilterLeafReader.FilterFields {
        public FieldFilterFields(Fields in) {
            super(in);
        }

        public int size() {
            return -1;
        }

        public Iterator<String> iterator() {
            return new FilterIterator<String, String>(super.iterator()){

                protected boolean predicateFunction(String field) {
                    return FieldFilterLeafReader.this.hasField(field);
                }
            };
        }

        public Terms terms(String field) throws IOException {
            return FieldFilterLeafReader.this.hasField(field) ? super.terms(field) : null;
        }
    }
}

