/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.tests.mockfile.FilterDirectoryStream;
import org.apache.lucene.tests.mockfile.FilterFileSystem;
import org.apache.lucene.tests.mockfile.FilterPath;

public abstract class FilterFileSystemProvider
extends FileSystemProvider {
    protected final FileSystemProvider delegate;
    protected FilterFileSystem fileSystem;
    protected final String scheme;

    public FilterFileSystemProvider(String scheme, FileSystem delegateInstance) {
        this.scheme = Objects.requireNonNull(scheme);
        Objects.requireNonNull(delegateInstance);
        this.delegate = delegateInstance.provider();
        this.fileSystem = new FilterFileSystem(this, delegateInstance);
    }

    public FilterFileSystemProvider(String scheme, FileSystemProvider delegate) {
        this.scheme = Objects.requireNonNull(scheme);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        if (this.fileSystem == null) {
            throw new IllegalStateException("subclass did not initialize singleton filesystem");
        }
        return this.fileSystem;
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        if (this.fileSystem == null) {
            throw new IllegalStateException("subclass did not initialize singleton filesystem");
        }
        return this.fileSystem;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        if (this.fileSystem == null) {
            throw new IllegalStateException("subclass did not initialize singleton filesystem");
        }
        return this.fileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        if (this.fileSystem == null) {
            throw new IllegalStateException("subclass did not initialize singleton filesystem");
        }
        return this.wrapPath(this.delegate.getPath(uri));
    }

    public FilterPath wrapPath(Path path) {
        return new FilterPath(path, this.fileSystem);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.delegate.createDirectory(this.toDelegate(dir), attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.delegate.delete(this.toDelegate(path));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegate.copy(this.toDelegate(source), this.toDelegate(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.delegate.move(this.toDelegate(source), this.toDelegate(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.delegate.isSameFile(this.toDelegate(path), this.toDelegate(path2));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.delegate.isHidden(this.toDelegate(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.delegate.getFileStore(this.toDelegate(path));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.delegate.checkAccess(this.toDelegate(path), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.delegate.getFileAttributeView(this.toDelegate(path), type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.delegate.readAttributes(this.toDelegate(path), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.delegate.readAttributes(this.toDelegate(path), attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.delegate.setAttribute(this.toDelegate(path), attribute, value, options);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return this.delegate.newInputStream(this.toDelegate(path), options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return this.delegate.newOutputStream(this.toDelegate(path), options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.delegate.newFileChannel(this.toDelegate(path), options, attrs);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        return this.delegate.newAsynchronousFileChannel(this.toDelegate(path), options, executor, attrs);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.delegate.newByteChannel(this.toDelegate(path), options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, final DirectoryStream.Filter<? super Path> filter) throws IOException {
        DirectoryStream.Filter<Path> wrappedFilter = new DirectoryStream.Filter<Path>(){
            final /* synthetic */ FilterFileSystemProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean accept(Path entry) throws IOException {
                return filter.accept(this.this$0.wrapPath(entry));
            }
        };
        return new FilterDirectoryStream(this.delegate.newDirectoryStream(this.toDelegate(dir), (DirectoryStream.Filter<? super Path>)wrappedFilter), this.fileSystem);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.delegate.createSymbolicLink(this.toDelegate(link), this.toDelegate(target), attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        this.delegate.createLink(this.toDelegate(link), this.toDelegate(existing));
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return this.delegate.deleteIfExists(this.toDelegate(path));
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return this.delegate.readSymbolicLink(this.toDelegate(link));
    }

    protected Path toDelegate(Path path) {
        if (path instanceof FilterPath) {
            FilterPath fp = (FilterPath)path;
            if (fp.fileSystem != this.fileSystem) {
                throw new ProviderMismatchException("mismatch, expected: " + String.valueOf(this.fileSystem.provider().getClass()) + ", got: " + String.valueOf(fp.fileSystem.provider().getClass()));
            }
            return fp.delegate;
        }
        throw new ProviderMismatchException("mismatch, expected: FilterPath, got: " + String.valueOf(path.getClass()));
    }

    protected void onClose() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.delegate) + ")";
    }
}

