/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.FixedBitSet;

public class AssertingScorer
extends Scorer {
    final Random random;
    final Scorer in;
    final ScoreMode scoreMode;
    final boolean canCallMinCompetitiveScore;
    IteratorState state = IteratorState.ITERATING;
    int doc;
    float minCompetitiveScore = 0.0f;
    int lastShallowTarget = -1;

    public static Scorer wrap(Random random, Scorer other, ScoreMode scoreMode, boolean canCallMinCompetitiveScore) {
        if (other == null) {
            return null;
        }
        return new AssertingScorer(random, other, scoreMode, canCallMinCompetitiveScore);
    }

    private AssertingScorer(Random random, Scorer in, ScoreMode scoreMode, boolean canCallMinCompetitiveScore) {
        this.random = random;
        this.in = in;
        this.scoreMode = scoreMode;
        this.doc = in.docID();
        this.canCallMinCompetitiveScore = canCallMinCompetitiveScore;
    }

    public Scorer getIn() {
        return this.in;
    }

    boolean iterating() {
        switch (this.docID()) {
            case -1: 
            case 0x7FFFFFFF: {
                return false;
            }
        }
        return this.state == IteratorState.ITERATING;
    }

    public void setMinCompetitiveScore(float score) throws IOException {
        assert (this.scoreMode == ScoreMode.TOP_SCORES);
        assert (this.canCallMinCompetitiveScore);
        assert (!Float.isNaN(score));
        assert (score >= this.minCompetitiveScore);
        this.in.setMinCompetitiveScore(score);
        this.minCompetitiveScore = score;
    }

    public int advanceShallow(int target) throws IOException {
        assert (this.scoreMode.needsScores());
        assert (target >= this.lastShallowTarget) : "called on decreasing targets: target = " + target + " < last target = " + this.lastShallowTarget;
        assert (target >= this.docID()) : "target = " + target + " < docID = " + this.docID();
        int upTo = this.in.advanceShallow(target);
        assert (upTo >= target) : "upTo = " + upTo + " < target = " + target;
        this.lastShallowTarget = target;
        this.state = target != this.doc ? IteratorState.SHALLOW_ADVANCING : this.state;
        return upTo;
    }

    public float getMaxScore(int upTo) throws IOException {
        assert (this.scoreMode.needsScores());
        assert (upTo >= this.lastShallowTarget) : "uTo = " + upTo + " < last target = " + this.lastShallowTarget;
        assert (this.docID() >= 0 || this.lastShallowTarget >= 0) : "Cannot get max scores until the iterator is positioned or advanceShallow has been called";
        float maxScore = this.in.getMaxScore(upTo);
        return maxScore;
    }

    public float score() throws IOException {
        assert (this.scoreMode.needsScores());
        assert (this.iterating()) : this.state;
        float score = this.in.score();
        assert (!Float.isNaN(score)) : "NaN score for in=" + String.valueOf(this.in);
        assert (this.lastShallowTarget == -1 || score <= this.getMaxScore(this.docID()));
        assert (Float.compare(score, 0.0f) >= 0) : score;
        return score;
    }

    public Collection<Scorable.ChildScorable> getChildren() {
        return Collections.singletonList(new Scorable.ChildScorable((Scorable)this.in, "SHOULD"));
    }

    public int docID() {
        return this.in.docID();
    }

    public String toString() {
        return "AssertingScorer(" + String.valueOf(this.in) + ")";
    }

    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.in.iterator();
        assert (in != null);
        return new DocIdSetIterator(){

            public int docID() {
                assert (AssertingScorer.this.in.docID() == in.docID());
                return in.docID();
            }

            public int nextDoc() throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
                assert (this.docID() + 1 >= AssertingScorer.this.lastShallowTarget);
                int nextDoc = in.nextDoc();
                assert (nextDoc > AssertingScorer.this.doc) : "backwards nextDoc from " + AssertingScorer.this.doc + " to " + nextDoc + " " + String.valueOf(in);
                AssertingScorer.this.state = nextDoc == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
                assert (in.docID() == nextDoc);
                assert (AssertingScorer.this.in.docID() == in.docID());
                AssertingScorer.this.doc = nextDoc;
                return AssertingScorer.this.doc;
            }

            public int advance(int target) throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (target > AssertingScorer.this.doc) : "target must be > docID(), got " + target + " <= " + AssertingScorer.this.doc;
                assert (target >= AssertingScorer.this.lastShallowTarget);
                int advanced = in.advance(target);
                assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
                AssertingScorer.this.state = advanced == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
                assert (in.docID() == advanced) : in.docID() + " != " + advanced + " in " + String.valueOf(in);
                assert (AssertingScorer.this.in.docID() == in.docID());
                AssertingScorer.this.doc = advanced;
                return AssertingScorer.this.doc;
            }

            public long cost() {
                return in.cost();
            }

            public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                assert (this.docID() != -1);
                assert (offset <= this.docID());
                in.intoBitSet(upTo, bitSet, offset);
                assert (this.docID() >= upTo);
            }
        };
    }

    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.in.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        assert (inApproximation.docID() == this.doc);
        DocIdSetIterator assertingApproximation = new DocIdSetIterator(){

            public int docID() {
                return inApproximation.docID();
            }

            public int nextDoc() throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (this.docID() + 1 >= AssertingScorer.this.lastShallowTarget);
                int nextDoc = inApproximation.nextDoc();
                assert (nextDoc > AssertingScorer.this.doc) : "backwards advance from: " + AssertingScorer.this.doc + " to: " + nextDoc;
                AssertingScorer.this.state = nextDoc == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.APPROXIMATING;
                assert (inApproximation.docID() == nextDoc);
                AssertingScorer.this.doc = nextDoc;
                return AssertingScorer.this.doc;
            }

            public int advance(int target) throws IOException {
                assert (AssertingScorer.this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
                assert (target > AssertingScorer.this.doc) : "target must be > docID(), got " + target + " <= " + AssertingScorer.this.doc;
                assert (target >= AssertingScorer.this.lastShallowTarget);
                int advanced = inApproximation.advance(target);
                assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
                AssertingScorer.this.state = advanced == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.APPROXIMATING;
                assert (inApproximation.docID() == advanced);
                AssertingScorer.this.doc = advanced;
                return AssertingScorer.this.doc;
            }

            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(assertingApproximation){

            public boolean matches() throws IOException {
                assert (AssertingScorer.this.state == IteratorState.APPROXIMATING) : AssertingScorer.this.state;
                boolean matches = in.matches();
                if (matches) {
                    assert (AssertingScorer.this.in.iterator().docID() == inApproximation.docID()) : "Approximation and scorer don't advance synchronously";
                    AssertingScorer.this.doc = inApproximation.docID();
                    AssertingScorer.this.state = IteratorState.ITERATING;
                }
                return matches;
            }

            public float matchCost() {
                float matchCost = in.matchCost();
                assert (!Float.isNaN(matchCost));
                assert (matchCost >= 0.0f);
                return matchCost;
            }

            public String toString() {
                return "AssertingScorer@asTwoPhaseIterator(" + String.valueOf(in) + ")";
            }
        };
    }

    static enum IteratorState {
        APPROXIMATING,
        ITERATING,
        SHALLOW_ADVANCING,
        FINISHED;

    }
}

