/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.tests.search.AssertingScorable;

class AssertingLeafCollector
extends FilterLeafCollector {
    private final int min;
    private final int max;
    private int lastCollected = -1;
    private boolean finishCalled;

    AssertingLeafCollector(LeafCollector collector, int min, int max) {
        super(collector);
        this.min = min;
        this.max = max;
    }

    public void setScorer(Scorable scorer) throws IOException {
        super.setScorer(AssertingScorable.wrap(scorer));
    }

    public void collect(DocIdStream stream) throws IOException {
        this.in.collect((DocIdStream)new AssertingDocIdStream(stream));
    }

    public void collect(int doc) throws IOException {
        assert (doc > this.lastCollected) : "Out of order : " + this.lastCollected + " " + doc;
        assert (doc >= this.min) : "Out of range: " + doc + " < " + this.min;
        assert (doc < this.max) : "Out of range: " + doc + " >= " + this.max;
        this.in.collect(doc);
        this.lastCollected = doc;
    }

    public DocIdSetIterator competitiveIterator() throws IOException {
        final DocIdSetIterator in = this.in.competitiveIterator();
        if (in == null) {
            return null;
        }
        return new DocIdSetIterator(){

            public int nextDoc() throws IOException {
                assert (in.docID() < AssertingLeafCollector.this.max) : "advancing beyond the end of the scored window: docID=" + in.docID() + ", max=" + AssertingLeafCollector.this.max;
                return in.nextDoc();
            }

            public int docID() {
                return in.docID();
            }

            public long cost() {
                return in.cost();
            }

            public int advance(int target) throws IOException {
                assert (target <= AssertingLeafCollector.this.max) : "advancing beyond the end of the scored window: target=" + target + ", max=" + AssertingLeafCollector.this.max;
                return in.advance(target);
            }
        };
    }

    public void finish() throws IOException {
        assert (!this.finishCalled);
        this.finishCalled = true;
        super.finish();
    }

    private class AssertingDocIdStream
    extends DocIdStream {
        private final DocIdStream stream;
        private boolean consumed;

        AssertingDocIdStream(DocIdStream stream) {
            this.stream = stream;
        }

        public void forEach(CheckedIntConsumer<IOException> consumer) throws IOException {
            assert (!this.consumed) : "A terminal operation has already been called";
            this.stream.forEach(doc -> {
                assert (doc > AssertingLeafCollector.this.lastCollected) : "Out of order : " + AssertingLeafCollector.this.lastCollected + " " + doc;
                assert (doc >= AssertingLeafCollector.this.min) : "Out of range: " + doc + " < " + AssertingLeafCollector.this.min;
                assert (doc < AssertingLeafCollector.this.max) : "Out of range: " + doc + " >= " + AssertingLeafCollector.this.max;
                consumer.accept(doc);
                AssertingLeafCollector.this.lastCollected = doc;
            });
            this.consumed = true;
        }

        public int count() throws IOException {
            assert (!this.consumed) : "A terminal operation has already been called";
            int count = this.stream.count();
            this.consumed = true;
            return count;
        }
    }
}

