/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.generators.RandomBytes;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.CRC32;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.tests.mockfile.ExtrasFS;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.GroupVIntUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;
import org.junit.Assert;

public abstract class BaseDirectoryTestCase
extends LuceneTestCase {
    protected abstract Directory getDirectory(Path var1) throws IOException;

    public void testCopyFrom() throws Exception {
        BaseDirectoryWrapper dest;
        try (Object source = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopy"));){
            dest = BaseDirectoryTestCase.newDirectory();
            try {
                this.runCopyFrom((Directory)source, (Directory)dest);
            }
            finally {
                if (dest != null) {
                    dest.close();
                }
            }
        }
        source = BaseDirectoryTestCase.newDirectory();
        try {
            dest = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopyDestination"));
            try {
                this.runCopyFrom((Directory)source, (Directory)dest);
            }
            finally {
                if (dest != null) {
                    dest.close();
                }
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
    }

    private void runCopyFrom(Directory source, Directory dest) throws IOException {
        IndexOutput output = source.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
        byte[] bytes = RandomBytes.randomBytesOfLength((Random)BaseDirectoryTestCase.random(), (int)20000);
        output.writeBytes(bytes, bytes.length);
        output.close();
        dest.copyFrom(source, "foobar", "foobaz", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
        BaseDirectoryTestCase.assertTrue((boolean)BaseDirectoryTestCase.slowFileExists(dest, "foobaz"));
        IndexInput input = dest.openInput("foobaz", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
        byte[] bytes2 = new byte[bytes.length];
        input.readBytes(bytes2, 0, bytes2.length);
        input.close();
        BaseDirectoryTestCase.assertArrayEquals((byte[])bytes, (byte[])bytes2);
    }

    public void testRename() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testRename"));){
            IndexOutput output = dir.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int numBytes = BaseDirectoryTestCase.random().nextInt(20000);
            byte[] bytes = new byte[numBytes];
            BaseDirectoryTestCase.random().nextBytes(bytes);
            output.writeBytes(bytes, bytes.length);
            output.close();
            dir.rename("foobar", "foobaz");
            IndexInput input = dir.openInput("foobaz", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] bytes2 = new byte[numBytes];
            input.readBytes(bytes2, 0, bytes2.length);
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)numBytes);
            input.close();
            BaseDirectoryTestCase.assertArrayEquals((byte[])bytes, (byte[])bytes2);
        }
    }

    public void testDeleteFile() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testDeleteFile"));){
            String file = "foo.txt";
            Assert.assertFalse((boolean)Arrays.asList(dir.listAll()).contains(file));
            dir.createOutput("foo.txt", IOContext.DEFAULT).close();
            Assert.assertTrue((boolean)Arrays.asList(dir.listAll()).contains(file));
            dir.deleteFile("foo.txt");
            Assert.assertFalse((boolean)Arrays.asList(dir.listAll()).contains(file));
            BaseDirectoryTestCase.expectThrowsAnyOf(Arrays.asList(NoSuchFileException.class, FileNotFoundException.class), () -> dir.deleteFile("foo.txt"));
        }
    }

    public void testByte() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testByte"));){
            IndexOutput output = dir.createOutput("byte", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeByte((byte)-128);
            output.close();
            IndexInput input = dir.openInput("byte", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)1L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-128L, (long)input.readByte());
            input.close();
        }
    }

    public void testShort() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testShort"));){
            IndexOutput output = dir.createOutput("short", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeShort((short)-20);
            output.close();
            IndexInput input = dir.openInput("short", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)2L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-20L, (long)input.readShort());
            input.close();
        }
    }

    public void testInt() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testInt"));){
            IndexOutput output = dir.createOutput("int", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeInt(-500);
            output.close();
            IndexInput input = dir.openInput("int", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)4L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-500L, (long)input.readInt());
            input.close();
        }
    }

    public void testLong() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testLong"));){
            IndexOutput output = dir.createOutput("long", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeLong(-5000L);
            output.close();
            IndexInput input = dir.openInput("long", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)8L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)-5000L, (long)input.readLong());
            input.close();
        }
    }

    public void testAlignedLittleEndianLongs() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testAlignedLittleEndianLongs"));){
            try (IndexOutput out = dir.createOutput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                out.writeLong(3L);
                out.writeLong(Long.MAX_VALUE);
                out.writeLong(-3L);
            }
            try (IndexInput input = dir.openInput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)24L, (long)input.length());
                long[] l = new long[4];
                input.readLongs(l, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((long[])new long[]{0L, 3L, Long.MAX_VALUE, -3L}, (long[])l);
                BaseDirectoryTestCase.assertEquals((long)24L, (long)input.getFilePointer());
            }
        }
    }

    public void testUnalignedLittleEndianLongs() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testUnalignedLittleEndianLongs"));){
            try (IndexOutput out = dir.createOutput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                out.writeByte((byte)2);
                out.writeLong(3L);
                out.writeLong(Long.MAX_VALUE);
                out.writeLong(-3L);
            }
            try (IndexInput input = dir.openInput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)25L, (long)input.length());
                BaseDirectoryTestCase.assertEquals((long)2L, (long)input.readByte());
                long[] l = new long[4];
                input.readLongs(l, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((long[])new long[]{0L, 3L, Long.MAX_VALUE, -3L}, (long[])l);
                BaseDirectoryTestCase.assertEquals((long)25L, (long)input.getFilePointer());
            }
        }
    }

    public void testLittleEndianLongsUnderflow() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testLittleEndianLongsUnderflow"));){
            int offset = BaseDirectoryTestCase.random().nextInt(8);
            int length = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 16);
            try (IndexOutput out = dir.createOutput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                byte[] b = new byte[offset + length * 8 - TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 8)];
                BaseDirectoryTestCase.random().nextBytes(b);
                out.writeBytes(b, b.length);
            }
            try (IndexInput input = dir.openInput("littleEndianLongs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                input.seek((long)offset);
                BaseDirectoryTestCase.expectThrows(EOFException.class, () -> input.readLongs(new long[length], 0, length));
            }
        }
    }

    public void testAlignedInts() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testAlignedInts"));){
            try (IndexOutput out = dir.createOutput("Ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                out.writeInt(3);
                out.writeInt(Integer.MAX_VALUE);
                out.writeInt(-3);
            }
            try (IndexInput input = dir.openInput("Ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)12L, (long)input.length());
                int[] i = new int[4];
                input.readInts(i, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((int[])new int[]{0, 3, Integer.MAX_VALUE, -3}, (int[])i);
                BaseDirectoryTestCase.assertEquals((long)12L, (long)input.getFilePointer());
            }
        }
    }

    public void testUnalignedInts() throws Exception {
        int padding = BaseDirectoryTestCase.random().nextInt(3) + 1;
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testUnalignedInts"));){
            int i;
            try (IndexOutput out = dir.createOutput("Ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                for (i = 0; i < padding; ++i) {
                    out.writeByte((byte)2);
                }
                out.writeInt(3);
                out.writeInt(Integer.MAX_VALUE);
                out.writeInt(-3);
            }
            try (IndexInput input = dir.openInput("Ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)(12 + padding), (long)input.length());
                for (i = 0; i < padding; ++i) {
                    BaseDirectoryTestCase.assertEquals((long)2L, (long)input.readByte());
                }
                int[] i2 = new int[4];
                input.readInts(i2, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((int[])new int[]{0, 3, Integer.MAX_VALUE, -3}, (int[])i2);
                BaseDirectoryTestCase.assertEquals((long)(12 + padding), (long)input.getFilePointer());
            }
        }
    }

    public void testIntsUnderflow() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testIntsUnderflow"));){
            int offset = BaseDirectoryTestCase.random().nextInt(4);
            int length = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 16);
            try (IndexOutput out = dir.createOutput("Ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                byte[] b = new byte[offset + length * 4 - TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 4)];
                BaseDirectoryTestCase.random().nextBytes(b);
                out.writeBytes(b, b.length);
            }
            try (IndexInput input = dir.openInput("Ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                input.seek((long)offset);
                BaseDirectoryTestCase.expectThrows(EOFException.class, () -> input.readInts(new int[length], 0, length));
            }
        }
    }

    public void testAlignedFloats() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testAlignedFloats"));){
            try (IndexOutput out = dir.createOutput("Floats", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                out.writeInt(Float.floatToIntBits(3.0f));
                out.writeInt(Float.floatToIntBits(Float.MAX_VALUE));
                out.writeInt(Float.floatToIntBits(-3.0f));
            }
            try (IndexInput input = dir.openInput("Floats", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)12L, (long)input.length());
                float[] ff = new float[4];
                input.readFloats(ff, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((float[])new float[]{0.0f, 3.0f, Float.MAX_VALUE, -3.0f}, (float[])ff, (float)0.0f);
                BaseDirectoryTestCase.assertEquals((long)12L, (long)input.getFilePointer());
            }
        }
    }

    public void testUnalignedFloats() throws Exception {
        int padding = BaseDirectoryTestCase.random().nextInt(3) + 1;
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testUnalignedFloats"));){
            int i;
            try (IndexOutput out = dir.createOutput("Floats", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                for (i = 0; i < padding; ++i) {
                    out.writeByte((byte)2);
                }
                out.writeInt(Float.floatToIntBits(3.0f));
                out.writeInt(Float.floatToIntBits(Float.MAX_VALUE));
                out.writeInt(Float.floatToIntBits(-3.0f));
            }
            try (IndexInput input = dir.openInput("Floats", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                BaseDirectoryTestCase.assertEquals((long)(12 + padding), (long)input.length());
                for (i = 0; i < padding; ++i) {
                    BaseDirectoryTestCase.assertEquals((long)2L, (long)input.readByte());
                }
                float[] ff = new float[4];
                input.readFloats(ff, 1, 3);
                BaseDirectoryTestCase.assertArrayEquals((float[])new float[]{0.0f, 3.0f, Float.MAX_VALUE, -3.0f}, (float[])ff, (float)0.0f);
                BaseDirectoryTestCase.assertEquals((long)(12 + padding), (long)input.getFilePointer());
            }
        }
    }

    public void testFloatsUnderflow() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testFloatsUnderflow"));){
            int offset = BaseDirectoryTestCase.random().nextInt(4);
            int length = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 16);
            try (IndexOutput out = dir.createOutput("Floats", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                byte[] b = new byte[offset + length * 4 - TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 4)];
                BaseDirectoryTestCase.random().nextBytes(b);
                out.writeBytes(b, b.length);
            }
            try (IndexInput input = dir.openInput("Floats", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                input.seek((long)offset);
                BaseDirectoryTestCase.expectThrows(EOFException.class, () -> input.readFloats(new float[length], 0, length));
            }
        }
    }

    public void testString() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testString"));){
            IndexOutput output = dir.createOutput("string", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeString("hello!");
            output.close();
            IndexInput input = dir.openInput("string", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((Object)"hello!", (Object)input.readString());
            BaseDirectoryTestCase.assertEquals((long)7L, (long)input.length());
            input.close();
        }
    }

    public void testVInt() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testVInt"));){
            IndexOutput output = dir.createOutput("vint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeVInt(500);
            output.close();
            IndexInput input = dir.openInput("vint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)2L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)500L, (long)input.readVInt());
            input.close();
        }
    }

    public void testVLong() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testVLong"));){
            IndexOutput output = dir.createOutput("vlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeVLong(Long.MAX_VALUE);
            output.close();
            IndexInput input = dir.openInput("vlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((long)9L, (long)input.length());
            BaseDirectoryTestCase.assertEquals((long)Long.MAX_VALUE, (long)input.readVLong());
            input.close();
        }
    }

    public void testZInt() throws Exception {
        int[] ints = new int[BaseDirectoryTestCase.random().nextInt(10)];
        block10: for (int i = 0; i < ints.length; ++i) {
            switch (BaseDirectoryTestCase.random().nextInt(3)) {
                case 0: {
                    ints[i] = BaseDirectoryTestCase.random().nextInt();
                    continue block10;
                }
                case 1: {
                    ints[i] = BaseDirectoryTestCase.random().nextBoolean() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    continue block10;
                }
                case 2: {
                    ints[i] = (BaseDirectoryTestCase.random().nextBoolean() ? -1 : 1) * BaseDirectoryTestCase.random().nextInt(1024);
                    continue block10;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testZInt"));){
            IndexOutput output = dir.createOutput("zint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (int i : ints) {
                output.writeZInt(i);
            }
            output.close();
            IndexInput input = dir.openInput("zint", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (int i : ints) {
                BaseDirectoryTestCase.assertEquals((long)i, (long)input.readZInt());
            }
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testZLong() throws Exception {
        long[] longs = new long[BaseDirectoryTestCase.random().nextInt(10)];
        block10: for (int i = 0; i < longs.length; ++i) {
            switch (BaseDirectoryTestCase.random().nextInt(3)) {
                case 0: {
                    longs[i] = BaseDirectoryTestCase.random().nextLong();
                    continue block10;
                }
                case 1: {
                    longs[i] = BaseDirectoryTestCase.random().nextBoolean() ? Long.MIN_VALUE : Long.MAX_VALUE;
                    continue block10;
                }
                case 2: {
                    longs[i] = (long)(BaseDirectoryTestCase.random().nextBoolean() ? -1 : 1) * (long)BaseDirectoryTestCase.random().nextInt(1024);
                    continue block10;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testZLong"));){
            IndexOutput output = dir.createOutput("zlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (long l : longs) {
                output.writeZLong(l);
            }
            output.close();
            IndexInput input = dir.openInput("zlong", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            for (long l : longs) {
                BaseDirectoryTestCase.assertEquals((long)l, (long)input.readZLong());
            }
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testSetOfStrings() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSetOfStrings"));){
            IndexOutput output = dir.createOutput("stringset", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeSetOfStrings(BaseDirectoryTestCase.asSet("test1", "test2"));
            output.writeSetOfStrings(Collections.emptySet());
            output.writeSetOfStrings(BaseDirectoryTestCase.asSet("test3"));
            output.close();
            IndexInput input = dir.openInput("stringset", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            Set set1 = input.readSetOfStrings();
            BaseDirectoryTestCase.assertEquals(BaseDirectoryTestCase.asSet("test1", "test2"), (Object)set1);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> set1.add("bogus"));
            Set set2 = input.readSetOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.emptySet(), (Object)set2);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> set2.add("bogus"));
            Set set3 = input.readSetOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.singleton("test3"), (Object)set3);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> set3.add("bogus"));
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testMapOfStrings() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("test1", "value1");
        m.put("test2", "value2");
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testMapOfStrings"));){
            IndexOutput output = dir.createOutput("stringmap", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeMapOfStrings(m);
            output.writeMapOfStrings(Collections.emptyMap());
            output.writeMapOfStrings(Collections.singletonMap("key", "value"));
            output.close();
            IndexInput input = dir.openInput("stringmap", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            Map map1 = input.readMapOfStrings();
            BaseDirectoryTestCase.assertEquals(m, (Object)map1);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> map1.put("bogus1", "bogus2"));
            Map map2 = input.readMapOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.emptyMap(), (Object)map2);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> map2.put("bogus1", "bogus2"));
            Map map3 = input.readMapOfStrings();
            BaseDirectoryTestCase.assertEquals(Collections.singletonMap("key", "value"), (Object)map3);
            BaseDirectoryTestCase.expectThrows(UnsupportedOperationException.class, () -> map3.put("bogus1", "bogus2"));
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)input.getFilePointer());
            input.close();
        }
    }

    public void testChecksum() throws Exception {
        CRC32 expected = new CRC32();
        int numBytes = BaseDirectoryTestCase.random().nextInt(20000);
        byte[] bytes = new byte[numBytes];
        BaseDirectoryTestCase.random().nextBytes(bytes);
        expected.update(bytes);
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testChecksum"));){
            IndexOutput output = dir.createOutput("checksum", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            output.writeBytes(bytes, 0, bytes.length);
            output.close();
            ChecksumIndexInput input = dir.openChecksumInput("checksum");
            input.skipBytes((long)numBytes);
            BaseDirectoryTestCase.assertEquals((long)expected.getValue(), (long)input.getChecksum());
            input.close();
        }
    }

    public void testDetectClose() throws Throwable {
        Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testDetectClose"));
        dir.close();
        BaseDirectoryTestCase.expectThrows(AlreadyClosedException.class, () -> dir.createOutput("test", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random())));
    }

    public void testThreadSafetyInListAll() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testThreadSafety"));){
            if (dir instanceof BaseDirectoryWrapper) {
                ((BaseDirectoryWrapper)dir).setCheckIndexOnClose(false);
            }
            if (dir instanceof MockDirectoryWrapper) {
                ((MockDirectoryWrapper)dir).setThrottling(MockDirectoryWrapper.Throttling.NEVER);
            }
            AtomicBoolean stop = new AtomicBoolean();
            Thread writer = new Thread(() -> {
                try {
                    int max = RandomizedTest.randomIntBetween((int)500, (int)1000);
                    for (int i = 0; i < max; ++i) {
                        String fileName = "file-" + i;
                        try (IndexOutput output = dir.createOutput(fileName, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                            assert (output != null);
                            Thread.yield();
                        }
                        BaseDirectoryTestCase.assertTrue((boolean)BaseDirectoryTestCase.slowFileExists(dir, fileName));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    stop.set(true);
                }
            });
            Thread reader = new Thread(() -> {
                try {
                    Random rnd = new Random(RandomizedTest.randomLong());
                    while (!stop.get()) {
                        Object[] files = (String[])Arrays.stream(dir.listAll()).filter(name -> !ExtrasFS.isExtra(name)).toArray(String[]::new);
                        if (files.length <= 0) continue;
                        do {
                            String file = (String)RandomPicks.randomFrom((Random)rnd, (Object[])files);
                            try (IndexInput input2 = dir.openInput(file, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));){
                                assert (input2 != null);
                            }
                            catch (AccessDeniedException input2) {
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException("Something went wrong when opening: " + file, e);
                            }
                        } while (rnd.nextInt(3) != 0);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            reader.start();
            writer.start();
            writer.join();
            reader.join();
        }
    }

    public void testFileExistsInListAfterCreated() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testFileExistsInListAfterCreated"));){
            String name = "file";
            dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random())).close();
            BaseDirectoryTestCase.assertTrue((boolean)BaseDirectoryTestCase.slowFileExists(dir, name));
            BaseDirectoryTestCase.assertTrue((boolean)Arrays.asList(dir.listAll()).contains(name));
        }
    }

    public void testSeekToEOFThenBack() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSeekToEOFThenBack"));){
            int bufferLength = 1024;
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] bytes = new byte[3 * bufferLength];
            o.writeBytes(bytes, 0, bytes.length);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            i.seek(2L * (long)bufferLength - 1L);
            i.seek(3L * (long)bufferLength);
            i.seek((long)bufferLength);
            i.readBytes(bytes, 0, 2 * bufferLength);
            i.close();
        }
    }

    public void testIllegalEOF() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testIllegalEOF"));){
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] b = new byte[1024];
            o.writeBytes(b, 0, 1024);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            i.seek(1024L);
            i.close();
        }
    }

    public void testSeekPastEOF() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSeekPastEOF"));){
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int len = BaseDirectoryTestCase.random().nextInt(2048);
            byte[] b = new byte[len];
            o.writeBytes(b, 0, len);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.expectThrows(EOFException.class, () -> i.seek((long)(len + RandomizedTest.randomIntBetween((int)1, (int)2048))));
            i.seek((long)len);
            BaseDirectoryTestCase.expectThrows(EOFException.class, () -> ((IndexInput)i).readByte());
            BaseDirectoryTestCase.expectThrows(EOFException.class, () -> i.readBytes(new byte[1], 0, 1));
            i.close();
        }
    }

    public void testSliceOutOfBounds() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testSliceOutOfBounds"));){
            IndexOutput o = dir.createOutput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int len = BaseDirectoryTestCase.random().nextInt(2040) + 8;
            byte[] b = new byte[len];
            o.writeBytes(b, 0, len);
            o.close();
            IndexInput i = dir.openInput("out", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.expectThrows(IllegalArgumentException.class, () -> i.slice("slice1", 0L, (long)(len + 1)));
            BaseDirectoryTestCase.expectThrows(IllegalArgumentException.class, () -> i.slice("slice2", -1L, (long)len));
            IndexInput slice = i.slice("slice3", 4L, (long)(len / 2));
            BaseDirectoryTestCase.expectThrows(IllegalArgumentException.class, () -> slice.slice("slice3sub", 1L, (long)(len / 2)));
            i.close();
        }
    }

    public void testNoDir() throws Throwable {
        Path tempDir = BaseDirectoryTestCase.createTempDir("doesnotexist");
        IOUtils.rm((Path[])new Path[]{tempDir});
        try (Directory dir = this.getDirectory(tempDir);){
            BaseDirectoryTestCase.expectThrowsAnyOf(Arrays.asList(NoSuchFileException.class, IndexNotFoundException.class), () -> DirectoryReader.open((Directory)dir));
        }
    }

    public void testCopyBytes() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopyBytes"));){
            int upto;
            IndexOutput out = dir.createOutput("test", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] bytes = new byte[TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 77777)];
            int size = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 1777777);
            int byteUpto = 0;
            for (upto = 0; upto < size; ++upto) {
                bytes[byteUpto++] = BaseDirectoryTestCase.value(upto);
                if (byteUpto != bytes.length) continue;
                out.writeBytes(bytes, 0, bytes.length);
                byteUpto = 0;
            }
            out.writeBytes(bytes, 0, byteUpto);
            BaseDirectoryTestCase.assertEquals((long)size, (long)out.getFilePointer());
            out.close();
            BaseDirectoryTestCase.assertEquals((long)size, (long)dir.fileLength("test"));
            IndexInput in = dir.openInput("test", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out = dir.createOutput("test2", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            upto = 0;
            while (upto < size) {
                if (BaseDirectoryTestCase.random().nextBoolean()) {
                    out.writeByte(in.readByte());
                    ++upto;
                    continue;
                }
                int chunk = Math.min(TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, bytes.length), size - upto);
                out.copyBytes((DataInput)in, (long)chunk);
                upto += chunk;
            }
            BaseDirectoryTestCase.assertEquals((long)size, (long)upto);
            out.close();
            in.close();
            IndexInput in2 = dir.openInput("test2", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            upto = 0;
            while (upto < size) {
                if (BaseDirectoryTestCase.random().nextBoolean()) {
                    byte v = in2.readByte();
                    BaseDirectoryTestCase.assertEquals((long)BaseDirectoryTestCase.value(upto), (long)v);
                    ++upto;
                    continue;
                }
                int limit = Math.min(TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, bytes.length), size - upto);
                in2.readBytes(bytes, 0, limit);
                for (int byteIdx = 0; byteIdx < limit; ++byteIdx) {
                    BaseDirectoryTestCase.assertEquals((long)BaseDirectoryTestCase.value(upto), (long)bytes[byteIdx]);
                    ++upto;
                }
            }
            in2.close();
            dir.deleteFile("test");
            dir.deleteFile("test2");
        }
    }

    private static byte value(int idx) {
        return (byte)(idx % 256 * (1 + idx / 256));
    }

    public void testCopyBytesWithThreads() throws Exception {
        try (Directory d = this.getDirectory(BaseDirectoryTestCase.createTempDir("testCopyBytesWithThreads"));){
            Thread[] copies;
            int headerLen = 100;
            byte[] data = RandomBytes.randomBytesOfLengthBetween((Random)BaseDirectoryTestCase.random(), (int)(headerLen + 1), (int)10000);
            IndexOutput output = d.createOutput("data", IOContext.DEFAULT);
            output.writeBytes(data, 0, data.length);
            output.close();
            IndexInput input = d.openInput("data", IOContext.DEFAULT);
            IndexOutput outputHeader = d.createOutput("header", IOContext.DEFAULT);
            outputHeader.copyBytes((DataInput)input, (long)headerLen);
            outputHeader.close();
            int threads = 10;
            CyclicBarrier start = new CyclicBarrier(threads);
            for (Thread t : copies = (Thread[])IntStream.range(0, threads).mapToObj(i -> {
                IndexInput src = input.clone();
                Thread t = new Thread(() -> {
                    try {
                        start.await();
                        IndexOutput dst = d.createOutput("copy" + i, IOContext.DEFAULT);
                        dst.copyBytes((DataInput)src, src.length() - (long)headerLen);
                        dst.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                t.start();
                return t;
            }).toArray(Thread[]::new)) {
                t.join();
            }
            for (int i2 = 0; i2 < threads; ++i2) {
                try (IndexInput copiedData = d.openInput("copy" + i2, IOContext.DEFAULT);){
                    byte[] dataCopy = new byte[data.length];
                    System.arraycopy(data, 0, dataCopy, 0, headerLen);
                    copiedData.readBytes(dataCopy, headerLen, data.length - headerLen);
                    BaseDirectoryTestCase.assertArrayEquals((byte[])data, (byte[])dataCopy);
                    continue;
                }
            }
            input.close();
        }
    }

    public void testFsyncDoesntCreateNewFiles() throws Exception {
        Path path = BaseDirectoryTestCase.createTempDir("nocreate");
        try (Directory fsdir = this.getDirectory(path);){
            if (!(fsdir instanceof FSDirectory)) {
                BaseDirectoryTestCase.assumeTrue("test only works for FSDirectory subclasses", false);
                return;
            }
            IndexOutput out = fsdir.createOutput("afile", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out.writeString("boo");
            out.close();
            Files.delete(path.resolve("afile"));
            int fileCount = fsdir.listAll().length;
            BaseDirectoryTestCase.expectThrowsAnyOf(Arrays.asList(FileNotFoundException.class, NoSuchFileException.class), () -> fsdir.sync(Collections.singleton("afile")));
            BaseDirectoryTestCase.assertEquals((long)fileCount, (long)fsdir.listAll().length);
        }
    }

    public void testRandomLong() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testLongs"));){
            int i;
            IndexOutput output = dir.createOutput("longs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 3000);
            long[] longs = new long[num];
            for (int i2 = 0; i2 < longs.length; ++i2) {
                longs[i2] = TestUtil.nextLong(BaseDirectoryTestCase.random(), Long.MIN_VALUE, Long.MAX_VALUE);
                output.writeLong(longs[i2]);
            }
            output.close();
            IndexInput input = dir.openInput("longs", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)slice.length());
            for (i = 0; i < longs.length; ++i) {
                BaseDirectoryTestCase.assertEquals((long)longs[i], (long)slice.readLong((long)i * 8L));
            }
            for (i = 1; i < longs.length; ++i) {
                long offset = (long)i * 8L;
                RandomAccessInput subslice = input.randomAccessSlice(offset, input.length() - offset);
                BaseDirectoryTestCase.assertEquals((long)(input.length() - offset), (long)subslice.length());
                for (int j = i; j < longs.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)longs[j], (long)subslice.readLong((long)(j - i) * 8L));
                }
            }
            for (i = 0; i < 7; ++i) {
                String name = "longs-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                BaseDirectoryTestCase.assertEquals((long)(padded.length() - (long)i), (long)whole.length());
                for (int j = 0; j < longs.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)longs[j], (long)whole.readLong((long)j * 8L));
                }
                padded.close();
            }
            input.close();
        }
    }

    public void testRandomInt() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testInts"));){
            int i;
            IndexOutput output = dir.createOutput("ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 3000);
            int[] ints = new int[num];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                ints[i2] = BaseDirectoryTestCase.random().nextInt();
                output.writeInt(ints[i2]);
            }
            output.close();
            IndexInput input = dir.openInput("ints", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)slice.length());
            for (i = 0; i < ints.length; ++i) {
                BaseDirectoryTestCase.assertEquals((long)ints[i], (long)slice.readInt((long)i * 4L));
            }
            for (i = 1; i < ints.length; ++i) {
                long offset = (long)i * 4L;
                RandomAccessInput subslice = input.randomAccessSlice(offset, input.length() - offset);
                BaseDirectoryTestCase.assertEquals((long)(input.length() - offset), (long)subslice.length());
                for (int j = i; j < ints.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)ints[j], (long)subslice.readInt((long)(j - i) * 4L));
                }
            }
            for (i = 0; i < 7; ++i) {
                String name = "ints-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                BaseDirectoryTestCase.assertEquals((long)(padded.length() - (long)i), (long)whole.length());
                for (int j = 0; j < ints.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)ints[j], (long)whole.readInt((long)j * 4L));
                }
                padded.close();
            }
            input.close();
        }
    }

    public void testRandomShort() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testShorts"));){
            int i;
            IndexOutput output = dir.createOutput("shorts", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 3000);
            short[] shorts = new short[num];
            for (int i2 = 0; i2 < shorts.length; ++i2) {
                shorts[i2] = (short)BaseDirectoryTestCase.random().nextInt();
                output.writeShort(shorts[i2]);
            }
            output.close();
            IndexInput input = dir.openInput("shorts", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)slice.length());
            for (i = 0; i < shorts.length; ++i) {
                BaseDirectoryTestCase.assertEquals((long)shorts[i], (long)slice.readShort((long)i * 2L));
            }
            for (i = 1; i < shorts.length; ++i) {
                long offset = (long)i * 2L;
                RandomAccessInput subslice = input.randomAccessSlice(offset, input.length() - offset);
                BaseDirectoryTestCase.assertEquals((long)(input.length() - offset), (long)subslice.length());
                for (int j = i; j < shorts.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)shorts[j], (long)subslice.readShort((long)(j - i) * 2L));
                }
            }
            for (i = 0; i < 7; ++i) {
                String name = "shorts-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                BaseDirectoryTestCase.assertEquals((long)(padded.length() - (long)i), (long)whole.length());
                for (int j = 0; j < shorts.length; ++j) {
                    BaseDirectoryTestCase.assertEquals((long)shorts[j], (long)whole.readShort((long)j * 2L));
                }
                padded.close();
            }
            input.close();
        }
    }

    public void testRandomByte() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testBytes"));){
            IndexOutput output = dir.createOutput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TEST_NIGHTLY ? TestUtil.nextInt(BaseDirectoryTestCase.random(), 1000, 3000) : TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 1000);
            byte[] bytes = new byte[num];
            BaseDirectoryTestCase.random().nextBytes(bytes);
            for (int i = 0; i < bytes.length; ++i) {
                output.writeByte(bytes[i]);
            }
            output.close();
            IndexInput input = dir.openInput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            RandomAccessInput slice = input.randomAccessSlice(0L, input.length());
            BaseDirectoryTestCase.assertEquals((long)input.length(), (long)slice.length());
            this.assertBytes(slice, bytes, 0);
            for (int offset = 1; offset < bytes.length; ++offset) {
                RandomAccessInput subslice = input.randomAccessSlice((long)offset, input.length() - (long)offset);
                BaseDirectoryTestCase.assertEquals((long)(input.length() - (long)offset), (long)subslice.length());
                this.assertBytes(subslice, bytes, offset);
            }
            for (int i = 1; i < 7; ++i) {
                String name = "bytes-" + i;
                IndexOutput o = dir.createOutput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                byte[] junk = new byte[i];
                BaseDirectoryTestCase.random().nextBytes(junk);
                o.writeBytes(junk, junk.length);
                input.seek(0L);
                o.copyBytes((DataInput)input, input.length());
                o.close();
                IndexInput padded = dir.openInput(name, BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                RandomAccessInput whole = padded.randomAccessSlice((long)i, padded.length() - (long)i);
                BaseDirectoryTestCase.assertEquals((long)(padded.length() - (long)i), (long)whole.length());
                this.assertBytes(whole, bytes, 0);
                padded.close();
            }
            input.close();
        }
    }

    protected void assertBytes(RandomAccessInput slice, byte[] bytes, int bytesOffset) throws IOException {
        int toRead = bytes.length - bytesOffset;
        for (int i = 0; i < toRead; ++i) {
            BaseDirectoryTestCase.assertEquals((long)bytes[bytesOffset + i], (long)slice.readByte((long)i));
            int offset = BaseDirectoryTestCase.random().nextInt(1000);
            byte[] sub1 = new byte[offset + i];
            slice.readBytes(0L, sub1, offset, i);
            BaseDirectoryTestCase.assertArrayEquals((byte[])ArrayUtil.copyOfSubArray((byte[])bytes, (int)bytesOffset, (int)(bytesOffset + i)), (byte[])ArrayUtil.copyOfSubArray((byte[])sub1, (int)offset, (int)sub1.length));
            byte[] sub2 = new byte[offset + toRead - i];
            slice.readBytes((long)i, sub2, offset, toRead - i);
            BaseDirectoryTestCase.assertArrayEquals((byte[])ArrayUtil.copyOfSubArray((byte[])bytes, (int)(bytesOffset + i), (int)bytes.length), (byte[])ArrayUtil.copyOfSubArray((byte[])sub2, (int)offset, (int)sub2.length));
        }
    }

    public void testSliceOfSlice() throws Exception {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("sliceOfSlice"));){
            IndexOutput output = dir.createOutput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            int num = TEST_NIGHTLY ? TestUtil.nextInt(BaseDirectoryTestCase.random(), 250, 2500) : TestUtil.nextInt(BaseDirectoryTestCase.random(), 50, 250);
            byte[] bytes = new byte[num];
            BaseDirectoryTestCase.random().nextBytes(bytes);
            for (int i = 0; i < bytes.length; ++i) {
                output.writeByte(bytes[i]);
            }
            output.close();
            IndexInput input = dir.openInput("bytes", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            input.seek(TestUtil.nextLong(BaseDirectoryTestCase.random(), 0L, input.length()));
            for (int i = 0; i < num; i += 16) {
                IndexInput slice1 = input.slice("slice1", (long)i, (long)(num - i));
                BaseDirectoryTestCase.assertEquals((long)0L, (long)slice1.getFilePointer());
                BaseDirectoryTestCase.assertEquals((long)(num - i), (long)slice1.length());
                slice1.seek(TestUtil.nextLong(BaseDirectoryTestCase.random(), 0L, slice1.length()));
                int j = 0;
                while ((long)j < slice1.length()) {
                    IndexInput slice2 = slice1.slice("slice2", (long)j, (long)(num - i - j));
                    BaseDirectoryTestCase.assertEquals((long)0L, (long)slice2.getFilePointer());
                    BaseDirectoryTestCase.assertEquals((long)(num - i - j), (long)slice2.length());
                    byte[] data = new byte[num];
                    System.arraycopy(bytes, 0, data, 0, i + j);
                    if (BaseDirectoryTestCase.random().nextBoolean()) {
                        slice2.readBytes(data, i + j, num - i - j);
                    } else {
                        long seek = TestUtil.nextLong(BaseDirectoryTestCase.random(), 0L, slice2.length());
                        slice2.seek(seek);
                        slice2.readBytes(data, (int)((long)(i + j) + seek), (int)((long)(num - i - j) - seek));
                        slice2.seek(0L);
                        slice2.readBytes(data, i + j, (int)seek);
                    }
                    BaseDirectoryTestCase.assertArrayEquals((byte[])bytes, (byte[])data);
                    j += 16;
                }
            }
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargeWrites() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("largeWrites"));){
            IndexOutput os = dir.createOutput("testBufferStart.txt", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            byte[] largeBuf = new byte[2048];
            BaseDirectoryTestCase.random().nextBytes(largeBuf);
            long currentPos = os.getFilePointer();
            os.writeBytes(largeBuf, largeBuf.length);
            try {
                BaseDirectoryTestCase.assertEquals((long)(currentPos + (long)largeBuf.length), (long)os.getFilePointer());
            }
            finally {
                os.close();
            }
        }
    }

    public void testIndexOutputToString() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            IndexOutput out = dir.createOutput("camelCase.txt", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertTrue((String)out.toString(), (boolean)out.toString().contains("camelCase.txt"));
            out.close();
        }
    }

    public void testDoubleCloseOutput() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            IndexOutput out = dir.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out.writeString("testing");
            out.close();
            out.close();
        }
    }

    public void testDoubleCloseInput() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            IndexOutput out = dir.createOutput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            out.writeString("testing");
            out.close();
            IndexInput in = dir.openInput("foobar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
            BaseDirectoryTestCase.assertEquals((Object)"testing", (Object)in.readString());
            in.close();
            in.close();
        }
    }

    public void testCreateTempOutput() throws Throwable {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            int iter;
            ArrayList<String> names = new ArrayList<String>();
            int iters = BaseDirectoryTestCase.atLeast(50);
            for (iter = 0; iter < iters; ++iter) {
                IndexOutput out = dir.createTempOutput("foo", "bar", BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                names.add(out.getName());
                out.writeVInt(iter);
                out.close();
            }
            for (iter = 0; iter < iters; ++iter) {
                IndexInput in = dir.openInput((String)names.get(iter), BaseDirectoryTestCase.newIOContext(BaseDirectoryTestCase.random()));
                BaseDirectoryTestCase.assertEquals((long)iter, (long)in.readVInt());
                in.close();
            }
            Set files = Arrays.stream(dir.listAll()).filter(file -> !ExtrasFS.isExtra(file)).collect(Collectors.toSet());
            BaseDirectoryTestCase.assertEquals(new HashSet(names), files);
        }
    }

    public void testCreateOutputForExistingFile() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            String name = "file";
            try (IndexOutput out = dir.createOutput(name, IOContext.DEFAULT);){
                assert (out != null);
            }
            BaseDirectoryTestCase.expectThrows(FileAlreadyExistsException.class, () -> {
                try (IndexOutput out = dir.createOutput(name, IOContext.DEFAULT);){
                    assert (out != null);
                }
            });
            dir.deleteFile(name);
            dir.createOutput(name, IOContext.DEFAULT).close();
        }
    }

    public void testSeekToEndOfFile() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            try (IndexOutput out = dir.createOutput("a", IOContext.DEFAULT);){
                for (int i = 0; i < 1024; ++i) {
                    out.writeByte((byte)0);
                }
            }
            try (IndexInput in = dir.openInput("a", IOContext.DEFAULT);){
                in.seek(100L);
                BaseDirectoryTestCase.assertEquals((long)100L, (long)in.getFilePointer());
                in.seek(1024L);
                BaseDirectoryTestCase.assertEquals((long)1024L, (long)in.getFilePointer());
            }
        }
    }

    public void testSeekBeyondEndOfFile() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            try (IndexOutput out = dir.createOutput("a", IOContext.DEFAULT);){
                for (int i = 0; i < 1024; ++i) {
                    out.writeByte((byte)0);
                }
            }
            try (IndexInput in = dir.openInput("a", IOContext.DEFAULT);){
                in.seek(100L);
                BaseDirectoryTestCase.assertEquals((long)100L, (long)in.getFilePointer());
                BaseDirectoryTestCase.expectThrows(EOFException.class, () -> in.seek(1025L));
            }
        }
    }

    public void testPendingDeletions() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.addVirusChecker(BaseDirectoryTestCase.createTempDir()));){
            String candidate;
            BaseDirectoryTestCase.assumeTrue("we can only install VirusCheckingFS on an FSDirectory", dir instanceof FSDirectory);
            FSDirectory fsDir = (FSDirectory)dir;
            do {
                candidate = IndexFileNames.segmentFileName((String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random(), 1, 6), (String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random()), (String)"test");
                try (IndexOutput out = dir.createOutput(candidate, IOContext.DEFAULT);){
                    out.getFilePointer();
                }
                fsDir.deleteFile(candidate);
            } while (fsDir.getPendingDeletions().size() <= 0);
            String fileName = candidate;
            BaseDirectoryTestCase.assertFalse((boolean)Arrays.asList(fsDir.listAll()).contains(fileName));
            BaseDirectoryTestCase.expectThrows(NoSuchFileException.class, () -> fsDir.fileLength(fileName));
            BaseDirectoryTestCase.expectThrows(NoSuchFileException.class, () -> fsDir.rename(fileName, "file2"));
            BaseDirectoryTestCase.expectThrows(NoSuchFileException.class, () -> fsDir.deleteFile(fileName));
            BaseDirectoryTestCase.expectThrowsAnyOf(Arrays.asList(NoSuchFileException.class, FileNotFoundException.class), () -> fsDir.openInput(fileName, IOContext.DEFAULT));
        }
    }

    public void testListAllIsSorted() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            int count = BaseDirectoryTestCase.atLeast(20);
            HashSet<String> names = new HashSet<String>();
            while (names.size() < count) {
                IndexOutput out;
                String name = IndexFileNames.segmentFileName((String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random(), 1, 6), (String)TestUtil.randomSimpleString(BaseDirectoryTestCase.random()), (String)"test");
                if (BaseDirectoryTestCase.random().nextInt(5) == 1) {
                    out = dir.createTempOutput(name, "foo", IOContext.DEFAULT);
                    names.add(out.getName());
                    out.close();
                    continue;
                }
                if (names.contains(name)) continue;
                out = dir.createOutput(name, IOContext.DEFAULT);
                names.add(out.getName());
                out.close();
            }
            Object[] actual = dir.listAll();
            Object[] expected = (String[])actual.clone();
            Arrays.sort(expected);
            BaseDirectoryTestCase.assertArrayEquals((Object[])expected, (Object[])actual);
        }
    }

    public void testDataTypes() throws IOException {
        long[] values = new long[]{43L, 12345L, 123456L, 1234567890L};
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testDataTypes"));){
            IndexOutput out = dir.createOutput("test", IOContext.DEFAULT);
            out.writeByte((byte)43);
            out.writeShort((short)12345);
            out.writeInt(1234567890);
            out.writeGroupVInts(values, 4);
            out.writeLong(1234567890123456789L);
            out.close();
            long[] restored = new long[4];
            IndexInput in = dir.openInput("test", IOContext.DEFAULT);
            BaseDirectoryTestCase.assertEquals((long)43L, (long)in.readByte());
            BaseDirectoryTestCase.assertEquals((long)12345L, (long)in.readShort());
            BaseDirectoryTestCase.assertEquals((long)1234567890L, (long)in.readInt());
            GroupVIntUtil.readGroupVInts((DataInput)in, (long[])restored, (int)4);
            BaseDirectoryTestCase.assertArrayEquals((long[])values, (long[])restored);
            BaseDirectoryTestCase.assertEquals((long)1234567890123456789L, (long)in.readLong());
            in.close();
        }
    }

    public void testGroupVIntOverflow() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testGroupVIntOverflow"));){
            int size = 32;
            long[] values = new long[32];
            long[] restore = new long[32];
            values[0] = 0x80000000L;
            for (int i = 0; i < 32; ++i) {
                if (!BaseDirectoryTestCase.random().nextBoolean()) continue;
                values[i] = values[0];
            }
            int limit = BaseDirectoryTestCase.random().nextInt(1, 32);
            IndexOutput out = dir.createOutput("test", IOContext.DEFAULT);
            out.writeGroupVInts(values, limit);
            out.close();
            try (IndexInput in = dir.openInput("test", IOContext.DEFAULT);){
                GroupVIntUtil.readGroupVInts((DataInput)in, (long[])restore, (int)limit);
                for (int i = 0; i < limit; ++i) {
                    BaseDirectoryTestCase.assertEquals((long)values[i], (long)restore[i]);
                }
            }
            values[0] = 0x100000000L;
            BaseDirectoryTestCase.assertThrows(ArithmeticException.class, () -> out.writeGroupVInts(values, 4));
        }
    }

    public void testGroupVInt() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testGroupVInt"));){
            this.doTestGroupVInt(dir, 5, 1, 6, 8);
            this.doTestGroupVInt(dir, BaseDirectoryTestCase.atLeast(100), 1, 31, 128);
        }
    }

    protected void doTestGroupVInt(Directory dir, int iterations, int minBpv, int maxBpv, int maxNumValues) throws IOException {
        long[] values = new long[maxNumValues];
        int[] numValuesArray = new int[iterations];
        IndexOutput groupVIntOut = dir.createOutput("group-varint", IOContext.DEFAULT);
        IndexOutput vIntOut = dir.createOutput("vint", IOContext.DEFAULT);
        for (int iter = 0; iter < iterations; ++iter) {
            int bpv = TestUtil.nextInt(BaseDirectoryTestCase.random(), minBpv, maxBpv);
            numValuesArray[iter] = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, maxNumValues);
            for (int j = 0; j < numValuesArray[iter]; ++j) {
                values[j] = RandomNumbers.randomIntBetween((Random)BaseDirectoryTestCase.random(), (int)0, (int)((int)PackedInts.maxValue((int)bpv)));
                vIntOut.writeVInt((int)values[j]);
            }
            groupVIntOut.writeGroupVInts(values, numValuesArray[iter]);
        }
        groupVIntOut.close();
        vIntOut.close();
        IndexInput groupVIntIn = dir.openInput("group-varint", IOContext.DEFAULT);
        IndexInput vIntIn = dir.openInput("vint", IOContext.DEFAULT);
        for (int iter = 0; iter < iterations; ++iter) {
            GroupVIntUtil.readGroupVInts((DataInput)groupVIntIn, (long[])values, (int)numValuesArray[iter]);
            for (int j = 0; j < numValuesArray[iter]; ++j) {
                BaseDirectoryTestCase.assertEquals((long)vIntIn.readVInt(), (long)values[j]);
            }
        }
        groupVIntIn.close();
        vIntIn.close();
        dir.deleteFile("group-varint");
        dir.deleteFile("vint");
    }

    public void testPrefetch() throws IOException {
        this.doTestPrefetch(0);
    }

    public void testPrefetchOnSlice() throws IOException {
        this.doTestPrefetch(TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 1024));
    }

    public void testUpdateReadAdvice() throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir("testUpdateReadAdvice"));){
            int totalLength = TestUtil.nextInt(BaseDirectoryTestCase.random(), 16384, 65536);
            byte[] arr = new byte[totalLength];
            BaseDirectoryTestCase.random().nextBytes(arr);
            try (IndexOutput out = dir.createOutput("temp.bin", IOContext.DEFAULT);){
                out.writeBytes(arr, arr.length);
            }
            try (IndexInput orig = dir.openInput("temp.bin", IOContext.DEFAULT);){
                int offset;
                int i;
                IndexInput in = BaseDirectoryTestCase.random().nextBoolean() ? orig.clone() : orig;
                in.updateReadAdvice((ReadAdvice)RandomPicks.randomFrom((Random)BaseDirectoryTestCase.random(), (Object[])ReadAdvice.values()));
                for (i = 0; i < totalLength; ++i) {
                    offset = TestUtil.nextInt(BaseDirectoryTestCase.random(), 0, (int)in.length() - 1);
                    in.seek((long)offset);
                    BaseDirectoryTestCase.assertEquals((long)arr[offset], (long)in.readByte());
                }
                for (i = 0; i < 10000; ++i) {
                    offset = TestUtil.nextInt(BaseDirectoryTestCase.random(), 0, (int)in.length() - 1);
                    in.seek((long)offset);
                    BaseDirectoryTestCase.assertEquals((long)arr[offset], (long)in.readByte());
                    if (!BaseDirectoryTestCase.random().nextBoolean()) continue;
                    in.updateReadAdvice((ReadAdvice)RandomPicks.randomFrom((Random)BaseDirectoryTestCase.random(), (Object[])ReadAdvice.values()));
                }
            }
        }
    }

    private void doTestPrefetch(int startOffset) throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            int totalLength = startOffset + TestUtil.nextInt(BaseDirectoryTestCase.random(), 16384, 65536);
            byte[] arr = new byte[totalLength];
            BaseDirectoryTestCase.random().nextBytes(arr);
            try (IndexOutput out = dir.createOutput("temp.bin", IOContext.DEFAULT);){
                out.writeBytes(arr, arr.length);
            }
            byte[] temp = new byte[2048];
            try (IndexInput orig = dir.openInput("temp.bin", IOContext.DEFAULT);){
                IndexInput in = startOffset == 0 ? orig.clone() : orig.slice("slice", (long)startOffset, (long)(totalLength - startOffset));
                block19: for (int i = 0; i < 10000; ++i) {
                    int offset = TestUtil.nextInt(BaseDirectoryTestCase.random(), 0, (int)in.length() - 1);
                    if (BaseDirectoryTestCase.random().nextBoolean()) {
                        long prefetchLength = TestUtil.nextLong(BaseDirectoryTestCase.random(), 1L, in.length() - (long)offset);
                        in.prefetch((long)offset, prefetchLength);
                    }
                    in.seek((long)offset);
                    BaseDirectoryTestCase.assertEquals((long)offset, (long)in.getFilePointer());
                    switch (BaseDirectoryTestCase.random().nextInt(100)) {
                        case 0: {
                            BaseDirectoryTestCase.assertEquals((long)arr[startOffset + offset], (long)in.readByte());
                            continue block19;
                        }
                        case 1: {
                            if (in.length() - (long)offset < 8L) continue block19;
                            BaseDirectoryTestCase.assertEquals((long)BitUtil.VH_LE_LONG.get(arr, startOffset + offset), (long)in.readLong());
                            continue block19;
                        }
                        default: {
                            int readLength = TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, (int)Math.min((long)temp.length, in.length() - (long)offset));
                            in.readBytes(temp, 0, readLength);
                            BaseDirectoryTestCase.assertArrayEquals((byte[])ArrayUtil.copyOfSubArray((byte[])arr, (int)(startOffset + offset), (int)(startOffset + offset + readLength)), (byte[])ArrayUtil.copyOfSubArray((byte[])temp, (int)0, (int)readLength));
                        }
                    }
                }
            }
        }
    }

    public void testIsLoaded() throws IOException {
        this.testIsLoaded(0);
    }

    public void testIsLoadedOnSlice() throws IOException {
        this.testIsLoaded(TestUtil.nextInt(BaseDirectoryTestCase.random(), 1, 1024));
    }

    private void testIsLoaded(int startOffset) throws IOException {
        try (Directory dir = this.getDirectory(BaseDirectoryTestCase.createTempDir());){
            Directory directory = FilterDirectory.unwrap((Directory)dir);
            if (directory instanceof MMapDirectory) {
                MMapDirectory mMapDirectory = (MMapDirectory)directory;
                mMapDirectory.setPreload(MMapDirectory.ALL_FILES);
            }
            int totalLength = startOffset + TestUtil.nextInt(BaseDirectoryTestCase.random(), 16384, 65536);
            byte[] arr = new byte[totalLength];
            BaseDirectoryTestCase.random().nextBytes(arr);
            try (IndexOutput out = dir.createOutput("temp.bin", IOContext.DEFAULT);){
                out.writeBytes(arr, arr.length);
            }
            try (IndexInput orig = dir.openInput("temp.bin", IOContext.DEFAULT);){
                IndexInput in = startOffset == 0 ? orig.clone() : orig.slice("slice", (long)startOffset, (long)(totalLength - startOffset));
                Optional loaded = in.isLoaded();
                if (FilterDirectory.unwrap((Directory)dir) instanceof MMapDirectory && !dir.getClass().getName().contains("DirectIO")) {
                    BaseDirectoryTestCase.assertTrue((boolean)loaded.isPresent());
                    BaseDirectoryTestCase.assertTrue((boolean)((Boolean)loaded.get()));
                } else {
                    BaseDirectoryTestCase.assertFalse((boolean)loaded.isPresent());
                }
            }
        }
    }
}

