/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.surround.query.SimpleTerm;

public class SrndPrefixQuery
extends SimpleTerm {
    private final String prefix;
    private final char truncator;

    public SrndPrefixQuery(String prefix, boolean quoted, char truncator) {
        super(quoted);
        this.prefix = prefix;
        this.truncator = truncator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public char getSuffixOperator() {
        return this.truncator;
    }

    public Term getLucenePrefixTerm(String fieldName) {
        return new Term(fieldName, this.getPrefix());
    }

    public String toStringUnquoted() {
        return this.getPrefix();
    }

    protected void suffixToString(StringBuilder r) {
        r.append(this.getSuffixOperator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        TermEnum enumerator = reader.terms(this.getLucenePrefixTerm(fieldName));
        boolean expanded = false;
        try {
            Term term;
            while ((term = enumerator.term()) != null && term.text().startsWith(this.getPrefix()) && term.field().equals(fieldName)) {
                mtv.visitMatchingTerm(term);
                expanded = true;
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
        }
        if (!expanded) {
            System.out.println("No terms in " + fieldName + " field for: " + this.toString());
        }
    }
}

