/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.queryParser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryParser.surround.query.SrndQuery;
import org.apache.lucene.search.Query;

public abstract class ComposedQuery
extends SrndQuery {
    private String opName;
    private List queries;
    private boolean operatorInfix;

    public ComposedQuery(List qs, boolean operatorInfix, String opName) {
        this.recompose(qs);
        this.operatorInfix = operatorInfix;
        this.opName = opName;
    }

    protected void recompose(List queries) {
        if (queries.size() < 2) {
            throw new AssertionError((Object)"Too few subqueries");
        }
        this.queries = queries;
    }

    public String getOperatorName() {
        return this.opName;
    }

    public Iterator getSubQueriesIterator() {
        return this.queries.listIterator();
    }

    public int getNrSubQueries() {
        return this.queries.size();
    }

    public SrndQuery getSubQuery(int qn) {
        return (SrndQuery)this.queries.get(qn);
    }

    public boolean isOperatorInfix() {
        return this.operatorInfix;
    }

    public List makeLuceneSubQueriesField(String fn, BasicQueryFactory qf) {
        ArrayList<Query> luceneSubQueries = new ArrayList<Query>();
        Iterator sqi = this.getSubQueriesIterator();
        while (sqi.hasNext()) {
            luceneSubQueries.add(((SrndQuery)sqi.next()).makeLuceneQueryField(fn, qf));
        }
        return luceneSubQueries;
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        if (this.isOperatorInfix()) {
            this.infixToString(r);
        } else {
            this.prefixToString(r);
        }
        this.weightToString(r);
        return r.toString();
    }

    protected String getPrefixSeparator() {
        return ", ";
    }

    protected String getBracketOpen() {
        return "(";
    }

    protected String getBracketClose() {
        return ")";
    }

    protected void infixToString(StringBuffer r) {
        Iterator sqi = this.getSubQueriesIterator();
        r.append(this.getBracketOpen());
        if (sqi.hasNext()) {
            r.append(sqi.next().toString());
            while (sqi.hasNext()) {
                r.append(" ");
                r.append(this.getOperatorName());
                r.append(" ");
                r.append(sqi.next().toString());
            }
        }
        r.append(this.getBracketClose());
    }

    protected void prefixToString(StringBuffer r) {
        Iterator sqi = this.getSubQueriesIterator();
        r.append(this.getOperatorName());
        r.append(this.getBracketOpen());
        if (sqi.hasNext()) {
            r.append(sqi.next().toString());
            while (sqi.hasNext()) {
                r.append(this.getPrefixSeparator());
                r.append(sqi.next().toString());
            }
        }
        r.append(this.getBracketClose());
    }

    public boolean isFieldsSubQueryAcceptable() {
        Iterator sqi = this.getSubQueriesIterator();
        while (sqi.hasNext()) {
            if (!((SrndQuery)sqi.next()).isFieldsSubQueryAcceptable()) continue;
            return true;
        }
        return false;
    }
}

