/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.surround.query.SimpleTerm;

public class SrndTermQuery
extends SimpleTerm {
    private final String termText;

    public SrndTermQuery(String termText, boolean quoted) {
        super(quoted);
        this.termText = termText;
    }

    public String getTermText() {
        return this.termText;
    }

    public Term getLuceneTerm(String fieldName) {
        return new Term(fieldName, this.getTermText());
    }

    public String toStringUnquoted() {
        return this.getTermText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        TermEnum enumerator = reader.terms(this.getLuceneTerm(fieldName));
        try {
            Term it = enumerator.term();
            if (it != null && it.text().equals(this.getTermText()) && it.field().equals(fieldName)) {
                mtv.visitMatchingTerm(it);
            } else {
                System.out.println("No term in " + fieldName + " field for: " + this.toString());
            }
        }
        finally {
            enumerator.close();
        }
    }
}

