/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.document.NRTSuggesterBuilder;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

final class CompletionFieldsConsumer
extends FieldsConsumer {
    private final String delegatePostingsFormatName;
    private final Map<String, Long> seenFields = new HashMap<String, Long>();
    private final SegmentWriteState state;
    private IndexOutput dictOut;
    private FieldsConsumer delegateFieldsConsumer;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompletionFieldsConsumer(PostingsFormat delegatePostingsFormat, SegmentWriteState state) throws IOException {
        this.delegatePostingsFormatName = delegatePostingsFormat.getName();
        this.state = state;
        String dictFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"lkp");
        boolean success = false;
        try {
            this.delegateFieldsConsumer = delegatePostingsFormat.fieldsConsumer(state);
            this.dictOut = state.directory.createOutput(dictFile, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.dictOut, (String)"completion", (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.dictOut, this.delegateFieldsConsumer});
            throw throwable;
        }
    }

    public void write(Fields fields) throws IOException {
        this.delegateFieldsConsumer.write(fields);
        for (String field : fields) {
            BytesRef term;
            CompletionTermWriter termWriter = new CompletionTermWriter();
            Terms terms = fields.terms(field);
            TermsEnum termsEnum = terms.iterator();
            while ((term = termsEnum.next()) != null) {
                termWriter.write(term, termsEnum);
            }
            long filePointer = this.dictOut.getFilePointer();
            if (!termWriter.finish(this.dictOut)) continue;
            this.seenFields.put(field, filePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        String indexFile = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)"cmp");
        boolean success = false;
        try {
            try (IndexOutput indexOut = this.state.directory.createOutput(indexFile, this.state.context);){
                this.delegateFieldsConsumer.close();
                CodecUtil.writeIndexHeader((DataOutput)indexOut, (String)"completion", (int)1, (byte[])this.state.segmentInfo.getId(), (String)this.state.segmentSuffix);
                indexOut.writeString(this.delegatePostingsFormatName);
                indexOut.writeVInt(this.seenFields.size());
                for (Map.Entry<String, Long> seenField : this.seenFields.entrySet()) {
                    FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(seenField.getKey());
                    indexOut.writeVInt(fieldInfo.number);
                    indexOut.writeVLong(seenField.getValue().longValue());
                }
                CodecUtil.writeFooter((IndexOutput)indexOut);
                CodecUtil.writeFooter((IndexOutput)this.dictOut);
                IOUtils.close((Closeable[])new Closeable[]{this.dictOut});
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.dictOut, this.delegateFieldsConsumer});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.dictOut, this.delegateFieldsConsumer});
    }

    private static class CompletionTermWriter {
        private PostingsEnum postingsEnum = null;
        private int docCount = 0;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final NRTSuggesterBuilder builder = new NRTSuggesterBuilder();

        public boolean finish(IndexOutput output) throws IOException {
            boolean stored = this.builder.store((DataOutput)output);
            assert (stored || this.docCount == 0) : "the FST is null but docCount is != 0 actual value: [" + this.docCount + "]";
            return stored;
        }

        public void write(BytesRef term, TermsEnum termsEnum) throws IOException {
            this.postingsEnum = termsEnum.postings(null, this.postingsEnum, 88);
            this.builder.startTerm(term);
            int docFreq = 0;
            while (this.postingsEnum.nextDoc() != Integer.MAX_VALUE) {
                int docID = this.postingsEnum.docID();
                for (int i = 0; i < this.postingsEnum.freq(); ++i) {
                    this.postingsEnum.nextPosition();
                    assert (this.postingsEnum.getPayload() != null);
                    BytesRef payload = this.postingsEnum.getPayload();
                    ByteArrayDataInput input = new ByteArrayDataInput(payload.bytes, payload.offset, payload.length);
                    int len = input.readVInt();
                    this.scratch.grow(len);
                    this.scratch.setLength(len);
                    input.readBytes(this.scratch.bytes(), 0, this.scratch.length());
                    this.builder.addEntry(docID, this.scratch.get(), input.readVLong() - 1L);
                }
                this.docCount = Math.max(this.docCount, ++docFreq + 1);
            }
            this.builder.finishTerm();
        }
    }
}

