/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.search.spell.TRStringDistance;
import org.apache.lucene.store.Directory;

public class SpellChecker {
    public static final String F_WORD = "word";
    Directory spellindex;
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private IndexReader reader;
    float min = 0.5f;

    public void setSpellIndex(Directory spellindex) {
        this.spellindex = spellindex;
    }

    public void setAccuraty(float min) {
        this.min = min;
    }

    public SpellChecker(Directory gramIndex) {
        this.setSpellIndex(gramIndex);
    }

    public String[] suggestSimilar(String word, int num_sug) throws IOException {
        return this.suggestSimilar(word, num_sug, null, null, false);
    }

    public String[] suggestSimilar(String word, int num_sug, IndexReader ir, String field, boolean morePopular) throws IOException {
        int goalFreq;
        TRStringDistance sd = new TRStringDistance(word);
        int lengthWord = word.length();
        int n = goalFreq = morePopular && ir != null ? ir.docFreq(new Term(field, word)) : 0;
        if (!morePopular && goalFreq > 0) {
            return new String[]{word};
        }
        BooleanQuery query = new BooleanQuery();
        for (int ng = this.getMin(lengthWord); ng <= this.getMax(lengthWord); ++ng) {
            String key = "gram" + ng;
            String[] grams = SpellChecker.formGrams(word, ng);
            if (grams.length == 0) continue;
            if (this.bStart > 0.0f) {
                SpellChecker.add(query, "start" + ng, grams[0], this.bStart);
            }
            if (this.bEnd > 0.0f) {
                SpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
            }
            for (int i = 0; i < grams.length; ++i) {
                SpellChecker.add(query, key, grams[i]);
            }
        }
        IndexSearcher searcher = new IndexSearcher(this.spellindex);
        Hits hits = searcher.search((Query)query);
        SuggestWordQueue sugqueue = new SuggestWordQueue(num_sug);
        int stop = Math.min(hits.length(), 10 * num_sug);
        SuggestWord sugword = new SuggestWord();
        for (int i = 0; i < stop; ++i) {
            sugword.string = hits.doc(i).get(F_WORD);
            if (sugword.string.equals(word)) continue;
            sugword.score = 1.0f - (float)sd.getDistance(sugword.string) / (float)Math.min(sugword.string.length(), lengthWord);
            if (sugword.score < this.min) continue;
            if (ir != null) {
                sugword.freq = ir.docFreq(new Term(field, sugword.string));
                if (morePopular && goalFreq > sugword.freq || sugword.freq < 1) continue;
            }
            sugqueue.insert(sugword);
            if (sugqueue.size() == num_sug) {
                this.min = ((SuggestWord)sugqueue.top()).score;
            }
            sugword = new SuggestWord();
        }
        String[] list = new String[sugqueue.size()];
        for (int i = sugqueue.size() - 1; i >= 0; --i) {
            list[i] = ((SuggestWord)sugqueue.pop()).string;
        }
        searcher.close();
        return list;
    }

    private static void add(BooleanQuery q, String k, String v, float boost) {
        TermQuery tq = new TermQuery(new Term(k, v));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String k, String v) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(k, v)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    public void clearIndex() throws IOException {
        IndexReader.unlock((Directory)this.spellindex);
        IndexWriter writer = new IndexWriter(this.spellindex, null, true);
        writer.close();
    }

    public boolean exist(String word) throws IOException {
        if (this.reader == null) {
            this.reader = IndexReader.open((Directory)this.spellindex);
        }
        return this.reader.docFreq(new Term(F_WORD, word)) > 0;
    }

    public void indexDictionary(Dictionary dict) throws IOException {
        IndexReader.unlock((Directory)this.spellindex);
        IndexWriter writer = new IndexWriter(this.spellindex, (Analyzer)new WhitespaceAnalyzer(), !IndexReader.indexExists((Directory)this.spellindex));
        writer.setMergeFactor(300);
        writer.setMaxBufferedDocs(150);
        Iterator iter = dict.getWordsIterator();
        while (iter.hasNext()) {
            String word = (String)iter.next();
            int len = word.length();
            if (len < 3 || this.exist(word)) continue;
            Document doc = SpellChecker.createDocument(word, this.getMin(len), this.getMax(len));
            writer.addDocument(doc);
        }
        writer.optimize();
        writer.close();
        this.reader.close();
        this.reader = null;
    }

    private int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    private static Document createDocument(String text, int ng1, int ng2) {
        Document doc = new Document();
        doc.add(new Field(F_WORD, text, Field.Store.YES, Field.Index.UN_TOKENIZED));
        SpellChecker.addGram(text, doc, ng1, ng2);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                doc.add(new Field(key, gram, Field.Store.YES, Field.Index.UN_TOKENIZED));
                if (i == 0) {
                    doc.add(new Field("start" + ng, gram, Field.Store.YES, Field.Index.UN_TOKENIZED));
                }
                end = gram;
            }
            if (end == null) continue;
            doc.add(new Field("end" + ng, end, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
    }

    protected void finalize() throws Throwable {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

