/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial3d.Geo3DPoint;
import org.apache.lucene.spatial3d.Geo3DUtil;
import org.apache.lucene.spatial3d.geom.BasePlanetObject;
import org.apache.lucene.spatial3d.geom.GeoArea;
import org.apache.lucene.spatial3d.geom.GeoAreaFactory;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;

final class PointInGeo3DShapeQuery
extends Query {
    final String field;
    final GeoShape shape;

    public PointInGeo3DShapeQuery(String field, GeoShape shape) {
        BasePlanetObject planetObject;
        this.field = field;
        this.shape = shape;
        if (shape instanceof BasePlanetObject && !(planetObject = (BasePlanetObject)((Object)shape)).getPlanetModel().equals(PlanetModel.WGS84)) {
            throw new IllegalArgumentException("this qurey requires PlanetModel.WGS84, but got: " + planetObject.getPlanetModel());
        }
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                final double planetMax = PlanetModel.WGS84.getMaximumMagnitude();
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc());
                values.intersect(PointInGeo3DShapeQuery.this.field, new PointValues.IntersectVisitor(){

                    public void visit(int docID) {
                        result.add(docID);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        double z;
                        double y;
                        assert (packedValue.length == 12);
                        double x = Geo3DPoint.decodeDimension(packedValue, 0);
                        if (PointInGeo3DShapeQuery.this.shape.isWithin(x, y = Geo3DPoint.decodeDimension(packedValue, 4), z = Geo3DPoint.decodeDimension(packedValue, 8))) {
                            result.add(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        double xMin = Geo3DUtil.decodeValueMin(planetMax, NumericUtils.sortableBytesToInt((byte[])minPackedValue, (int)0));
                        double xMax = Geo3DUtil.decodeValueMax(planetMax, NumericUtils.sortableBytesToInt((byte[])maxPackedValue, (int)0));
                        double yMin = Geo3DUtil.decodeValueMin(planetMax, NumericUtils.sortableBytesToInt((byte[])minPackedValue, (int)4));
                        double yMax = Geo3DUtil.decodeValueMax(planetMax, NumericUtils.sortableBytesToInt((byte[])maxPackedValue, (int)4));
                        double zMin = Geo3DUtil.decodeValueMin(planetMax, NumericUtils.sortableBytesToInt((byte[])minPackedValue, (int)8));
                        double zMax = Geo3DUtil.decodeValueMax(planetMax, NumericUtils.sortableBytesToInt((byte[])maxPackedValue, (int)8));
                        assert (xMin <= xMax);
                        assert (yMin <= yMax);
                        assert (zMin <= zMax);
                        GeoArea xyzSolid = GeoAreaFactory.makeGeoArea(PlanetModel.WGS84, xMin, xMax, yMin, yMax, zMin, zMax);
                        switch (xyzSolid.getRelationship(PointInGeo3DShapeQuery.this.shape)) {
                            case 0: {
                                return PointValues.Relation.CELL_INSIDE_QUERY;
                            }
                            case 2: {
                                return PointValues.Relation.CELL_CROSSES_QUERY;
                            }
                            case 1: {
                                return PointValues.Relation.CELL_CROSSES_QUERY;
                            }
                            case 3: {
                                return PointValues.Relation.CELL_OUTSIDE_QUERY;
                            }
                        }
                        assert (false);
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                });
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public GeoShape getShape() {
        return this.shape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PointInGeo3DShapeQuery that = (PointInGeo3DShapeQuery)((Object)o);
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.shape.equals(that.shape);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.shape.hashCode();
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(" Shape: ");
        sb.append(this.shape);
        return sb.toString();
    }
}

