/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.document;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.spatial.geopoint.document.GeoPointTokenStream;
import org.apache.lucene.spatial.util.GeoEncodingUtils;
import org.apache.lucene.spatial.util.GeoUtils;

public final class GeoPointField
extends Field {
    public static final int PRECISION_STEP = 9;
    @Deprecated
    public static final FieldType NUMERIC_TYPE_NOT_STORED = new FieldType();
    @Deprecated
    public static final FieldType NUMERIC_TYPE_STORED;
    public static final FieldType PREFIX_TYPE_NOT_STORED;
    public static final FieldType PREFIX_TYPE_STORED;

    public GeoPointField(String name, double lat, double lon, Field.Store stored) {
        this(name, lat, lon, GeoPointField.getFieldType(stored));
    }

    @Deprecated
    public GeoPointField(String name, double lat, double lon, TermEncoding termEncoding, Field.Store stored) {
        this(name, lat, lon, GeoPointField.getFieldType(termEncoding, stored));
    }

    public GeoPointField(String name, double lat, double lon, FieldType type) {
        super(name, type);
        GeoUtils.checkLatitude(lat);
        GeoUtils.checkLongitude(lon);
        if (type.indexOptions() == IndexOptions.NONE && !type.stored()) {
            throw new IllegalArgumentException("type.indexOptions() is set to NONE but type.stored() is false");
        }
        if (type.indexOptions() == IndexOptions.DOCS) {
            if (type.docValuesType() != DocValuesType.SORTED_NUMERIC) {
                throw new IllegalArgumentException("type.docValuesType() must be SORTED_NUMERIC but got " + type.docValuesType());
            }
            if (type.numericType() != null && type.numericType() != FieldType.LegacyNumericType.LONG) {
                throw new IllegalArgumentException("type.numericType() must be LONG but got " + type.numericType());
            }
        } else {
            throw new IllegalArgumentException("type.indexOptions() must be one of NONE or DOCS but got " + type.indexOptions());
        }
        this.fieldsData = GeoEncodingUtils.mortonHash(lat, lon);
    }

    private static FieldType getFieldType(Field.Store stored) {
        return GeoPointField.getFieldType(TermEncoding.PREFIX, stored);
    }

    @Deprecated
    private static FieldType getFieldType(TermEncoding termEncoding, Field.Store stored) {
        if (stored == Field.Store.YES) {
            return termEncoding == TermEncoding.PREFIX ? PREFIX_TYPE_STORED : NUMERIC_TYPE_STORED;
        }
        if (stored == Field.Store.NO) {
            return termEncoding == TermEncoding.PREFIX ? PREFIX_TYPE_NOT_STORED : NUMERIC_TYPE_NOT_STORED;
        }
        throw new IllegalArgumentException("stored option must be NO or YES but got " + stored);
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        if (this.fieldType().indexOptions() == IndexOptions.NONE) {
            return null;
        }
        if (this.type.numericType() != null) {
            return super.tokenStream(analyzer, reuse);
        }
        if (!(reuse instanceof GeoPointTokenStream)) {
            reuse = new GeoPointTokenStream();
        }
        GeoPointTokenStream gpts = (GeoPointTokenStream)reuse;
        gpts.setGeoCode(((Number)this.fieldsData).longValue());
        return reuse;
    }

    public double getLat() {
        return GeoEncodingUtils.mortonUnhashLat((Long)this.fieldsData);
    }

    public double getLon() {
        return GeoEncodingUtils.mortonUnhashLon((Long)this.fieldsData);
    }

    public String toString() {
        if (this.fieldsData == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(GeoEncodingUtils.mortonUnhashLat((Long)this.fieldsData));
        sb.append(',');
        sb.append(GeoEncodingUtils.mortonUnhashLon((Long)this.fieldsData));
        return sb.toString();
    }

    static {
        NUMERIC_TYPE_NOT_STORED.setTokenized(false);
        NUMERIC_TYPE_NOT_STORED.setOmitNorms(true);
        NUMERIC_TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        NUMERIC_TYPE_NOT_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        NUMERIC_TYPE_NOT_STORED.setNumericType(FieldType.LegacyNumericType.LONG);
        NUMERIC_TYPE_NOT_STORED.setNumericPrecisionStep(9);
        NUMERIC_TYPE_NOT_STORED.freeze();
        NUMERIC_TYPE_STORED = new FieldType();
        NUMERIC_TYPE_STORED.setTokenized(false);
        NUMERIC_TYPE_STORED.setOmitNorms(true);
        NUMERIC_TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        NUMERIC_TYPE_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        NUMERIC_TYPE_STORED.setNumericType(FieldType.LegacyNumericType.LONG);
        NUMERIC_TYPE_STORED.setNumericPrecisionStep(9);
        NUMERIC_TYPE_STORED.setStored(true);
        NUMERIC_TYPE_STORED.freeze();
        PREFIX_TYPE_NOT_STORED = new FieldType();
        PREFIX_TYPE_NOT_STORED.setTokenized(false);
        PREFIX_TYPE_NOT_STORED.setOmitNorms(true);
        PREFIX_TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        PREFIX_TYPE_NOT_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        PREFIX_TYPE_NOT_STORED.freeze();
        PREFIX_TYPE_STORED = new FieldType();
        PREFIX_TYPE_STORED.setTokenized(false);
        PREFIX_TYPE_STORED.setOmitNorms(true);
        PREFIX_TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        PREFIX_TYPE_STORED.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        PREFIX_TYPE_STORED.setStored(true);
        PREFIX_TYPE_STORED.freeze();
    }

    public static enum TermEncoding {
        PREFIX,
        NUMERIC;

    }
}

