/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.util.SloppyMath;

public final class GeoUtils {
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;
    public static final double EARTH_MEAN_RADIUS_METERS = 6371008.7714;
    static final double PIO2 = 1.5707963267948966;

    private GeoUtils() {
    }

    public static void checkLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + latitude + "; must be between " + -90.0 + " and " + 90.0);
        }
    }

    public static void checkLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + longitude + "; must be between " + -180.0 + " and " + 180.0);
        }
    }

    public static GeoRect circleToBBox(double centerLat, double centerLon, double radiusMeters) {
        double maxLon;
        double minLon;
        double radLat = Math.PI / 180 * centerLat;
        double radLon = Math.PI / 180 * centerLon;
        double radDistance = radiusMeters / 6371008.7714;
        double minLat = radLat - radDistance;
        double maxLat = radLat + radDistance;
        if (minLat > -1.5707963267948966 && maxLat < 1.5707963267948966) {
            double deltaLon = SloppyMath.asin((double)(GeoUtils.sloppySin(radDistance) / SloppyMath.cos((double)radLat)));
            minLon = radLon - deltaLon;
            if (minLon < -Math.PI) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > Math.PI) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, -1.5707963267948966);
            maxLat = Math.min(maxLat, 1.5707963267948966);
            minLon = -Math.PI;
            maxLon = Math.PI;
        }
        return new GeoRect(57.29577951308232 * minLat, 57.29577951308232 * maxLat, 57.29577951308232 * minLon, 57.29577951308232 * maxLon);
    }

    public static GeoRect polyToBBox(double[] polyLats, double[] polyLons) {
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < polyLats.length; ++i) {
            GeoUtils.checkLatitude(polyLats[i]);
            GeoUtils.checkLongitude(polyLons[i]);
            minLat = Math.min(polyLats[i], minLat);
            maxLat = Math.max(polyLats[i], maxLat);
            minLon = Math.min(polyLons[i], minLon);
            maxLon = Math.max(polyLons[i], maxLon);
        }
        return new GeoRect(Math.max(minLat - 1.0E-6, -90.0), Math.min(maxLat + 1.0E-6, 90.0), Math.max(minLon - 1.0E-6, -180.0), Math.min(maxLon + 1.0E-6, 180.0));
    }

    static double sloppySin(double a) {
        return SloppyMath.cos((double)(a - 1.5707963267948966));
    }

    static double sloppyTan(double a) {
        return GeoUtils.sloppySin(a) / SloppyMath.cos((double)a);
    }
}

