/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.spatial.util.GeoDistanceUtils;
import org.apache.lucene.spatial.util.GeoProjectionUtils;
import org.apache.lucene.util.SloppyMath;

public class GeoRelationUtils {
    private GeoRelationUtils() {
    }

    public static boolean pointInRectPrecise(double lat, double lon, double minLat, double maxLat, double minLon, double maxLon) {
        return lat >= minLat && lat <= maxLat && lon >= minLon && lon <= maxLon;
    }

    public static boolean pointInPolygon(double[] polyLats, double[] polyLons, double lat, double lon) {
        assert (polyLats.length == polyLons.length);
        boolean inPoly = false;
        for (int i = 1; i < polyLats.length; ++i) {
            if (!(polyLons[i] <= lon && polyLons[i - 1] >= lon) && (!(polyLons[i - 1] <= lon) || !(polyLons[i] >= lon)) || !(polyLats[i] + (lon - polyLons[i]) / (polyLons[i - 1] - polyLons[i]) * (polyLats[i - 1] - polyLats[i]) <= lat)) continue;
            inPoly = !inPoly;
        }
        return inPoly;
    }

    private static boolean rectDisjoint(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return aMaxLon < bMinLon || aMinLon > bMaxLon || aMaxLat < bMinLat || aMinLat > bMaxLat;
    }

    public static boolean rectWithin(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return !(aMinLon < bMinLon || aMinLat < bMinLat || aMaxLon > bMaxLon || aMaxLat > bMaxLat);
    }

    public static boolean rectCrosses(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return !GeoRelationUtils.rectDisjoint(aMinLat, aMaxLat, aMinLon, aMaxLon, bMinLat, bMaxLat, bMinLon, bMaxLon) && !GeoRelationUtils.rectWithin(aMinLat, aMaxLat, aMinLon, aMaxLon, bMinLat, bMaxLat, bMinLon, bMaxLon);
    }

    public static boolean rectIntersects(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return !(aMaxLon < bMinLon || aMinLon > bMaxLon || aMaxLat < bMinLat || aMinLat > bMaxLat);
    }

    public static boolean rectCrossesPolyPrecise(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double[] shapeLat, double[] shapeLon, double sMinLat, double sMaxLat, double sMinLon, double sMaxLon) {
        if (GeoRelationUtils.rectDisjoint(rMinLat, rMaxLat, rMinLon, rMaxLon, sMinLat, sMaxLat, sMinLon, sMaxLon)) {
            return false;
        }
        return GeoRelationUtils.rectCrossesPoly(rMinLat, rMaxLat, rMinLon, rMaxLon, shapeLat, shapeLon);
    }

    public static boolean rectCrossesPolyApprox(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double[] shapeLat, double[] shapeLon, double sMinLat, double sMaxLat, double sMinLon, double sMaxLon) {
        if (GeoRelationUtils.rectDisjoint(rMinLat, rMaxLat, rMinLon, rMaxLon, sMinLat, sMaxLat, sMinLon, sMaxLon)) {
            return false;
        }
        int polyLength = shapeLon.length - 1;
        for (int p = 0; p < polyLength; p = (int)((short)(p + 1))) {
            if (!GeoRelationUtils.lineCrossesRect(shapeLat[p], shapeLon[p], shapeLat[p + 1], shapeLon[p + 1], rMinLat, rMaxLat, rMinLon, rMaxLon)) continue;
            return true;
        }
        return false;
    }

    private static boolean rectCrossesPoly(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double[] shapeLats, double[] shapeLons) {
        double[][] bbox = new double[][]{{rMinLon, rMinLat}, {rMaxLon, rMinLat}, {rMaxLon, rMaxLat}, {rMinLon, rMaxLat}, {rMinLon, rMinLat}};
        int polyLength = shapeLons.length - 1;
        for (int b = 0; b < 4; b = (int)((short)(b + 1))) {
            double a1 = bbox[b + 1][1] - bbox[b][1];
            double b1 = bbox[b][0] - bbox[b + 1][0];
            double c1 = a1 * bbox[b + 1][0] + b1 * bbox[b + 1][1];
            for (int p = 0; p < polyLength; ++p) {
                boolean touching;
                double b2 = shapeLons[p] - shapeLons[p + 1];
                double a2 = shapeLats[p + 1] - shapeLats[p];
                double d = a1 * b2 - a2 * b1;
                if (d == 0.0) continue;
                double c2 = a2 * shapeLons[p + 1] + b2 * shapeLats[p + 1];
                double s = 1.0 / d * (b2 * c1 - b1 * c2);
                double t = 1.0 / d * (a1 * c2 - a2 * c1);
                double x00 = StrictMath.min(bbox[b][0], bbox[b + 1][0]) - 1.0E-6;
                double x01 = StrictMath.max(bbox[b][0], bbox[b + 1][0]) + 1.0E-6;
                double y00 = StrictMath.min(bbox[b][1], bbox[b + 1][1]) - 1.0E-6;
                double y01 = StrictMath.max(bbox[b][1], bbox[b + 1][1]) + 1.0E-6;
                double x10 = StrictMath.min(shapeLons[p], shapeLons[p + 1]) - 1.0E-6;
                double x11 = StrictMath.max(shapeLons[p], shapeLons[p + 1]) + 1.0E-6;
                double y10 = StrictMath.min(shapeLats[p], shapeLats[p + 1]) - 1.0E-6;
                double y11 = StrictMath.max(shapeLats[p], shapeLats[p + 1]) + 1.0E-6;
                boolean bl = touching = x00 == s && y00 == t || x01 == s && y01 == t || x10 == s && y10 == t || x11 == s && y11 == t;
                if (touching || x00 > s || x01 < s || y00 > t || y01 < t || x10 > s || x11 < s || y10 > t || y11 < t) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean lineCrossesRect(double aLat1, double aLon1, double aLat2, double aLon2, double rMinLat, double rMaxLat, double rMinLon, double rMaxLon) {
        if (GeoRelationUtils.pointInRectPrecise(aLat1, aLon1, rMinLat, rMaxLat, rMinLon, rMaxLon) ? !GeoRelationUtils.pointInRectPrecise(aLat2, aLon2, rMinLat, rMaxLat, rMinLon, rMaxLon) : GeoRelationUtils.pointInRectPrecise(aLat2, aLon2, rMinLat, rMaxLat, rMinLon, rMaxLon)) {
            return true;
        }
        return GeoRelationUtils.lineCrossesLine(aLat1, aLon1, aLat2, aLon2, rMinLat, rMinLon, rMaxLat, rMaxLon) || GeoRelationUtils.lineCrossesLine(aLat1, aLon1, aLat2, aLon2, rMaxLat, rMinLon, rMinLat, rMaxLon);
    }

    private static boolean lineCrossesLine(double aLat1, double aLon1, double aLat2, double aLon2, double bLat1, double bLon1, double bLat2, double bLon2) {
        double aX2X1d = aLon2 - aLon1;
        double aY2Y1d = aLat2 - aLat1;
        double bX2X1d = bLon2 - bLon1;
        double bY2Y1d = bLat2 - bLat1;
        double t1B = aX2X1d * (bLat2 - aLat1) - aY2Y1d * (bLon2 - aLon1);
        double test1 = (aX2X1d * (bLat1 - aLat1) - aY2Y1d * (bLon1 - aLon1)) * t1B;
        double t2B = bX2X1d * (aLat2 - bLat1) - bY2Y1d * (aLon2 - bLon1);
        double test2 = (bX2X1d * (aLat1 - bLat1) - bY2Y1d * (aLon1 - bLon1)) * t2B;
        if (test1 < 0.0 && test2 < 0.0) {
            return true;
        }
        if (test1 == 0.0 || test2 == 0.0) {
            if (aLon1 == aLon2 || bLon1 == bLon2) {
                double minAy = Math.min(aLat1, aLat2);
                double maxAy = Math.max(aLat1, aLat2);
                double minBy = Math.min(bLat1, bLat2);
                double maxBy = Math.max(bLat1, bLat2);
                return !(minBy >= maxAy) && !(maxBy <= minAy);
            }
            double minAx = Math.min(aLon1, aLon2);
            double maxAx = Math.max(aLon1, aLon2);
            double minBx = Math.min(bLon1, bLon2);
            double maxBx = Math.max(bLon1, bLon2);
            return !(minBx >= maxAx) && !(maxBx <= minAx);
        }
        return false;
    }

    public static boolean rectWithinPolyPrecise(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double[] shapeLats, double[] shapeLons, double sMinLat, double sMaxLat, double sMinLon, double sMaxLon) {
        return !GeoRelationUtils.rectCrossesPolyPrecise(rMinLat, rMaxLat, rMinLon, rMaxLon, shapeLats, shapeLons, sMinLat, sMaxLat, sMinLon, sMaxLon) && GeoRelationUtils.pointInPolygon(shapeLats, shapeLons, rMinLat, rMinLon) && GeoRelationUtils.pointInPolygon(shapeLats, shapeLons, rMinLat, rMaxLon) && GeoRelationUtils.pointInPolygon(shapeLats, shapeLons, rMaxLat, rMaxLon) && GeoRelationUtils.pointInPolygon(shapeLats, shapeLons, rMaxLat, rMinLon);
    }

    public static boolean rectWithinPolyApprox(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double[] shapeLats, double[] shapeLons, double sMinLat, double sMaxLat, double sMinLon, double sMaxLon) {
        if (GeoRelationUtils.rectCrosses(rMinLat, rMaxLat, rMinLon, rMaxLon, sMinLat, sMaxLat, sMinLon, sMaxLon)) {
            return false;
        }
        return !GeoRelationUtils.rectCrossesPolyApprox(rMinLat, rMaxLat, rMinLon, rMaxLon, shapeLats, shapeLons, sMinLat, sMaxLat, sMinLon, sMaxLon) && GeoRelationUtils.pointInPolygon(shapeLats, shapeLons, rMinLat, rMinLon);
    }

    private static boolean rectAnyCornersInCircle(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double centerLat, double centerLon, double radiusMeters, boolean approx) {
        if (approx) {
            return GeoRelationUtils.rectAnyCornersInCircleSloppy(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, radiusMeters);
        }
        double w = Math.abs(rMaxLon - rMinLon);
        if (w <= 90.0) {
            return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMinLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMinLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMaxLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMaxLon) <= radiusMeters;
        }
        double p1 = rMinLon + (w /= 4.0);
        double p2 = p1 + w;
        double p3 = p2 + w;
        return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMinLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMinLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)p1) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)p1) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)p2) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)p2) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)p3) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)p3) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMaxLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMaxLon) <= radiusMeters;
    }

    private static boolean rectAnyCornersInCircleSloppy(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double centerLat, double centerLon, double radiusMeters) {
        return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMinLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMinLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMaxLon) <= radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMaxLon) <= radiusMeters;
    }

    private static boolean rectAnyCornersOutsideCircle(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double centerLat, double centerLon, double radiusMeters, boolean approx) {
        if (approx) {
            return GeoRelationUtils.rectAnyCornersOutsideCircleSloppy(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, radiusMeters);
        }
        if (Math.abs(rMaxLon - rMinLon) <= 70.0) {
            return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMinLon) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMinLon) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMaxLon) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMaxLon) > radiusMeters;
        }
        return GeoRelationUtils.rectCrossesOblateCircle(centerLat, centerLon, radiusMeters, rMinLat, rMaxLat, rMinLon, rMaxLon);
    }

    private static boolean rectCrossesOblateCircle(double centerLat, double centerLon, double radiusMeters, double rMinLat, double rMaxLat, double rMinLon, double rMaxLon) {
        double w = Math.abs(rMaxLon - rMinLon);
        int segs = (int)Math.ceil(w / 45.0);
        w /= (double)segs;
        int i = 1;
        double p1 = rMinLon;
        double[] pt = new double[2];
        do {
            double midLon;
            double d2;
            double maxLon = i == segs ? rMaxLon : p1 + w;
            double d1 = SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)p1);
            if (d1 > radiusMeters || (d2 = SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)maxLon)) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)p1) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)maxLon) > radiusMeters) {
                return true;
            }
            if ((rMaxLat > 88.0 || rMinLat < -88.0) && (pt = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(rMinLat, p1, GeoProjectionUtils.bearingGreatCircle(rMinLat, p1, rMaxLat, p1), radiusMeters - d1, pt))[1] < rMinLat || pt[1] < rMaxLat || (pt = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(rMinLat, maxLon, GeoProjectionUtils.bearingGreatCircle(rMinLat, maxLon, rMaxLat, maxLon), radiusMeters - d2, pt))[1] < rMinLat || pt[1] < rMaxLat || (pt = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(rMinLat, maxLon, GeoProjectionUtils.bearingGreatCircle(rMinLat, maxLon, rMaxLat, midLon = p1 + 0.5 * (maxLon - p1)), radiusMeters - SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)midLon), pt))[1] < rMinLat || !(pt[1] < rMaxLat)) {
                return true;
            }
            p1 += w;
        } while ((i = (int)((short)(i + 1))) <= segs);
        return false;
    }

    private static boolean rectAnyCornersOutsideCircleSloppy(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double centerLat, double centerLon, double radiusMeters) {
        return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMinLon) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMinLon) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMaxLat, (double)rMaxLon) > radiusMeters || SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)rMinLat, (double)rMaxLon) > radiusMeters;
    }

    public static boolean rectWithinCircle(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double centerLat, double centerLon, double radiusMeters, boolean approx) {
        return !GeoRelationUtils.rectAnyCornersOutsideCircle(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, radiusMeters, approx);
    }

    public static boolean rectCrossesCircle(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double centerLat, double centerLon, double radiusMeters, boolean approx) {
        if (approx ? GeoRelationUtils.rectAnyCornersInCircle(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, radiusMeters, approx) : GeoRelationUtils.rectAnyCornersInCircle(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, radiusMeters, approx) && GeoRelationUtils.rectAnyCornersOutsideCircle(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, radiusMeters, approx)) {
            return true;
        }
        return GeoRelationUtils.isClosestPointOnRectWithinRange(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, radiusMeters, approx);
    }

    private static boolean isClosestPointOnRectWithinRange(double rMinLat, double rMaxLat, double rMinLon, double rMaxLon, double centerLat, double centerLon, double radiusMeters, boolean approx) {
        boolean haverShortCut;
        double[] closestPt = new double[]{0.0, 0.0};
        GeoDistanceUtils.closestPointOnBBox(rMinLat, rMaxLat, rMinLon, rMaxLon, centerLat, centerLon, closestPt);
        boolean bl = haverShortCut = SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)closestPt[0], (double)closestPt[1]) <= radiusMeters;
        if (approx || haverShortCut) {
            return haverShortCut;
        }
        double lon1 = rMinLon;
        double lon2 = rMaxLon;
        double lat1 = rMinLat;
        double lat2 = rMaxLat;
        if (closestPt[1] == rMinLon || closestPt[1] == rMaxLon) {
            lon2 = lon1 = closestPt[1];
        } else if (closestPt[0] == rMinLat || closestPt[0] == rMaxLat) {
            lat2 = lat1 = closestPt[0];
        }
        return GeoRelationUtils.lineCrossesSphere(lat1, lon1, 0.0, lat2, lon2, 0.0, centerLat, centerLon, 0.0, radiusMeters);
    }

    private static boolean lineCrossesSphere(double lat1, double lon1, double alt1, double lat2, double lon2, double alt2, double centerLat, double centerLon, double centerAlt, double radiusMeters) {
        double[] ecf1 = GeoProjectionUtils.llaToECF(lat1, lon1, alt1, null);
        double[] ecf2 = GeoProjectionUtils.llaToECF(lat2, lon2, alt2, null);
        double[] cntr = GeoProjectionUtils.llaToECF(centerLat, centerLon, centerAlt, null);
        double[] oneEighty = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(centerLat, centerLon, 180.0, radiusMeters, new double[3]);
        GeoProjectionUtils.llaToECF(oneEighty[1], oneEighty[0], 0.0, oneEighty);
        radiusMeters = GeoDistanceUtils.linearDistance(oneEighty, cntr);
        double dX = ecf2[0] - ecf1[0];
        double dY = ecf2[1] - ecf1[1];
        double dZ = ecf2[2] - ecf1[2];
        double fX = ecf1[0] - cntr[0];
        double fY = ecf1[1] - cntr[1];
        double fZ = ecf1[2] - cntr[2];
        double a = dX * dX + dY * dY + dZ * dZ;
        double b = 2.0 * (fX * dX + fY * dY + fZ * dZ);
        double c = fX * fX + fY * fY + fZ * fZ - radiusMeters * radiusMeters;
        double discrim = b * b - 4.0 * a * c;
        if (discrim < 0.0) {
            return false;
        }
        discrim = StrictMath.sqrt(discrim);
        double a2 = 2.0 * a;
        double t1 = (-b - discrim) / a2;
        double t2 = (-b + discrim) / a2;
        if (t1 < 0.0 || t1 > 1.0) {
            return !(t2 < 0.0) && !(t2 > 1.0);
        }
        return true;
    }
}

