/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.util.SloppyMath;

public class GeoDistanceUtils {
    public static final double DISTANCE_PCT_ERR = 0.005;

    private GeoDistanceUtils() {
    }

    public static double linearDistance(double[] pt1, double[] pt2) {
        assert (pt1 != null && pt2 != null && pt1.length == pt2.length && pt1.length > 1);
        double d0 = pt1[0] - pt2[0];
        double d1 = pt1[1] - pt2[1];
        if (pt1.length == 3) {
            double d2 = pt1[2] - pt2[2];
            return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        }
        return Math.sqrt(d0 * d0 + d1 * d1);
    }

    public static double distanceToDegreesLon(double lat, double distance) {
        lat = StrictMath.toRadians(lat);
        double diameter = 1.2756274E7;
        double a = StrictMath.sin(distance / 1.2756274E7);
        double h = StrictMath.min(1.0, a);
        h *= h;
        double cLat = StrictMath.cos(lat);
        return StrictMath.toDegrees(StrictMath.acos(1.0 - 2.0 * h / (cLat * cLat)));
    }

    public static void closestPointOnBBox(double rMinY, double rMaxY, double rMinX, double rMaxX, double lat, double lon, double[] closestPt) {
        assert (closestPt != null && closestPt.length == 2);
        closestPt[0] = 0.0;
        closestPt[1] = 0.0;
        boolean xSet = true;
        boolean ySet = true;
        if (lon > rMaxX) {
            closestPt[1] = rMaxX;
        } else if (lon < rMinX) {
            closestPt[1] = rMinX;
        } else {
            xSet = false;
        }
        if (lat > rMaxY) {
            closestPt[0] = rMaxY;
        } else if (lat < rMinY) {
            closestPt[0] = rMinY;
        } else {
            ySet = false;
        }
        if (closestPt[0] == 0.0 && !ySet) {
            closestPt[0] = lat;
        }
        if (closestPt[1] == 0.0 && !xSet) {
            closestPt[1] = lon;
        }
    }

    public static double maxRadialDistanceMeters(double centerLat, double centerLon) {
        if (Math.abs(centerLat) == 90.0) {
            return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)0.0, (double)centerLon);
        }
        return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)centerLat, (double)((180.0 + centerLon) % 360.0));
    }
}

